/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import java.util.EnumSet;
import java.util.List;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.util.NEHRP_TestCity;
import org.opensha.sha.util.TectonicRegionType;

public class Params {
    public static EnumParameter<SiteType> createSiteType() {
        return new EnumParameter<SiteType>("Site Type", EnumSet.of(SiteType.FIRM_ROCK, SiteType.HARD_ROCK), SiteType.FIRM_ROCK, null);
    }

    public static EnumParameter<TectonicRegionType> createSubType() {
        return new EnumParameter<TectonicRegionType>("Subduction Type", EnumSet.of(TectonicRegionType.SUBDUCTION_INTERFACE, TectonicRegionType.SUBDUCTION_SLAB), TectonicRegionType.SUBDUCTION_INTERFACE, null);
    }

    public static BooleanParameter createGlobalFlag() {
        BooleanParameter b = new BooleanParameter("Global", true);
        b.setValueAsDefault();
        return b;
    }

    public static EnumParameter<SourceRegion> createSourceRegion() {
        return new EnumParameter<Object>("Filter by region", EnumSet.allOf(SourceRegion.class), null, "All");
    }

    public static EnumParameter<SourceType> createSourceType() {
        return new EnumParameter<Object>("Filter by type", EnumSet.allOf(SourceType.class), null, "All");
    }

    public static StringParameter createFileParam(List<String> names, String value) {
        StringConstraint sc = new StringConstraint(names);
        value = names.contains(value) ? value : names.get(0);
        StringParameter param = new StringParameter("File", sc, value);
        return param;
    }

    public static StringParameter createSourceDataParam() {
        StringParameter param = new StringParameter("Info");
        param.getEditor().setEnabled(false);
        param.setNonEditable();
        return param;
    }

    public static EnumParameter<NEHRP_TestCity> createCityParam() {
        return new EnumParameter<NEHRP_TestCity>("Select City", EnumSet.allOf(NEHRP_TestCity.class), NEHRP_TestCity.MEMPHIS, null);
    }

    public static EnumParameter<Period> createPeriodParam() {
        return new EnumParameter<Period>("Select Period", Period.getCEUS(), Period.GM0P00, null);
    }
}

