/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.calc.sectionDists;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelPrefDataFinal;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class FaultSectDistCalcTest {
    static DecimalFormat df = new DecimalFormat("0.00");
    static long distCalcs = 0L;

    public static String getTime(long start, long end) {
        double secs = (double)(end - start) / 1000.0;
        if (secs < 60.0) {
            return df.format(secs) + " secs";
        }
        double mins = secs / 60.0;
        return df.format(mins) + " mins";
    }

    public static void printDistCalcTimes(long start, long end) {
        double secs = (double)(end - start) / 1000.0;
        double cps = (double)distCalcs / secs;
        System.out.println("Distance calcs: " + distCalcs + ", " + df.format(cps) + " calcs/sec");
    }

    public static String getHash(int id1, int id2) {
        if (id1 < id2) {
            return id1 + "_" + id2;
        }
        return id2 + "_" + id1;
    }

    public static int[] decodeHash(String hash) {
        String[] split = hash.split("_");
        int[] ints = new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1])};
        return ints;
    }

    public static double getSurfaceDist(FrankelGriddedSurface surface1, FrankelGriddedSurface surface2, boolean fast) {
        double minDist = Double.MAX_VALUE;
        for (Location loc1 : surface1) {
            for (Location loc2 : surface2) {
                double dist = fast ? LocationUtils.linearDistanceFast(loc1, loc2) : LocationUtils.linearDistance(loc1, loc2);
                if (dist < minDist) {
                    minDist = dist;
                }
                ++distCalcs;
            }
        }
        return minDist;
    }

    public static void main(String[] args) throws IOException {
        int deformationModelId = 82;
        DecimalFormat pdf = new DecimalFormat("0.00%");
        double disc = 1.0;
        System.out.println("Discretization: " + disc + " KM");
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        ArrayList<FaultSectionPrefData> data = deformationModelPrefDB.getAllFaultSectionPrefData(deformationModelId);
        ArrayList<FrankelGriddedSurface> surfaces = new ArrayList<FrankelGriddedSurface>();
        int num = data.size();
        Object outputString = new String();
        outputString = (String)outputString + "Section Distances\n";
        int combos = 0;
        long startTrace = System.currentTimeMillis();
        HashMap<String, Double> traceDists = new HashMap<String, Double>();
        for (FaultSectionPrefData data1 : data) {
            for (FaultSectionPrefData data2 : data) {
                String hash;
                if (data1 == data2 || traceDists.containsKey(hash = FaultSectDistCalcTest.getHash(data1.getSectionId(), data2.getSectionId()))) continue;
                FaultTrace trace1 = data1.getFaultTrace();
                FaultTrace trace2 = data2.getFaultTrace();
                double minDist = trace2.getMinDistance(trace1, disc);
                ++combos;
                traceDists.put(hash, minDist);
            }
        }
        long endTrace = System.currentTimeMillis();
        FileUtils.saveObjectInFile("traceDists.obj", traceDists);
        System.out.println("There are " + num + " fault sections, and " + combos + " combinations");
        System.out.println("took " + FaultSectDistCalcTest.getTime(startTrace, endTrace) + " to calc with traces");
        System.exit(0);
        long startFullFast = System.currentTimeMillis();
        System.out.println("Creating fault surfaces");
        for (int i = 0; i < num; ++i) {
            FaultSectionPrefData data1 = data.get(i);
            SimpleFaultData simpleFaultData = data1.getSimpleFaultData(false);
            FrankelGriddedSurface surface = new FrankelGriddedSurface(simpleFaultData, disc);
            surfaces.add(surface);
        }
        System.out.println("Calculating distances");
        HashMap<String, Double> fullDistsFast = new HashMap<String, Double>();
        int count = 0;
        distCalcs = 0L;
        for (int i = 0; i < surfaces.size(); ++i) {
            FrankelGriddedSurface surface1 = (FrankelGriddedSurface)surfaces.get(i);
            for (int j = 0; j < surfaces.size(); ++j) {
                String hash;
                FrankelGriddedSurface surface2 = (FrankelGriddedSurface)surfaces.get(j);
                if (surface1 == surface2 || fullDistsFast.containsKey(hash = FaultSectDistCalcTest.getHash(data.get(i).getSectionId(), data.get(j).getSectionId()))) continue;
                double minDist = FaultSectDistCalcTest.getSurfaceDist(surface1, surface2, true);
                if (++count % (combos / 4) == 0) {
                    double pDone = (double)count / (double)combos;
                    System.out.println(count + "/" + combos + " (" + FaultSectDistCalcTest.getTime(startFullFast, System.currentTimeMillis()) + " " + pdf.format(pDone) + ")");
                }
                fullDistsFast.put(hash, minDist);
            }
        }
        long endFullFast = System.currentTimeMillis();
        FileUtils.saveObjectInFile("fullDistsFast.obj", fullDistsFast);
        System.out.println("took " + FaultSectDistCalcTest.getTime(startFullFast, endFullFast) + " to calc with surface points, fast dist");
        FaultSectDistCalcTest.printDistCalcTimes(startFullFast, endFullFast);
        long startFull = System.currentTimeMillis();
        System.out.println("Creating fault surfaces");
        surfaces.clear();
        for (int i = 0; i < num; ++i) {
            FaultSectionPrefData data1 = data.get(i);
            SimpleFaultData simpleFaultData = data1.getSimpleFaultData(false);
            FrankelGriddedSurface surface = new FrankelGriddedSurface(simpleFaultData, disc);
            surfaces.add(surface);
        }
        HashMap<String, Double> fullDists = new HashMap<String, Double>();
        System.out.println("Calculating distances");
        count = 0;
        distCalcs = 0L;
        for (int i = 0; i < surfaces.size(); ++i) {
            FrankelGriddedSurface surface1 = (FrankelGriddedSurface)surfaces.get(i);
            for (int j = 0; j < surfaces.size(); ++j) {
                String hash;
                FrankelGriddedSurface surface2 = (FrankelGriddedSurface)surfaces.get(j);
                if (surface1 == surface2 || fullDists.containsKey(hash = FaultSectDistCalcTest.getHash(data.get(i).getSectionId(), data.get(j).getSectionId()))) continue;
                double minDist = FaultSectDistCalcTest.getSurfaceDist(surface1, surface2, false);
                if (++count % (combos / 4) == 0) {
                    double pDone = (double)count / (double)combos;
                    System.out.println(count + "/" + combos + " (" + FaultSectDistCalcTest.getTime(startFull, System.currentTimeMillis()) + " " + pdf.format(pDone) + ")");
                }
                fullDists.put(hash, minDist);
            }
        }
        long endFull = System.currentTimeMillis();
        FileUtils.saveObjectInFile("fullDists.obj", fullDists);
        System.out.println("took " + FaultSectDistCalcTest.getTime(startFull, endFull) + " to calc with surface points");
        FaultSectDistCalcTest.printDistCalcTimes(startFull, endFull);
    }
}

