/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.calc.sectionDists;

import org.opensha.refFaultParamDb.calc.sectionDists.SurfaceFilter;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;

public class SmartSurfaceFilter
implements SurfaceFilter {
    private int internalModulus;
    private int outlineModulus;
    private double cornerMidptDistFilter;

    public SmartSurfaceFilter(int outlineModulus, int internalModulus, double cornerMidptDistFilter) {
        if (internalModulus < 2) {
            internalModulus = 2;
        }
        this.internalModulus = internalModulus;
        if (outlineModulus < 1) {
            outlineModulus = 1;
        }
        this.outlineModulus = outlineModulus;
        this.cornerMidptDistFilter = cornerMidptDistFilter;
    }

    @Override
    public boolean isIncluded(EvenlyGriddedSurface surface, int row, int col) {
        if (SmartSurfaceFilter.isCorner(surface, row, col)) {
            return true;
        }
        if (row == 0) {
            return row % this.outlineModulus == 0;
        }
        if (col == 0) {
            return col % this.outlineModulus == 0;
        }
        if (row == surface.getNumRows() - 1) {
            return row % this.outlineModulus == 0;
        }
        if (col == surface.getNumCols() - 1) {
            return col % this.outlineModulus == 0;
        }
        return row % this.internalModulus == 0 && col % this.internalModulus == 0;
    }

    private static boolean isCorner(EvenlyGriddedSurface surface, int row, int col) {
        if (row == 0 || row == surface.getNumRows() - 1) {
            return col == 0 || col == surface.getNumCols() - 1;
        }
        return false;
    }

    @Override
    public double getCornerMidptFilterDist() {
        return this.cornerMidptDistFilter;
    }

    public int getInternalModulus() {
        return this.internalModulus;
    }

    public int getOutlineModulus() {
        return this.outlineModulus;
    }
}

