/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.XY_EstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class DiscreteValueEstimateDB_DAO
implements EstimateDAO_API {
    public static final String EST_TYPE_NAME = "DiscreteValueEstimate";
    private static final String ERR_MSG = "This class just deals with Discrete Estimates";
    private XY_EstimateDB_DAO xyEstimateDB_DAO = new XY_EstimateDB_DAO();

    public DiscreteValueEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public DiscreteValueEstimateDB_DAO() {
    }

    @Override
    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.xyEstimateDB_DAO.setDB_Connection(dbAccessAPI);
    }

    @Override
    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        if (!(estimate instanceof DiscreteValueEstimate)) {
            throw new InsertException(ERR_MSG);
        }
        DiscreteValueEstimate discreteValueEstimate = (DiscreteValueEstimate)estimate;
        this.xyEstimateDB_DAO.addEstimate(estimateInstanceId, discreteValueEstimate.getValues());
    }

    @Override
    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        this.xyEstimateDB_DAO.getEstimate(estimateInstanceId, func);
        DiscreteValueEstimate estimate = new DiscreteValueEstimate(func, false);
        return estimate;
    }

    @Override
    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        return this.xyEstimateDB_DAO.removeEstimate(estimateInstanceId);
    }

    @Override
    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }
}

