/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PaleoEventDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.EventSequence;
import org.opensha.refFaultParamDb.vo.PaleoEvent;

public class EventSequenceDB_DAO {
    private static final String TABLE_NAME = "Event_Sequence";
    private static final String TABLE_SEQUENCE_NAME = "Event_Sequence_Sequence";
    private static final String SEQUENCE_ID = "Sequence_Id";
    private static final String SEQUENCE_NAME = "Sequence_Name";
    private static final String INFO_ID = "Info_Id";
    private static final String SEQUENCE_PROB = "Sequence_Probability";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String GENERAL_COMMENT = "General_Comments";
    private static final String SEQUENCE_EVENT_LIST_TABLE_NAME = "Event_Sequence_Event_List";
    private static final String EVENT_ID = "Event_Id";
    private static final String EVENT_ENTRY_DATE = "Event_Entry_Date";
    private static final String SEQUENCE_ENTRY_DATE = "Sequence_Entry_Date";
    private static final String MISSED_PROB = "Missed_Prob";
    private static final String EVENT_INDEX_IN_SEQUENCE = "Event_Index_In_Sequence";
    private DB_AccessAPI dbAccess;

    public EventSequenceDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
    }

    public void addEventSequence(int infoId, String entryDate, ArrayList<EventSequence> sequenceList) {
        try {
            for (int i = 0; i < sequenceList.size(); ++i) {
                EventSequence eventSequence = sequenceList.get(i);
                int sequenceId = this.dbAccess.getNextSequenceNumber(TABLE_SEQUENCE_NAME);
                String sql = "insert into Event_Sequence(Sequence_Id,Sequence_Name,Info_Id,Entry_Date,Sequence_Probability,General_Comments) values (" + sequenceId + ",'" + eventSequence.getSequenceName() + "'," + infoId + ",'" + entryDate + "'," + eventSequence.getSequenceProb() + ",'" + eventSequence.getComments() + "')";
                this.dbAccess.insertUpdateOrDeleteData(sql);
                ArrayList<PaleoEvent> eventsInSequence = eventSequence.getEventsParam();
                double[] missedProbs = eventSequence.getMissedEventsProbs();
                int numEventsInSequence = eventsInSequence.size();
                for (int j = 0; j < numEventsInSequence; ++j) {
                    PaleoEvent paleoEvent = eventsInSequence.get(j);
                    sql = "insert into Event_Sequence_Event_List(Event_Id,Event_Entry_Date,Sequence_Id,Sequence_Entry_Date,Missed_Prob,Event_Index_In_Sequence) values (" + paleoEvent.getEventId() + ",'" + paleoEvent.getEntryDate() + "'," + sequenceId + ",'" + entryDate + "'," + missedProbs[j] + "," + j + ")";
                    this.dbAccess.insertUpdateOrDeleteData(sql);
                    if (j != numEventsInSequence - 1) continue;
                    sql = "insert into Event_Sequence_Event_List(Event_Id,Event_Entry_Date,Sequence_Id,Sequence_Entry_Date,Missed_Prob,Event_Index_In_Sequence) values (" + paleoEvent.getEventId() + ",'" + paleoEvent.getEntryDate() + "'," + sequenceId + ",'" + entryDate + "'," + missedProbs[++j] + "," + j + ")";
                    this.dbAccess.insertUpdateOrDeleteData(sql);
                }
            }
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public ArrayList<EventSequence> getSequences(int infoId, String entryDate) {
        String condition = " where Info_Id=" + infoId + " and Entry_Date='" + entryDate + "'";
        return this.query(condition);
    }

    private ArrayList<EventSequence> query(String condition) {
        ArrayList<EventSequence> sequenceList = new ArrayList<EventSequence>();
        String sql = "select Sequence_Id,Sequence_Name,Info_Id,to_char(Entry_Date) as Entry_Date,(Sequence_Probability+0) Sequence_Probability,General_Comments from Event_Sequence " + condition;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            PaleoEventDB_DAO paleoEventDAO = new PaleoEventDB_DAO(this.dbAccess);
            while (rs.next()) {
                EventSequence eventSequence = new EventSequence();
                eventSequence.setSequenceName(rs.getString(SEQUENCE_NAME));
                eventSequence.setSequenceProb(rs.getFloat(SEQUENCE_PROB));
                eventSequence.setComments(rs.getString(GENERAL_COMMENT));
                sql = "select Event_Id,(Missed_Prob+0) Missed_Prob from Event_Sequence_Event_List where Sequence_Id=" + rs.getInt(SEQUENCE_ID) + " and Sequence_Entry_Date='" + rs.getString(ENTRY_DATE) + "' order by Event_Index_In_Sequence";
                CachedRowSet eventsResults = this.dbAccess.queryData(sql);
                ArrayList<PaleoEvent> events = new ArrayList<PaleoEvent>();
                ArrayList<Double> probsList = new ArrayList<Double>();
                while (eventsResults.next()) {
                    events.add(paleoEventDAO.getEvent(eventsResults.getInt(EVENT_ID)));
                    probsList.add(Double.valueOf(eventsResults.getFloat(MISSED_PROB)));
                }
                events.remove(events.size() - 1);
                eventSequence.setEventsParam(events);
                double[] probs = new double[probsList.size()];
                for (int i = 0; i < probsList.size(); ++i) {
                    probs[i] = (Double)probsList.get(i);
                }
                eventSequence.setMissedEventsProbList(probs);
                sequenceList.add(eventSequence);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return sequenceList;
    }
}

