/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.TimeInstanceDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoEvent;
import org.opensha.refFaultParamDb.vo.Reference;

public class PaleoEventDB_DAO {
    private static final String TABLE_NAME = "Paleo_Event";
    private static final String EVENT_ID = "Event_Id";
    private static final String EVENT_NAME = "Event_Name";
    private static final String SITE_ID = "Site_Id";
    private static final String SITE_ENTRY_DATE = "Site_Entry_Date";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    private static final String EVENT_DATE_EST_ID = "Event_Date_Est_Id";
    private static final String DISPLACEMENT_EST_ID = "Displacement_Est_Id";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String GENERAL_COMMENTS = "General_Comments";
    private static final String SEQUENCE_NAME = "Paleo_Event_Sequence";
    private static final String REFERENCES_TABLE_NAME = "Paleo_Event_References";
    private static final String REFERENCE_ID = "Reference_Id";
    private static final String PALEO_EVENT_ENTRY_DATE = "Paleo_Event_Entry_Date";
    private static final String PALEO_EVENT_ID = "Paleo_Event_Id";
    private static final String SENSE_OF_MOTION_RAKE = "Sense_of_Motion_Rake";
    private static final String SENSE_OF_MOTION_QUAL = "Sense_of_Motion_Qual";
    private static final String MEASURED_SLIP_COMP_QUAL = "Measured_Slip_Comp_Qual";
    private DB_AccessAPI dbAccess;
    private ReferenceDB_DAO referenceDAO;
    private TimeInstanceDB_DAO timeInstanceDAO;
    private EstimateInstancesDB_DAO estimateInstancesDAO;

    public PaleoEventDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.referenceDAO = new ReferenceDB_DAO(dbAccess);
        this.timeInstanceDAO = new TimeInstanceDB_DAO(dbAccess);
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(this.dbAccess);
    }

    public void addPaleoevent(PaleoEvent paleoEvent) throws InsertException {
        int displacementEstId;
        int eventTimeEstId;
        String systemDate;
        int paleoEventId;
        try {
            paleoEventId = this.dbAccess.getNextSequenceNumber(SEQUENCE_NAME);
            systemDate = this.dbAccess.getSystemDate();
            eventTimeEstId = this.timeInstanceDAO.addTimeInstance(paleoEvent.getEventTime());
            displacementEstId = paleoEvent.isDisplacementShared() ? paleoEvent.getDisplacementEstId() : this.estimateInstancesDAO.addEstimateInstance(paleoEvent.getDisplacementEst());
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String somQual = paleoEvent.getSenseOfMotionQual();
        String measuredCompQual = paleoEvent.getMeasuredComponentQual();
        Object colNames = "";
        Object colVals = "";
        EstimateInstances somRake = paleoEvent.getSenseOfMotionRake();
        if (somRake != null) {
            colNames = (String)colNames + "Sense_of_Motion_Rake,";
            int rakeEstId = this.estimateInstancesDAO.addEstimateInstance(somRake);
            colVals = (String)colVals + rakeEstId + ",";
        }
        if (somQual != null) {
            colNames = (String)colNames + "Sense_of_Motion_Qual,";
            colVals = (String)colVals + "'" + somQual + "',";
        }
        if (measuredCompQual != null) {
            colNames = (String)colNames + "Measured_Slip_Comp_Qual,";
            colVals = (String)colVals + "'" + measuredCompQual + "',";
        }
        String sql = "insert into Paleo_Event(Event_Id,Event_Name,Site_Id,Site_Entry_Date,Contributor_Id,Event_Date_Est_Id,Displacement_Est_Id,Entry_Date," + (String)colNames + "General_Comments) values (" + paleoEventId + ",'" + paleoEvent.getEventName() + "'," + paleoEvent.getSiteId() + ",'" + paleoEvent.getSiteEntryDate() + "'," + SessionInfo.getContributor().getId() + "," + eventTimeEstId + "," + displacementEstId + ",'" + systemDate + "'," + (String)colVals + "'" + paleoEvent.getComments() + "')";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
            ArrayList<Reference> referenceList = paleoEvent.getReferenceList();
            for (int i = 0; i < referenceList.size(); ++i) {
                int referenceId = referenceList.get(i).getReferenceId();
                sql = "insert into Paleo_Event_References(Paleo_Event_Id,Paleo_Event_Entry_Date,Reference_Id) values (" + paleoEventId + ",'" + systemDate + "'," + referenceId + ")";
                this.dbAccess.insertUpdateOrDeleteData(sql);
            }
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public int checkSameDisplacement(ArrayList<String> eventNames) {
        Object values = "(";
        for (int i = 0; i < eventNames.size(); ++i) {
            values = (String)values + "'" + eventNames.get(i) + "'";
            if (i == eventNames.size() - 1) continue;
            values = (String)values + ",";
        }
        values = (String)values + ")";
        String sql = "select Displacement_Est_Id from Paleo_Event where Event_Name in " + (String)values;
        int dispEstId = -1;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                if (dispEstId != -1 && dispEstId != rs.getInt(DISPLACEMENT_EST_ID)) {
                    return -1;
                }
                dispEstId = rs.getInt(DISPLACEMENT_EST_ID);
            }
        }
        catch (SQLException sqlException) {
            throw new QueryException(sqlException.getMessage());
        }
        return dispEstId;
    }

    public ArrayList<PaleoEvent> getAllEvents(int siteId) throws QueryException {
        String condition = " where Site_Id=" + siteId;
        return this.query(condition);
    }

    public PaleoEvent getEvent(int eventId) throws QueryException {
        String condition = " where Event_Id=" + eventId;
        ArrayList<PaleoEvent> paleoEventList = this.query(condition);
        PaleoEvent paleoEvent = null;
        if (paleoEventList.size() > 0) {
            paleoEvent = paleoEventList.get(0);
        }
        return paleoEvent;
    }

    public ArrayList<String> getEventNamesForDisplacement(int displacementEstId) throws QueryException {
        ArrayList<String> eventNames = new ArrayList<String>();
        String sql = "select Event_Name from Paleo_Event where Displacement_Est_Id=" + displacementEstId;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                eventNames.add(rs.getString(EVENT_NAME));
            }
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return eventNames;
    }

    private ArrayList<PaleoEvent> query(String condition) {
        ArrayList<PaleoEvent> paleoEventList = new ArrayList<PaleoEvent>();
        String sql = "select Event_Id,Event_Name,Site_Id,to_char(Site_Entry_Date) as Site_Entry_Date,Contributor_Id,Event_Date_Est_Id,Displacement_Est_Id,to_char(Entry_Date) as Entry_Date,General_Comments,Sense_of_Motion_Rake,Sense_of_Motion_Qual,Measured_Slip_Comp_Qual from Paleo_Event " + condition;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            ContributorDB_DAO contributorDAO = new ContributorDB_DAO(this.dbAccess);
            while (rs.next()) {
                PaleoEvent paleoEvent = new PaleoEvent();
                paleoEvent.setEventId(rs.getInt(EVENT_ID));
                paleoEvent.setEventName(rs.getString(EVENT_NAME));
                paleoEvent.setSiteId(rs.getInt(SITE_ID));
                paleoEvent.setSiteEntryDate(rs.getString(SITE_ENTRY_DATE));
                paleoEvent.setContributorName(contributorDAO.getContributor(rs.getInt(CONTRIBUTOR_ID)).getName());
                paleoEvent.setEventTime(this.timeInstanceDAO.getTimeInstance(rs.getInt(EVENT_DATE_EST_ID)));
                paleoEvent.setDisplacementEstId(rs.getInt(DISPLACEMENT_EST_ID));
                paleoEvent.setDisplacementEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(DISPLACEMENT_EST_ID)));
                paleoEvent.setEntryDate(rs.getString(ENTRY_DATE));
                paleoEvent.setComments(rs.getString(GENERAL_COMMENTS));
                ArrayList<Reference> referenceList = new ArrayList<Reference>();
                sql = "select Reference_Id from Paleo_Event_References where Paleo_Event_Id=" + paleoEvent.getEventId() + " and Paleo_Event_Entry_Date='" + paleoEvent.getEntryDate() + "'";
                CachedRowSet referenceResultSet = this.dbAccess.queryData(sql);
                while (referenceResultSet.next()) {
                    referenceList.add(this.referenceDAO.getReference(referenceResultSet.getInt(REFERENCE_ID)));
                }
                referenceResultSet.close();
                paleoEvent.setReferenceList(referenceList);
                int senseOfMotionRakeId = rs.getInt(SENSE_OF_MOTION_RAKE);
                EstimateInstances senseOfMotionRake = null;
                if (!rs.wasNull()) {
                    senseOfMotionRake = this.estimateInstancesDAO.getEstimateInstance(senseOfMotionRakeId);
                }
                String senseOfMotionQual = rs.getString(SENSE_OF_MOTION_QUAL);
                if (rs.wasNull()) {
                    senseOfMotionQual = null;
                }
                String measuedCompQual = rs.getString(MEASURED_SLIP_COMP_QUAL);
                if (rs.wasNull()) {
                    measuedCompQual = null;
                }
                paleoEvent.setSenseOfMotionRake(senseOfMotionRake);
                paleoEvent.setSenseOfMotionQual(senseOfMotionQual);
                paleoEvent.setMeasuredComponentQual(measuedCompQual);
                paleoEventList.add(paleoEvent);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return paleoEventList;
    }
}

