/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PaleoSitePublicationsDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.PaleoSiteSummary;

public class PaleoSiteDB_DAO {
    private static final String SEQUENCE_NAME = "Paleo_Site_Sequence";
    private static final String TABLE_NAME = "Paleo_Site";
    private static final String SITE_ID = "Site_Id";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String SITE_NAME = "Site_Name";
    private static final String SITE_LOCATION1 = "Site_Location1";
    private static final String SITE_LOCATION2 = "Site_Location2";
    private static final String GENERAL_COMMENTS = "General_Comments";
    private static final String OLD_SITE_ID = "Old_Site_Id";
    private static final String DIP_EST_ID = "Dip_Est_Id";
    private static final int SRID = 8307;
    private DB_AccessAPI dbAccess;
    private EstimateInstancesDB_DAO estimateInstancesDAO;
    private PaleoSitePublicationsDB_DAO paleoSitePublicationDAO;

    public PaleoSiteDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccess);
        this.paleoSitePublicationDAO = new PaleoSitePublicationsDB_DAO(dbAccess);
    }

    public void addPaleoSite(PaleoSite paleoSite) throws InsertException {
        String systemDate;
        int paleoSiteId = paleoSite.getSiteId();
        try {
            if (paleoSiteId <= 0) {
                paleoSiteId = this.dbAccess.getNextSequenceNumber(SEQUENCE_NAME);
            }
            systemDate = this.dbAccess.getSystemDate();
            paleoSite.setSiteId(paleoSiteId);
            paleoSite.setEntryDate(systemDate);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        JGeometry location1 = !Float.isNaN(paleoSite.getSiteElevation1()) ? new JGeometry((double)paleoSite.getSiteLon1(), (double)paleoSite.getSiteLat1(), (double)paleoSite.getSiteElevation1(), 8307) : new JGeometry((double)paleoSite.getSiteLon1(), (double)paleoSite.getSiteLat1(), 8307);
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        geomteryObjectList.add(location1);
        Object colNames = "";
        Object colVals = "";
        EstimateInstances dipEst = paleoSite.getDipEstimate();
        if (dipEst != null) {
            colNames = "Dip_Est_Id,";
            int id = this.estimateInstancesDAO.addEstimateInstance(dipEst);
            colVals = id + ",";
        }
        if (!Float.isNaN(paleoSite.getSiteLat1())) {
            JGeometry location2 = !Float.isNaN(paleoSite.getSiteElevation2()) ? new JGeometry((double)paleoSite.getSiteLon2(), (double)paleoSite.getSiteLat2(), (double)paleoSite.getSiteElevation2(), 8307) : new JGeometry((double)paleoSite.getSiteLon2(), (double)paleoSite.getSiteLat2(), 8307);
            geomteryObjectList.add(location2);
            colNames = (String)colNames + "Site_Location2,";
            colVals = (String)colVals + "?,";
        }
        String sql = "insert into Paleo_Site(Site_Id,Entry_Date,Site_Name,Site_Location1," + (String)colNames + "General_Comments,Old_Site_Id)  values (" + paleoSiteId + ",'" + systemDate + "','" + paleoSite.getSiteName() + "',?," + (String)colVals + "'" + paleoSite.getGeneralComments() + "','" + paleoSite.getOldSiteId() + "')";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
            ArrayList<PaleoSitePublication> paleoSitePubList = paleoSite.getPaleoSitePubList();
            for (int i = 0; i < paleoSitePubList.size(); ++i) {
                PaleoSitePublication paleoSitePub = paleoSitePubList.get(i);
                paleoSitePub.setSiteId(paleoSiteId);
                paleoSitePub.setSiteEntryDate(systemDate);
                this.paleoSitePublicationDAO.addPaleoSitePublicationInfo(paleoSitePub);
            }
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public PaleoSite getPaleoSite(int paleoSiteId) throws QueryException {
        String condition = " where Site_Id=" + paleoSiteId;
        ArrayList<PaleoSite> paleoSiteList = this.query(condition);
        PaleoSite paleoSite = null;
        if (paleoSiteList.size() > 0) {
            paleoSite = paleoSiteList.get(0);
        }
        return paleoSite;
    }

    public PaleoSite getPaleoSiteByQfaultId(String qFaultSiteId) throws QueryException {
        String condition = " where Old_Site_Id='" + qFaultSiteId + "'";
        ArrayList<PaleoSite> paleoSiteList = this.query(condition);
        PaleoSite paleoSite = null;
        if (paleoSiteList.size() > 0) {
            paleoSite = paleoSiteList.get(0);
        }
        return paleoSite;
    }

    public PaleoSite getPaleoSite(String paleoSiteName) throws QueryException {
        String condition = " where Site_Name='" + paleoSiteName + "'";
        ArrayList<PaleoSite> paleoSiteList = this.query(condition);
        PaleoSite paleoSite = null;
        if (paleoSiteList.size() > 0) {
            paleoSite = paleoSiteList.get(0);
        }
        return paleoSite;
    }

    public ArrayList<PaleoSiteSummary> getAllPaleoSiteNames() throws QueryException {
        ArrayList<PaleoSiteSummary> paleoSiteSummaryList = new ArrayList<PaleoSiteSummary>();
        String sql = "select Site_Id,Site_Name from Paleo_Site order by Site_Name";
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                PaleoSiteSummary paleoSiteSummary = new PaleoSiteSummary();
                paleoSiteSummary.setSiteId(rs.getInt(SITE_ID));
                paleoSiteSummary.setSiteName(rs.getString(SITE_NAME));
                paleoSiteSummaryList.add(paleoSiteSummary);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return paleoSiteSummaryList;
    }

    public ArrayList<PaleoSite> getPaleoSiteNameIdAndLocations() throws QueryException {
        ArrayList<PaleoSite> paleoSiteList = new ArrayList<PaleoSite>();
        String sqlWithSpatialColumnNames = "select Site_Id,Site_Name,Site_Location1,Site_Location2 from Paleo_Site";
        String sqlWithNoSpatialColumnNames = "select Site_Id,Site_Name from Paleo_Site";
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(SITE_LOCATION1);
        spatialColumnNames.add(SITE_LOCATION2);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                PaleoSite paleoSite = new PaleoSite();
                paleoSite.setSiteId(rs.getInt(SITE_ID));
                paleoSite.setSiteName(rs.getString(SITE_NAME));
                ArrayList<JGeometry> geometries = spatialQueryResult.getGeometryObjectsList(i++);
                this.setPaleoSiteLocations(paleoSite, geometries);
                paleoSiteList.add(paleoSite);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return paleoSiteList;
    }

    public boolean removePaleoSite(int paleoSiteId) throws UpdateException {
        String sql = "delete from Paleo_Site  where Site_Id=" + paleoSiteId;
        try {
            int numRows = this.dbAccess.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList<PaleoSite> getAllPaleoSites() throws QueryException {
        return this.query(" ");
    }

    private ArrayList<PaleoSite> query(String condition) throws QueryException {
        ArrayList<PaleoSite> paleoSiteList = new ArrayList<PaleoSite>();
        String sqlWithSpatialColumnNames = "select Site_Id,to_char(Entry_Date) as Entry_Date,Site_Name,Site_Location1,Site_Location2,Dip_Est_Id,General_Comments,Old_Site_Id from Paleo_Site" + condition;
        String sqlWithNoSpatialColumnNames = "select Site_Id,to_char(Entry_Date) as Entry_Date,Site_Name,Dip_Est_Id,General_Comments,Old_Site_Id from Paleo_Site" + condition;
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(SITE_LOCATION1);
        spatialColumnNames.add(SITE_LOCATION2);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                PaleoSite paleoSite = new PaleoSite();
                paleoSite.setSiteId(rs.getInt(SITE_ID));
                paleoSite.setEntryDate(rs.getString(ENTRY_DATE));
                paleoSite.setSiteName(rs.getString(SITE_NAME));
                int dipEstId = rs.getInt(DIP_EST_ID);
                if (!rs.wasNull()) {
                    paleoSite.setDipEstimate(this.estimateInstancesDAO.getEstimateInstance(dipEstId));
                }
                paleoSite.setGeneralComments(rs.getString(GENERAL_COMMENTS));
                paleoSite.setOldSiteId(rs.getString(OLD_SITE_ID));
                paleoSite.setPaleoSitePubList(this.paleoSitePublicationDAO.getPaleoSitePublicationInfo(rs.getInt(SITE_ID)));
                ArrayList<JGeometry> geometries = spatialQueryResult.getGeometryObjectsList(i++);
                this.setPaleoSiteLocations(paleoSite, geometries);
                paleoSiteList.add(paleoSite);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return paleoSiteList;
    }

    private void setPaleoSiteLocations(PaleoSite paleoSite, ArrayList<JGeometry> geometries) {
        JGeometry location1 = geometries.get(0);
        double[] point1 = location1.getPoint();
        JGeometry location2 = geometries.get(1);
        paleoSite.setSiteLat1((float)point1[1]);
        paleoSite.setSiteLon1((float)point1[0]);
        if (point1.length > 2) {
            paleoSite.setSiteElevation1((float)point1[2]);
        } else {
            paleoSite.setSiteElevation1(Float.NaN);
        }
        if (location2 != null) {
            double[] point2 = location2.getPoint();
            paleoSite.setSiteLat2((float)point2[1]);
            paleoSite.setSiteLon2((float)point2[0]);
            if (point2.length > 2) {
                paleoSite.setSiteElevation2((float)point2[2]);
            } else {
                paleoSite.setSiteElevation2(Float.NaN);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<Location> locList = new ArrayList<Location>();
        locList.add(new Location(37.5104, -121.8346));
        locList.add(new Location(33.7701, -117.4909));
        locList.add(new Location(33.2071, -116.7273));
        locList.add(new Location(33.41, -117.04));
        locList.add(new Location(33.9303, -117.8437));
        locList.add(new Location(35.4441, -117.6815));
        locList.add(new Location(34.9868, -118.508));
        locList.add(new Location(37.9306, -122.2977));
        locList.add(new Location(37.5563, -121.9739));
        locList.add(new Location(38.032, -122.7891));
        locList.add(new Location(36.9415, -121.6729));
        locList.add(new Location(38.52, -123.24));
        locList.add(new Location(37.5207, -122.5135));
        locList.add(new Location(33.6153, -116.7091));
        locList.add(new Location(32.9975, -115.9436));
        locList.add(new Location(33.973, -116.817));
        locList.add(new Location(35.154, -119.7));
        locList.add(new Location(33.7414, -116.187));
        locList.add(new Location(34.4556, -117.887));
        locList.add(new Location(34.2544, -117.434));
        locList.add(new Location(34.1158, -117.137));
        locList.add(new Location(33.82, -116.301));
        locList.add(new Location(34.3697, -117.668));
        for (int i = 0; i < locList.size(); ++i) {
        }
    }
}

