/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.ServerDB_Access;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;

public class PrioritizedDB_Access
implements DB_AccessAPI {
    private static final boolean D = false;
    private DB_AccessAPI dbAccess = null;

    public static ArrayList<DB_AccessAPI> createDB2ReadOnlyAccessors() {
        ArrayList<DB_AccessAPI> accessors = new ArrayList<DB_AccessAPI>();
        try {
            accessors.add(new DB_ConnectionPool("/refFaultParamDb/DB_AccessProp_2.0.dat"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            accessors.add(new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB2));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return accessors;
    }

    public static ArrayList<DB_AccessAPI> createDB3ReadOnlyAccessors() {
        ArrayList<DB_AccessAPI> accessors = new ArrayList<DB_AccessAPI>();
        try {
            accessors.add(new DB_ConnectionPool("/refFaultParamDb/DB_AccessProp_3.0_ro.dat"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            accessors.add(new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB3));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return accessors;
    }

    public PrioritizedDB_Access(ArrayList<DB_AccessAPI> accessors) {
        for (int i = 0; i < accessors.size(); ++i) {
            DB_AccessAPI accessor = accessors.get(i);
            boolean success = PrioritizedDB_Access.isAccessorValid(accessor);
            if (success) {
                this.dbAccess = accessor;
                break;
            }
            System.err.println("DB Accessor " + (i + 1) + "/" + accessors.size() + " failed (see above stack trace).");
        }
        if (this.dbAccess == null) {
            throw new RuntimeException("No valid DB Accessors! (0/" + accessors.size() + " successful)");
        }
    }

    public static boolean isAccessorValid(DB_AccessAPI dbAccess) {
        String sql = "SELECT * FROM Fault_Model where rownum<=1";
        try {
            CachedRowSet rs = dbAccess.queryData(sql);
            rs.first();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public int getNextSequenceNumber(String sequenceName) throws SQLException {
        return this.dbAccess.getNextSequenceNumber(sequenceName);
    }

    @Override
    public String getSystemDate() throws SQLException {
        return this.dbAccess.getSystemDate();
    }

    @Override
    public int insertUpdateOrDeleteData(String sql) throws SQLException {
        return this.dbAccess.insertUpdateOrDeleteData(sql);
    }

    @Override
    public int[] insertUpdateOrDeleteBatch(ArrayList<String> sqls, boolean rollbackOnFail) throws SQLException {
        return this.dbAccess.insertUpdateOrDeleteBatch(sqls, rollbackOnFail);
    }

    @Override
    public int insertUpdateOrDeleteData(String sql, ArrayList<JGeometry> geometryList) throws SQLException {
        return this.dbAccess.insertUpdateOrDeleteData(sql, geometryList);
    }

    @Override
    public CachedRowSet queryData(String sql) throws SQLException {
        return this.dbAccess.queryData(sql);
    }

    @Override
    public SpatialQueryResult queryData(String sqlWithSpatialColumnNames, String sqlWithNoSpatialColumnNames, ArrayList<String> spatialColumnNames) throws SQLException {
        return this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
    }

    @Override
    public int resetPasswordByEmail(String email) throws SQLException {
        return this.dbAccess.resetPasswordByEmail(email);
    }

    public static void main(String[] args) {
        new PrioritizedDB_Access(PrioritizedDB_Access.createDB2ReadOnlyAccessors());
        System.exit(0);
    }

    @Override
    public void destroy() throws SQLException {
        this.dbAccess.destroy();
    }

    @Override
    public void destroy(int millis) throws SQLException {
        this.dbAccess.destroy(millis);
    }
}

