/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.util.List;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;

public class SpatialUtils {
    private static final int SRID = 8307;

    public static JGeometry getMultiPointGeomtery(List<Location> locs) {
        int numLocations = locs.size();
        Object[] coords = new Object[numLocations];
        for (int j = 0; j < numLocations; ++j) {
            Location loc = locs.get(j);
            double[] d = new double[]{loc.getLongitude(), loc.getLatitude()};
            coords[j] = d;
        }
        return JGeometry.createMultiPoint((Object[])coords, (int)2, (int)8307);
    }

    public static LocationList loadMultiPointGeometries(JGeometry geom, double depth) {
        LocationList locs = new LocationList();
        int numPoints = geom.getNumPoints();
        double[] ordinatesArray = geom.getOrdinatesArray();
        for (int j = 0; j < numPoints; ++j) {
            locs.add(new Location(ordinatesArray[2 * j + 1], ordinatesArray[2 * j], depth));
        }
        return locs;
    }

    public static JGeometry getSinglePointGeometry(Location loc) {
        double[] point = new double[]{loc.getLongitude(), loc.getLatitude()};
        return JGeometry.createPoint((double[])point, (int)2, (int)8307);
    }

    public static Location loadSinglePointGeometry(JGeometry geom, double depth) {
        double[] pt = geom.getPoint();
        return new Location(pt[1], pt[0], depth);
    }
}

