/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class TimeEstimateDB_DAO {
    private static final String TABLE_NAME = "Time_Estimate_Info";
    private static final String TIME_INSTANCE_ID = "Time_Instance_Id";
    private static final String TIME_EST_ID = "Time_Est_Id";
    private static final String IS_KA = "Is_Ka";
    private static final String ERA = "Era";
    private static final String ZERO_YEAR = "Zero_Year";
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final String KA = "ka";
    private DB_AccessAPI dbAccessAPI;
    private EstimateInstancesDB_DAO estimateInstanceDAO;

    public TimeEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
        this.estimateInstanceDAO = new EstimateInstancesDB_DAO(dbAccessAPI);
    }

    public void addTimeEstimate(int timeInstanceId, TimeEstimate timeEstimate) throws InsertException {
        String isKaSelected;
        EstimateInstances estimateInstance = new EstimateInstances();
        estimateInstance.setEstimate(timeEstimate.getEstimate());
        if (timeEstimate.isKaSelected()) {
            estimateInstance.setUnits(KA);
            isKaSelected = YES;
        } else {
            estimateInstance.setUnits(timeEstimate.getEra());
            isKaSelected = NO;
        }
        int estimateInstanceId = this.estimateInstanceDAO.addEstimateInstance(estimateInstance);
        String sql = "insert into Time_Estimate_Info(Time_Instance_Id,Time_Est_Id,Is_Ka,Era,Zero_Year) values (" + timeInstanceId + "," + estimateInstanceId + ",'" + isKaSelected + "','" + timeEstimate.getEra() + "'," + timeEstimate.getZeroYear() + ")";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public TimeEstimate getTimeEstimate(int timeInstanceId) throws QueryException {
        TimeEstimate timeEstimate = null;
        String condition = " where Time_Instance_Id=" + timeInstanceId;
        ArrayList<TimeEstimate> timeEstimateList = this.query(condition);
        if (timeEstimateList.size() > 0) {
            timeEstimate = timeEstimateList.get(0);
        }
        return timeEstimate;
    }

    public boolean removeTimeEstimate(int timeInstanceId) throws UpdateException {
        String sql = "delete from Time_Estimate_Info  where Time_Instance_Id=" + timeInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    private ArrayList<TimeEstimate> query(String condition) throws QueryException {
        ArrayList<TimeEstimate> timeEstimateList = new ArrayList<TimeEstimate>();
        String sql = "select Time_Instance_Id,Time_Est_Id,Is_Ka,Era,Zero_Year from Time_Estimate_Info " + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                TimeEstimate timeEstimate = new TimeEstimate();
                EstimateInstances estimateInstance = this.estimateInstanceDAO.getEstimateInstance(rs.getInt(TIME_EST_ID));
                if (rs.getString(IS_KA).equalsIgnoreCase(YES)) {
                    timeEstimate.setForKaUnits(estimateInstance.getEstimate(), rs.getInt(ZERO_YEAR));
                } else {
                    timeEstimate.setForCalendarYear(estimateInstance.getEstimate(), rs.getString(ERA));
                }
                timeEstimateList.add(timeEstimate);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return timeEstimateList;
    }
}

