/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.refFaultParamDb.excelToDatabase.RowIdentifier;

public class CompareExcelSheets {
    private static final String EXCEL_SHEET1 = "org/opensha/refFaultParamDb/excelToDatabase/PaleoSites_2007_02_Bird.xls";
    private static final String EXCEL_SHEET2 = "org/opensha/refFaultParamDb/excelToDatabase/FileForDeformationModelersv4.xls";
    private static final String DIFF_OUT_FILE = "org/opensha/refFaultParamDb/excelToDatabase/Differences.txt";
    private HashMap<Integer, RowIdentifier> sheet1Rows = new HashMap();
    private HashMap<Integer, RowIdentifier> sheet2Rows = new HashMap();

    public CompareExcelSheets() {
        this.loadRowsIntoMemory(EXCEL_SHEET1, this.sheet1Rows);
        this.loadRowsIntoMemory(EXCEL_SHEET2, this.sheet2Rows);
        try {
            POIFSFileSystem fs1 = new POIFSFileSystem((InputStream)new FileInputStream(EXCEL_SHEET1));
            HSSFWorkbook wb1 = new HSSFWorkbook(fs1);
            HSSFSheet sheet1 = wb1.getSheetAt(0);
            int lastRowNum1 = sheet1.getLastRowNum();
            POIFSFileSystem fs2 = new POIFSFileSystem((InputStream)new FileInputStream(EXCEL_SHEET2));
            HSSFWorkbook wb2 = new HSSFWorkbook(fs2);
            HSSFSheet sheet2 = wb2.getSheetAt(0);
            int lastRowNum2 = sheet2.getLastRowNum();
            FileWriter diffWriter = new FileWriter(DIFF_OUT_FILE);
            boolean found = false;
            for (int row1 = 1; row1 <= lastRowNum1; ++row1) {
                RowIdentifier identifier1 = this.sheet1Rows.get(row1);
                found = false;
                for (int row2 = 1; row2 <= lastRowNum2 && !found; ++row2) {
                    RowIdentifier identifier2 = this.sheet2Rows.get(row2);
                    if (identifier2 == null || identifier1.getSiteId() != identifier2.getSiteId() || !identifier1.getEntryDate().equalsIgnoreCase(identifier2.getEntryDate())) continue;
                    HSSFRow r1 = sheet1.getRow(row1);
                    HSSFRow r2 = sheet2.getRow(row2);
                    this.compare(r1, r2, row1, row2, diffWriter);
                    this.sheet2Rows.remove(row2);
                    found = true;
                }
                if (found) continue;
                diffWriter.write("Row " + (row1 + 1) + " exists in Sheet1 but not in Sheet2\n");
            }
            for (int rowId : this.sheet2Rows.keySet()) {
                diffWriter.write("Row " + (rowId + 1) + " exists in Sheet2 but not in Sheet1\n");
            }
            diffWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void compare(HSSFRow r1, HSSFRow r2, int rowIndex1, int rowIndex2, FileWriter diffWriter) {
        try {
            int LAST_COL = 50;
            for (int col = 0; col < LAST_COL; ++col) {
                HSSFCell cell2;
                String value2;
                HSSFCell cell1 = r1.getCell((int)((short)col));
                String value1 = this.getValue(cell1);
                if (value1.equalsIgnoreCase(value2 = this.getValue(cell2 = r2.getCell((int)((short)col))))) continue;
                diffWriter.write(">>>>> Row " + (rowIndex1 + 1) + " Column " + (col + 1) + " in Sheet1 has value " + value1 + " but Row " + (rowIndex2 + 1) + " Column " + (col + 1) + " in Sheet2 has value " + value2 + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getValue(HSSFCell cell) {
        if (cell == null || cell.getCellType() == 3) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue().trim();
        }
        return "" + cell.getNumericCellValue();
    }

    private void loadRowsIntoMemory(String sheetName, HashMap<Integer, RowIdentifier> rowMapping) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(sheetName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            for (int r = 1; r <= lastRowNum; ++r) {
                HSSFRow row = sheet.getRow(r);
                String entryDate = row.getCell(0).getStringCellValue();
                int siteId = (int)row.getCell(6).getNumericCellValue();
                RowIdentifier identifier = new RowIdentifier(r, siteId, entryDate);
                rowMapping.put(r, identifier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new CompareExcelSheets();
    }
}

