/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.refFaultParamDb.dao.db.CombinedEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.Reference;

public class FileForDeformationModelers {
    private static final String OUT_FILE_NAME = "org/opensha/refFaultParamDb/excelToDatabase/FileForDeformationModelersv4.xls";
    private PaleoSiteDB_DAO paleoSiteDAO = new PaleoSiteDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private CombinedEventsInfoDB_DAO combinedEventsInfoDAO = new CombinedEventsInfoDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final String BETWEEN_LOCATIONS_SITE_TYPE = "Between Locations";
    private static final String KA = "KA";
    private static final String ALT = " alt ";
    private static final DecimalFormat LAT_FORMAT = new DecimalFormat("0.0000");
    private static final DecimalFormat LON_FORMAT = new DecimalFormat("0.000");
    private static final DecimalFormat KA_FORMAT = new DecimalFormat("0.####");
    private static final DecimalFormat SLIP_DISP_FORMAT = new DecimalFormat("0.##");

    public static void main(String[] args) {
        FileForDeformationModelers dmFile = new FileForDeformationModelers();
        dmFile.generateFile();
    }

    public void generateFile() {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            this.writeHeader(sheet);
            ArrayList<PaleoSite> paleoSitesList = this.paleoSiteDAO.getAllPaleoSites();
            int row = 1;
            for (int i = 0; i < paleoSitesList.size(); ++i) {
                PaleoSite paleoSite = paleoSitesList.get(i);
                System.out.println(i + ". " + paleoSite.getSiteName());
                ArrayList<PaleoSitePublication> paleoSitePublicationList = paleoSite.getPaleoSitePubList();
                for (int j = 0; j < paleoSitePublicationList.size(); ++j) {
                    PaleoSitePublication paleoSitePub = paleoSitePublicationList.get(j);
                    Reference reference = paleoSitePub.getReference();
                    ArrayList<CombinedEventsInfo> combinedInfoList = this.combinedEventsInfoDAO.getCombinedEventsInfoList(paleoSite.getSiteId(), reference.getReferenceId());
                    int k = 0;
                    while (k < combinedInfoList.size()) {
                        CombinedEventsInfo combinedEventsInfo = combinedInfoList.get(k);
                        this.writeRow(sheet, row, paleoSite, combinedEventsInfo, paleoSitePub);
                        ++k;
                        ++row;
                    }
                }
            }
            FileOutputStream fileOut = new FileOutputStream(OUT_FILE_NAME);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeRow(HSSFSheet sheet, int rowId, PaleoSite paleoSite, CombinedEventsInfo combinedEventsInfo, PaleoSitePublication paleoSitePub) {
        HSSFRow row = sheet.createRow((int)((short)rowId));
        row.createCell(0).setCellValue(combinedEventsInfo.getEntryDate());
        row.createCell(1).setCellValue(this.getEntryType(combinedEventsInfo.getIsExpertOpinion()));
        row.createCell(2).setCellValue((double)combinedEventsInfo.getFaultSectionId());
        String faultSectionName = this.prefFaultSectionDAO.getFaultSectionPrefData(combinedEventsInfo.getFaultSectionId()).getSectionName();
        String alternates = "N";
        if (faultSectionName.indexOf(ALT) > 0) {
            alternates = "Y";
        }
        row.createCell(3).setCellValue(alternates);
        row.createCell(4).setCellValue(faultSectionName);
        row.createCell(5).setCellValue(combinedEventsInfo.getNeokinemaFaultNumber());
        row.createCell(6).setCellValue((double)paleoSite.getSiteId());
        row.createCell(7).setCellValue(paleoSite.getSiteName());
        row.createCell(8).setCellValue(this.getSiteType(paleoSitePub.getSiteTypeNames()));
        String dataSource = "";
        if (combinedEventsInfo.getDataSource() != null) {
            dataSource = combinedEventsInfo.getDataSource();
        }
        row.createCell(9).setCellValue(dataSource);
        row.createCell(10).setCellValue(LON_FORMAT.format(paleoSite.getSiteLon1()));
        row.createCell(11).setCellValue(LAT_FORMAT.format(paleoSite.getSiteLat1()));
        Object siteElev = "";
        if (!Float.isNaN(paleoSite.getSiteElevation1())) {
            siteElev = "" + paleoSite.getSiteElevation1();
        }
        row.createCell(12).setCellValue((String)siteElev);
        String lon2 = "";
        String lat2 = "";
        Object elev2 = "";
        if (paleoSitePub.getSiteTypeNames().contains(BETWEEN_LOCATIONS_SITE_TYPE)) {
            lon2 = LON_FORMAT.format(paleoSite.getSiteLon2());
            lat2 = LAT_FORMAT.format(paleoSite.getSiteLat2());
            if (!Float.isNaN(paleoSite.getSiteElevation2())) {
                elev2 = "" + paleoSite.getSiteElevation2();
            }
        }
        row.createCell(13).setCellValue(lon2);
        row.createCell(14).setCellValue(lat2);
        row.createCell(15).setCellValue((String)elev2);
        row.createCell(16).setCellValue(this.getStrandIndex(paleoSitePub.getRepresentativeStrandName()));
        row.createCell(17).setCellValue(paleoSitePub.getReference().getSummary());
        Object qFaultRefId = "";
        if (paleoSitePub.getReference().getQfaultReferenceId() > 0) {
            qFaultRefId = "" + paleoSitePub.getReference().getQfaultReferenceId();
        }
        row.createCell(18).setCellValue((String)qFaultRefId);
        row.createCell(19).setCellValue((double)paleoSitePub.getReference().getReferenceId());
        CombinedSlipRateInfo combinedSlipRateInfo = combinedEventsInfo.getCombinedSlipRateInfo();
        CombinedDisplacementInfo combinedDisplacementInfo = combinedEventsInfo.getCombinedDisplacementInfo();
        CombinedNumEventsInfo combinedNumEventsInfo = combinedEventsInfo.getCombinedNumEventsInfo();
        row.createCell(20).setCellValue(this.getMeasuredCompOfSlip(combinedSlipRateInfo, combinedDisplacementInfo));
        row.createCell(21).setCellValue(this.getSenseOfMotion(combinedSlipRateInfo, combinedDisplacementInfo));
        row.createCell(22).setCellValue(this.getRake(combinedSlipRateInfo, combinedDisplacementInfo));
        TimeAPI startTime = combinedEventsInfo.getStartTime();
        String startTimeUnits = this.getTimeUnits(startTime);
        row.createCell(23).setCellValue(startTimeUnits);
        row.createCell(24).setCellValue(this.getPrefTime(startTime, startTimeUnits));
        row.createCell(25).setCellValue(this.getMaxTime(startTime, startTimeUnits));
        row.createCell(26).setCellValue(this.getMinTime(startTime, startTimeUnits));
        TimeAPI endTime = combinedEventsInfo.getEndTime();
        String endTimeUnits = this.getTimeUnits(endTime);
        row.createCell(27).setCellValue(endTimeUnits);
        row.createCell(28).setCellValue(this.getPrefTime(endTime, endTimeUnits));
        row.createCell(29).setCellValue(this.getMaxTime(endTime, endTimeUnits));
        row.createCell(30).setCellValue(this.getMinTime(endTime, endTimeUnits));
        String minAseismic = "";
        String prefAseismic = "";
        String maxAseismic = "";
        String minSlipRate = "";
        String maxSlipRate = "";
        String prefSlipRate = "";
        String slipRateComments = "";
        if (combinedSlipRateInfo != null) {
            minAseismic = this.getMin(combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip());
            prefAseismic = this.getPref(combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip());
            maxAseismic = this.getMax(combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip());
            minSlipRate = this.getMin(combinedSlipRateInfo.getSlipRateEstimate());
            prefSlipRate = this.getPref(combinedSlipRateInfo.getSlipRateEstimate());
            maxSlipRate = this.getMax(combinedSlipRateInfo.getSlipRateEstimate());
            if (combinedSlipRateInfo.getSlipRateComments() != null) {
                slipRateComments = combinedSlipRateInfo.getSlipRateComments();
            }
        }
        row.createCell(31).setCellValue(prefAseismic);
        row.createCell(32).setCellValue(maxAseismic);
        row.createCell(33).setCellValue(minAseismic);
        row.createCell(34).setCellValue(prefSlipRate);
        row.createCell(35).setCellValue(maxSlipRate);
        row.createCell(36).setCellValue(minSlipRate);
        String minAseismicDisp = "";
        String prefAseismicDisp = "";
        String maxAseismicDisp = "";
        String minDisp = "";
        String maxDisp = "";
        String prefDisp = "";
        String displacementComments = "";
        if (combinedDisplacementInfo != null) {
            minAseismicDisp = this.getMin(combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp());
            prefAseismicDisp = this.getPref(combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp());
            maxAseismicDisp = this.getMax(combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp());
            minDisp = this.getMin(combinedDisplacementInfo.getDisplacementEstimate());
            prefDisp = this.getPref(combinedDisplacementInfo.getDisplacementEstimate());
            maxDisp = this.getMax(combinedDisplacementInfo.getDisplacementEstimate());
            if (combinedDisplacementInfo.getDisplacementComments() != null) {
                displacementComments = combinedDisplacementInfo.getDisplacementComments();
            }
        }
        row.createCell(37).setCellValue(prefAseismicDisp);
        row.createCell(38).setCellValue(maxAseismicDisp);
        row.createCell(39).setCellValue(minAseismicDisp);
        row.createCell(40).setCellValue(prefDisp);
        row.createCell(41).setCellValue(maxDisp);
        row.createCell(42).setCellValue(minDisp);
        String minNumEvents = "";
        String maxNumEvents = "";
        String prefNumEvents = "";
        String numEventComments = "";
        if (combinedNumEventsInfo != null) {
            minNumEvents = this.getMin(combinedNumEventsInfo.getNumEventsEstimate());
            maxNumEvents = this.getMax(combinedNumEventsInfo.getNumEventsEstimate());
            prefNumEvents = this.getPref(combinedNumEventsInfo.getNumEventsEstimate());
            if (combinedNumEventsInfo.getNumEventsComments() != null) {
                numEventComments = combinedNumEventsInfo.getNumEventsComments();
            }
        }
        row.createCell(43).setCellValue(prefNumEvents);
        row.createCell(44).setCellValue(maxNumEvents);
        row.createCell(45).setCellValue(minNumEvents);
        row.createCell(46).setCellValue(numEventComments);
        String datingComments = "";
        if (startTime != null && startTime.getDatingComments() != null) {
            datingComments = startTime.getDatingComments();
        }
        row.createCell(47).setCellValue(datingComments);
        row.createCell(48).setCellValue(slipRateComments);
        row.createCell(49).setCellValue(displacementComments);
        String generalComments = "";
        if (paleoSite.getGeneralComments() != null) {
            generalComments = paleoSite.getGeneralComments();
        }
        row.createCell(50).setCellValue(generalComments);
    }

    private String getPrefTime(TimeAPI time, String timeUnits) {
        if (time == null) {
            return "";
        }
        if (time instanceof TimeEstimate) {
            TimeEstimate timeEstimate = (TimeEstimate)time;
            MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)timeEstimate.getEstimate();
            double val = estimate.getPreferred();
            if (Double.isNaN(val)) {
                return "";
            }
            if (timeUnits.equalsIgnoreCase(KA)) {
                return KA_FORMAT.format(val);
            }
            return "" + (int)val;
        }
        ExactTime exacTime = (ExactTime)time;
        return "" + exacTime.getYear();
    }

    private String getMaxTime(TimeAPI time, String timeUnits) {
        if (time == null) {
            return "";
        }
        if (time instanceof TimeEstimate) {
            TimeEstimate timeEstimate = (TimeEstimate)time;
            MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)timeEstimate.getEstimate();
            double val = estimate.getMaximum();
            if (Double.isNaN(val)) {
                return "";
            }
            if (timeUnits.equalsIgnoreCase(KA)) {
                return KA_FORMAT.format(val);
            }
            return "" + (int)val;
        }
        return "";
    }

    private String getMinTime(TimeAPI time, String timeUnits) {
        if (time == null) {
            return "";
        }
        if (time instanceof TimeEstimate) {
            TimeEstimate timeEstimate = (TimeEstimate)time;
            MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)timeEstimate.getEstimate();
            double val = estimate.getMinimum();
            if (Double.isNaN(val)) {
                return "";
            }
            if (timeUnits.equalsIgnoreCase(KA)) {
                return KA_FORMAT.format(val);
            }
            return "" + (int)val;
        }
        return "";
    }

    private String getTimeUnits(TimeAPI time) {
        if (time == null) {
            return "";
        }
        if (time instanceof TimeEstimate) {
            TimeEstimate timeEstimate = (TimeEstimate)time;
            if (timeEstimate.isKaSelected()) {
                return KA;
            }
            return timeEstimate.getEra();
        }
        return ((ExactTime)time).getEra();
    }

    private String getMeasuredCompOfSlip(CombinedSlipRateInfo combinedSlipRateInfo, CombinedDisplacementInfo combinedDisplacementInfo) {
        String measuredCompSlip = "";
        if (combinedSlipRateInfo != null) {
            measuredCompSlip = this.getMeasuredCompOfSlipCode(combinedSlipRateInfo.getMeasuredComponentQual());
        }
        if (combinedDisplacementInfo != null && (measuredCompSlip == null || measuredCompSlip.equalsIgnoreCase(""))) {
            measuredCompSlip = this.getMeasuredCompOfSlipCode(combinedDisplacementInfo.getMeasuredComponentQual());
        }
        return measuredCompSlip;
    }

    private String getMeasuredCompOfSlipCode(String measuredComp) {
        if (measuredComp == null) {
            return "";
        }
        if (measuredComp.equalsIgnoreCase("Total")) {
            return "A";
        }
        if (measuredComp.equalsIgnoreCase("Vertical")) {
            return "B";
        }
        if (measuredComp.equalsIgnoreCase("Horizontal,Trace-Parallel")) {
            return "C";
        }
        if (measuredComp.equalsIgnoreCase("Horizontal,Trace-NORMAL")) {
            return "D";
        }
        return null;
    }

    private String getSenseOfMotion(CombinedSlipRateInfo combinedSlipRateInfo, CombinedDisplacementInfo combinedDisplacementInfo) {
        String senseOfMotion = "";
        if (combinedSlipRateInfo != null) {
            senseOfMotion = this.getSenseOfMotionCode(combinedSlipRateInfo.getSenseOfMotionQual());
        }
        if (combinedDisplacementInfo != null && senseOfMotion.equalsIgnoreCase("")) {
            senseOfMotion = this.getSenseOfMotionCode(combinedDisplacementInfo.getSenseOfMotionQual());
        }
        return senseOfMotion;
    }

    private String getSenseOfMotionCode(String senseOfMotion) {
        if (senseOfMotion == null) {
            return "";
        }
        return senseOfMotion;
    }

    private String getRake(CombinedSlipRateInfo combinedSlipRateInfo, CombinedDisplacementInfo combinedDisplacementInfo) {
        String rake = "";
        if (combinedSlipRateInfo != null) {
            rake = this.getSingleVal(combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip());
        }
        if (combinedDisplacementInfo != null && rake.equalsIgnoreCase("")) {
            rake = this.getSingleVal(combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp());
        }
        return rake;
    }

    private String getSingleVal(EstimateInstances estimateInstance) {
        String val = this.getPref(estimateInstance);
        if (val.equalsIgnoreCase("")) {
            val = this.getMax(estimateInstance);
        }
        if (val.equalsIgnoreCase("")) {
            val = this.getMin(estimateInstance);
        }
        return val;
    }

    private String getMin(EstimateInstances estimateInstance) {
        if (estimateInstance == null) {
            return "";
        }
        MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)estimateInstance.getEstimate();
        if (Double.isNaN(estimate.getMinimum())) {
            return "";
        }
        return SLIP_DISP_FORMAT.format(estimate.getMinimum());
    }

    private String getMax(EstimateInstances estimateInstance) {
        if (estimateInstance == null) {
            return "";
        }
        MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)estimateInstance.getEstimate();
        if (Double.isNaN(estimate.getMaximum())) {
            return "";
        }
        return SLIP_DISP_FORMAT.format(estimate.getMaximum());
    }

    private String getPref(EstimateInstances estimateInstance) {
        if (estimateInstance == null) {
            return "";
        }
        MinMaxPrefEstimate estimate = (MinMaxPrefEstimate)estimateInstance.getEstimate();
        if (Double.isNaN(estimate.getPreferred())) {
            return "";
        }
        return SLIP_DISP_FORMAT.format(estimate.getPreferred());
    }

    private String getStrandIndex(String repStrandIndex) {
        if (repStrandIndex.equalsIgnoreCase("Entire Fault")) {
            return "1";
        }
        if (repStrandIndex.equalsIgnoreCase("Most Significant Strand")) {
            return "2";
        }
        if (repStrandIndex.equalsIgnoreCase("One of Several Strands")) {
            return "3";
        }
        return "4";
    }

    private String getSiteType(ArrayList siteTypeNames) {
        if (siteTypeNames.contains(BETWEEN_LOCATIONS_SITE_TYPE)) {
            return "2";
        }
        return "1";
    }

    private String getEntryType(boolean isExpertOpinion) {
        if (isExpertOpinion) {
            return "E";
        }
        return "R";
    }

    private void writeHeader(HSSFSheet sheet) {
        HSSFRow row = sheet.createRow(0);
        int col = 0;
        row.createCell((int)((short)col++)).setCellValue("ENTRY DATE");
        row.createCell((int)((short)col++)).setCellValue("ENTRY TYPE");
        row.createCell((int)((short)col++)).setCellValue("WG_FAULT_ID");
        row.createCell((int)((short)col++)).setCellValue("ALTERNATES?");
        row.createCell((int)((short)col++)).setCellValue("FAULT_NAME");
        row.createCell((int)((short)col++)).setCellValue("BIRD FAULT  ID-REFCAT");
        row.createCell((int)((short)col++)).setCellValue("WG SITE ID");
        row.createCell((int)((short)col++)).setCellValue("SITE NAME");
        row.createCell((int)((short)col++)).setCellValue("SITE TYPE");
        row.createCell((int)((short)col++)).setCellValue("DATA SOURCE");
        row.createCell((int)((short)col++)).setCellValue("SITE_LONG 1");
        row.createCell((int)((short)col++)).setCellValue("SITE_LAT 1");
        row.createCell((int)((short)col++)).setCellValue("SITE_ELEV 1");
        row.createCell((int)((short)col++)).setCellValue("SITE LONG 2");
        row.createCell((int)((short)col++)).setCellValue("SITE LAT 2");
        row.createCell((int)((short)col++)).setCellValue("SITE ELEV 2");
        row.createCell((int)((short)col++)).setCellValue("HOW REPRESENTATIVE IS SITE?");
        row.createCell((int)((short)col++)).setCellValue("SHORT CITATION");
        row.createCell((int)((short)col++)).setCellValue("QFAULTS REF ID");
        row.createCell((int)((short)col++)).setCellValue("WG REF ID");
        row.createCell((int)((short)col++)).setCellValue("MEASURED COMPONENT OF SLIP");
        row.createCell((int)((short)col++)).setCellValue("SENSE OF MOTION");
        row.createCell((int)((short)col++)).setCellValue("RAKE");
        row.createCell((int)((short)col++)).setCellValue("START TIME UNITS");
        row.createCell((int)((short)col++)).setCellValue("PREF START TIME");
        row.createCell((int)((short)col++)).setCellValue("MAX START TIME(earliest)");
        row.createCell((int)((short)col++)).setCellValue("MIN START TIME");
        row.createCell((int)((short)col++)).setCellValue("END TIME UNITS");
        row.createCell((int)((short)col++)).setCellValue("PREF END TIME");
        row.createCell((int)((short)col++)).setCellValue("MAX END TIME (earliest)");
        row.createCell((int)((short)col++)).setCellValue("MIN END TIME");
        row.createCell((int)((short)col++)).setCellValue("SR: Aseismic Slip Est PREF");
        row.createCell((int)((short)col++)).setCellValue("SR: Aseismic Slip Est MAX");
        row.createCell((int)((short)col++)).setCellValue("SR: Aseismic Slip Est MIN");
        row.createCell((int)((short)col++)).setCellValue("PREF SLIP RATE (mm/yr)");
        row.createCell((int)((short)col++)).setCellValue("MAX SLIP RATE");
        row.createCell((int)((short)col++)).setCellValue("MIN SLIP RATE");
        row.createCell((int)((short)col++)).setCellValue("Offset: Aseismic Slip Est PREF");
        row.createCell((int)((short)col++)).setCellValue("Offset: Aseismic Slip Est MAX");
        row.createCell((int)((short)col++)).setCellValue("Offset: Aseismic Slip Est MIN");
        row.createCell((int)((short)col++)).setCellValue("PREF OFFSET (m)");
        row.createCell((int)((short)col++)).setCellValue("MAX OFFSET");
        row.createCell((int)((short)col++)).setCellValue("MIN OFFSET");
        row.createCell((int)((short)col++)).setCellValue("PREF NUM EVENTS");
        row.createCell((int)((short)col++)).setCellValue("MAX NUM EVENTS");
        row.createCell((int)((short)col++)).setCellValue("MIN NUM EVENTS");
        row.createCell((int)((short)col++)).setCellValue("NUM EVENTS COMMENTS");
        row.createCell((int)((short)col++)).setCellValue("TIME AND DATING COMMENTS");
        row.createCell((int)((short)col++)).setCellValue("SLIP RATE COMMENTS");
        row.createCell((int)((short)col++)).setCellValue("OFFSET COMMENTS");
        row.createCell((int)((short)col++)).setCellValue("GENERAL COMMENTS");
    }
}

