/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.CombinedEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.excelToDatabase.InvalidRowException;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.Reference;

public class PutCombinedInfoIntoDatabase_FAD {
    private static final String FILE_NAME = "org/opensha/refFaultParamDb/excelToDatabase/FromFAD.v2.xls";
    private static final int MIN_ROW_TIMESPAN = 2;
    private static final int MAX_ROW_TIMESPAN = 298;
    private static final int MIN_COL_TIMESPAN = 0;
    private static final int MAX_COL_TIMESPAN = 17;
    private static final int MIN_ROW_REF = 1;
    private static final int MAX_ROW_REF = 189;
    private static final int MIN_COL_REF = 1;
    private static final int MAX_COL_REF = 3;
    private static final int MIN_ROW_SITE_LOC = 2;
    private static final int MAX_ROW_SITE_LOC = 220;
    private static final int MIN_COL_SITE_LOC = 0;
    private static final int MAX_COL_SITE_LOC = 6;
    private PaleoSiteDB_DAO paleoSiteDAO = new PaleoSiteDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private ReferenceDB_DAO referenceDAO = new ReferenceDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private CombinedEventsInfoDB_DAO combinedEventsInfoDAO = new CombinedEventsInfoDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final String UNKNOWN = "Unknown";
    private static final String KA = "ka";
    private static final int ZERO_YEAR = 1950;
    private String measuredComponent;
    private CombinedSlipRateInfo combinedSlipRateInfo;
    private CombinedDisplacementInfo combinedDispInfo;
    private boolean isSlipRate;
    private boolean isDisp;
    private double min;
    private double max;
    private double pref;
    private TimeAPI startTime;
    private TimeAPI endTime;
    private String startTimeUnits;
    private String endTimeUnits;
    private static final String NO = "no";
    private HashMap fadReferences = new HashMap();
    private HashMap fadSites = new HashMap();
    private int fadSiteId;
    private int fadReferenceId;
    private HashMap insertedFAD_SiteIntoDB = new HashMap();
    private static final String BETWEEN_LOCATIONS_SITE_TYPE = "Between Locations";
    private static final String DATA_SOURCE = " SCEC-FAD";

    public PutCombinedInfoIntoDatabase_FAD() {
        try {
            this.loadFAD_References();
            this.loadPaleoSites();
            this.putCombinedEventsInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putCombinedEventsInfo() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            ArrayList<String> siteTypeNames = new ArrayList<String>();
            siteTypeNames.add(UNKNOWN);
            for (int r = 2; r <= 298; ++r) {
                HSSFRow row = sheet.getRow(r);
                System.out.println("Combined Event Info, row=" + (r + 1));
                CombinedEventsInfo combinedEventsInfo = new CombinedEventsInfo();
                this.combinedSlipRateInfo = new CombinedSlipRateInfo();
                this.combinedDispInfo = new CombinedDisplacementInfo();
                this.isSlipRate = false;
                this.isDisp = false;
                this.startTime = new TimeEstimate();
                this.endTime = new TimeEstimate();
                PaleoSitePublication paleoSitePub = new PaleoSitePublication();
                paleoSitePub.setRepresentativeStrandName(UNKNOWN);
                paleoSitePub.setSiteTypeNames(siteTypeNames);
                combinedEventsInfo.setPaleoSitePublication(paleoSitePub);
                try {
                    for (int c = 0; c <= 17; ++c) {
                        HSSFCell cell = row.getCell((int)((short)c));
                        Object value = null;
                        if (cell != null && cell.getCellType() != 3) {
                            value = cell.getCellType() == 1 ? cell.getStringCellValue().trim() : "" + cell.getNumericCellValue();
                        }
                        this.process(c, (String)value, combinedEventsInfo, paleoSitePub);
                    }
                }
                catch (InvalidRowException e) {
                    System.out.println("Row " + (r + 1) + ":" + e.getMessage());
                    continue;
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    continue;
                }
                combinedEventsInfo.setStartTime(this.startTime);
                combinedEventsInfo.setEndTime(this.endTime);
                ArrayList<Reference> refList = new ArrayList<Reference>();
                refList.add(paleoSitePub.getReference());
                combinedEventsInfo.setReferenceList(refList);
                if (this.isSlipRate) {
                    this.combinedSlipRateInfo.setSenseOfMotionQual(null);
                    this.combinedSlipRateInfo.setMeasuredComponentQual(this.measuredComponent);
                    combinedEventsInfo.setCombinedSlipRateInfo(this.combinedSlipRateInfo);
                }
                if (this.isDisp) {
                    this.combinedDispInfo.setSenseOfMotionQual(null);
                    this.combinedDispInfo.setMeasuredComponentQual(this.measuredComponent);
                    combinedEventsInfo.setCombinedDisplacementInfo(this.combinedDispInfo);
                }
                PaleoSite siteInDB = this.getPaleoSite(paleoSitePub);
                paleoSitePub.setSiteEntryDate(siteInDB.getEntryDate());
                paleoSitePub.setSiteId(siteInDB.getSiteId());
                combinedEventsInfo.setIsExpertOpinion(false);
                combinedEventsInfo.setSiteId(siteInDB.getSiteId());
                combinedEventsInfo.setSiteEntryDate(siteInDB.getEntryDate());
                combinedEventsInfo.setDataSource(DATA_SOURCE);
                this.combinedEventsInfoDAO.addCombinedEventsInfo(combinedEventsInfo);
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PaleoSite getPaleoSite(PaleoSitePublication paleoSitePub) throws Exception {
        PaleoSite paleoSite = (PaleoSite)this.insertedFAD_SiteIntoDB.get(this.fadSiteId);
        PaleoSite fadPaleoSite = (PaleoSite)this.fadSites.get(this.fadSiteId);
        if (fadPaleoSite.getSiteName().equalsIgnoreCase("per")) {
            fadPaleoSite.setSiteName("Per " + paleoSitePub.getReference().getSummary());
        }
        if (paleoSite == null) {
            if (fadPaleoSite.getOldSiteId() == null || this.paleoSiteDAO.getPaleoSiteByQfaultId(fadPaleoSite.getOldSiteId()) == null) {
                ArrayList<PaleoSitePublication> pubList = new ArrayList<PaleoSitePublication>();
                pubList.add(paleoSitePub);
                fadPaleoSite.setPaleoSitePubList(pubList);
                if (Float.isNaN(fadPaleoSite.getSiteLat1())) {
                    FaultSectionSummary faultSectionSummary = this.faultSectionDAO.getFaultSectionSummary(fadPaleoSite.getFaultSectionId());
                    fadPaleoSite.setFaultSectionNameId(faultSectionSummary.getSectionName(), faultSectionSummary.getSectionId());
                    FaultSectionData faultSection = this.faultSectionDAO.getFaultSection(fadPaleoSite.getFaultSectionId());
                    Location loc1 = (Location)faultSection.getFaultTrace().get(0);
                    Location loc2 = (Location)faultSection.getFaultTrace().get(faultSection.getFaultTrace().getNumLocations() - 1);
                    fadPaleoSite.setSiteLat1((float)loc1.getLatitude());
                    fadPaleoSite.setSiteLat2((float)loc2.getLatitude());
                    fadPaleoSite.setSiteLon1((float)loc1.getLongitude());
                    fadPaleoSite.setSiteLon2((float)loc2.getLongitude());
                    fadPaleoSite.setGeneralComments(fadPaleoSite.getGeneralComments() + "\nNo site location available.   Site is associated with a WG fault section.");
                    ArrayList<String> siteTypeNames = paleoSitePub.getSiteTypeNames();
                    siteTypeNames.clear();
                    siteTypeNames.add(BETWEEN_LOCATIONS_SITE_TYPE);
                    if (fadPaleoSite.getSiteName().equalsIgnoreCase("NaN,Nan")) {
                        fadPaleoSite.setSiteName(GUI_Utils.latFormat.format(fadPaleoSite.getSiteLat1()) + "," + GUI_Utils.lonFormat.format(fadPaleoSite.getSiteLon1()) + ";" + GUI_Utils.latFormat.format(fadPaleoSite.getSiteLat2()) + "," + GUI_Utils.lonFormat.format(fadPaleoSite.getSiteLon2()));
                    }
                }
                this.paleoSiteDAO.addPaleoSite(fadPaleoSite);
                Thread.sleep(1000L);
                this.insertedFAD_SiteIntoDB.put(this.fadSiteId, fadPaleoSite);
                paleoSite = fadPaleoSite;
            } else {
                paleoSite = this.paleoSiteDAO.getPaleoSiteByQfaultId(fadPaleoSite.getOldSiteId());
            }
        }
        return paleoSite;
    }

    private void loadFAD_References() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(2);
            int fadRefId = -1;
            for (int r = 1; r <= 189; ++r) {
                Reference reference = null;
                HSSFRow row = sheet.getRow(r);
                for (int c = 1; c <= 3; ++c) {
                    HSSFCell cell = row.getCell((int)((short)c));
                    Object value = null;
                    if (cell != null && cell.getCellType() != 3) {
                        value = cell.getCellType() == 1 ? cell.getStringCellValue().trim() : "" + cell.getNumericCellValue();
                    }
                    if (c == 1) {
                        fadRefId = Integer.parseInt(value);
                        continue;
                    }
                    if (c == 2) {
                        reference = this.getReference((String)value);
                        continue;
                    }
                    if (c != 3) continue;
                    reference.setFullBiblioReference((String)value);
                }
                this.fadReferences.put(fadRefId, reference);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPaleoSites() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(3);
            int fadSiteId = -1;
            for (int r = 2; r <= 220; ++r) {
                HSSFRow row = sheet.getRow(r);
                PaleoSite paleoSite = new PaleoSite();
                for (int c = 0; c <= 6; ++c) {
                    HSSFCell cell = row.getCell((int)((short)c));
                    Object value = null;
                    if (cell != null && cell.getCellType() != 3) {
                        value = cell.getCellType() == 1 ? cell.getStringCellValue().trim() : "" + cell.getNumericCellValue();
                    }
                    if (c == 0) {
                        fadSiteId = Integer.parseInt(value);
                        continue;
                    }
                    if (c == 1 && value != null && !((String)value).equalsIgnoreCase("NULL")) {
                        paleoSite.setOldSiteId((String)value);
                        continue;
                    }
                    if (c == 2 && value != null && !((String)value).equalsIgnoreCase("NULL")) {
                        paleoSite.setSiteLat1(Float.parseFloat((String)value));
                        paleoSite.setSiteLat2(Float.NaN);
                        continue;
                    }
                    if (c == 3 && value != null && !((String)value).equalsIgnoreCase("NULL")) {
                        paleoSite.setSiteLon1(Float.parseFloat((String)value));
                        paleoSite.setSiteLon2(Float.NaN);
                        continue;
                    }
                    if (c == 4 && value != null && !((String)value).equalsIgnoreCase("NULL")) {
                        paleoSite.setSiteElevation1(Float.parseFloat((String)value));
                        paleoSite.setSiteElevation2(Float.NaN);
                        continue;
                    }
                    if (c == 5 && value != null && !((String)value).equalsIgnoreCase("NULL")) {
                        paleoSite.setSiteName((String)value);
                        continue;
                    }
                    if (c != 6 || value == null || ((String)value).equalsIgnoreCase("NULL")) continue;
                    paleoSite.setGeneralComments((String)value);
                }
                if (paleoSite.getSiteName() == null || paleoSite.getSiteName().equalsIgnoreCase("")) {
                    paleoSite.setSiteName("per");
                }
                if (paleoSite.getGeneralComments() == null) {
                    paleoSite.setGeneralComments("");
                }
                this.fadSites.put(fadSiteId, paleoSite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process(int columnNumber, String value, CombinedEventsInfo combinedEventsInfo, PaleoSitePublication paleoSitePub) {
        switch (columnNumber) {
            case 0: {
                if (value == null || !value.equalsIgnoreCase(NO)) break;
                throw new InvalidRowException("No need to put into database as ingest=no");
            }
            case 1: {
                break;
            }
            case 2: {
                this.fadReferenceId = Integer.parseInt(value);
                Reference reference = (Reference)this.fadReferences.get(this.fadReferenceId);
                Reference refFromDB = this.referenceDAO.getReference(reference.getRefAuth(), reference.getRefYear());
                if (refFromDB == null) {
                    int refId = this.referenceDAO.addReference(reference);
                    refFromDB = reference;
                    refFromDB.setReferenceId(refId);
                }
                paleoSitePub.setReference(refFromDB);
                break;
            }
            case 3: {
                this.fadSiteId = Integer.parseInt(value);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                PaleoSite paleoSite = (PaleoSite)this.fadSites.get(this.fadSiteId);
                paleoSite.setFaultSectionNameId("temp", (int)Double.parseDouble(value.trim()));
                break;
            }
            case 6: {
                String compilerComment = "Compiler=" + value;
                this.combinedSlipRateInfo.setSlipRateComments(compilerComment);
                PaleoSite paleoSite1 = (PaleoSite)this.fadSites.get(this.fadSiteId);
                paleoSite1.setGeneralComments(paleoSite1.getGeneralComments() + "\n" + compilerComment);
                break;
            }
            case 7: {
                if (value == null) {
                    this.measuredComponent = UNKNOWN;
                    break;
                }
                if (value.equalsIgnoreCase("A")) {
                    this.measuredComponent = "Total";
                    break;
                }
                if (value.equalsIgnoreCase("B")) {
                    this.measuredComponent = "Vertical";
                    break;
                }
                if (value.equalsIgnoreCase("C")) {
                    this.measuredComponent = "Horizontal,Trace-Parallel";
                    break;
                }
                if (!value.equalsIgnoreCase("D")) break;
                this.measuredComponent = "Horizontal,Trace-NORMAL";
                break;
            }
            case 8: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.min = Double.parseDouble(value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.pref = Double.parseDouble(value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.max = Double.NaN;
                    break;
                }
                this.max = Double.parseDouble(value);
                break;
            }
            case 11: {
                this.startTimeUnits = value == null ? KA : value;
                if (Double.isNaN(this.max) && Double.isNaN(this.pref)) {
                    this.startTime = null;
                    this.endTime = null;
                    break;
                }
                MinMaxPrefEstimate est = new MinMaxPrefEstimate(Double.NaN, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                if (this.startTimeUnits.equalsIgnoreCase(KA)) {
                    ((TimeEstimate)this.startTime).setForKaUnits(est, 1950);
                } else {
                    ((TimeEstimate)this.startTime).setForCalendarYear(est, this.startTimeUnits);
                }
                ArrayList<Reference> refList = new ArrayList<Reference>();
                refList.add(paleoSitePub.getReference());
                this.startTime.setReferencesList(refList);
                this.endTimeUnits = this.startTimeUnits;
                if (Double.isNaN(this.min)) {
                    int refYear = paleoSitePub.getReference().getRefYear().equalsIgnoreCase("2002a") ? 2002 : Integer.parseInt(paleoSitePub.getReference().getRefYear());
                    this.endTime = new ExactTime(refYear, 0, 0, 0, 0, 0, "AD", true);
                } else {
                    MinMaxPrefEstimate endTimeEst = new MinMaxPrefEstimate(this.min, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
                    if (this.endTimeUnits.equalsIgnoreCase(KA)) {
                        ((TimeEstimate)this.endTime).setForKaUnits(endTimeEst, 1950);
                    } else {
                        ((TimeEstimate)this.endTime).setForCalendarYear(endTimeEst, this.endTimeUnits);
                    }
                }
                this.endTime.setReferencesList(refList);
                break;
            }
            case 12: {
                if (value == null) {
                    value = "";
                }
                combinedEventsInfo.setDatedFeatureComments(value);
                break;
            }
            case 13: {
                if (value == null) break;
                this.isDisp = true;
                double prefDisp = Double.parseDouble(value) * 1000.0;
                MinMaxPrefEstimate displacementEst = new MinMaxPrefEstimate(Double.NaN, Double.NaN, prefDisp, Double.NaN, Double.NaN, Double.NaN);
                this.combinedDispInfo.setDisplacementEstimate(new EstimateInstances(displacementEst, "m"));
                break;
            }
            case 14: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.isSlipRate = true;
                this.min = Double.parseDouble(value);
                break;
            }
            case 15: {
                if (value == null) {
                    this.max = Double.NaN;
                    break;
                }
                this.isSlipRate = true;
                this.max = Double.parseDouble(value);
                break;
            }
            case 16: {
                if (value == null) {
                    this.pref = Double.NaN;
                } else {
                    this.isSlipRate = true;
                    this.pref = Double.parseDouble(value);
                }
                if (!this.isSlipRate) break;
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                this.combinedSlipRateInfo.setSlipRateEstimate(new EstimateInstances(estimate, "mm/yr"));
                break;
            }
            case 17: {
                if (value == null) {
                    value = "";
                }
                this.combinedSlipRateInfo.setSlipRateComments(value);
                this.combinedDispInfo.setDisplacementComments(value);
            }
        }
    }

    private Reference getReference(String referenceSummary) {
        Reference ref = new Reference();
        ref.setFullBiblioReference("");
        int index = referenceSummary.indexOf("(");
        ref.setRefAuth(referenceSummary.substring(0, index));
        ref.setRefYear(referenceSummary.substring(index + 1, referenceSummary.indexOf(")")));
        return ref;
    }
}

