/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.refFaultParamDb.dao.db.CombinedEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.excelToDatabase.InvalidRowException;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.Reference;

public class PutCombinedInfoIntoDatabase_Qfault {
    private static final String FILE_NAME = "org/opensha/refFaultParamDb/excelToDatabase/QFaults.xls";
    private static final int MIN_ROW = 1;
    private static final int MAX_ROW = 90;
    private static final int MIN_COL = 0;
    private static final int MAX_COL = 48;
    private PaleoSiteDB_DAO paleoSiteDAO = new PaleoSiteDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private ReferenceDB_DAO referenceDAO = new ReferenceDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private CombinedEventsInfoDB_DAO combinedEventsInfoDAO = new CombinedEventsInfoDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final String UNKNOWN = "Unknown";
    private static final String MA = "MA";
    private static final String KA = "ka";
    private static final int ZERO_YEAR = 1950;
    private String measuredComponent;
    private String senseOfMotion;
    private CombinedDisplacementInfo combinedDispInfo;
    private CombinedSlipRateInfo combinedSlipRateInfo;
    private CombinedNumEventsInfo combinedNumEventsInfo;
    private boolean isDisp;
    private boolean isSlipRate;
    private boolean isNumEvents;
    private double min;
    private double max;
    private double pref;
    private String refSummary;
    private TimeAPI startTime;
    private TimeAPI endTime;
    private String startTimeUnits;
    private String endTimeUnits;
    private static final String NO = "no";
    private static final String BETWEEN_LOCATIONS_SITE_TYPE = "Between Locations";

    public PutCombinedInfoIntoDatabase_Qfault() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            for (int r = 1; r <= 90; ++r) {
                PaleoSite siteInDB;
                System.out.println("Processing Row:" + (r + 1));
                HSSFRow row = sheet.getRow(r);
                PaleoSite paleoSite = new PaleoSite();
                CombinedEventsInfo combinedEventsInfo = new CombinedEventsInfo();
                PaleoSitePublication paleoSitePub = new PaleoSitePublication();
                combinedEventsInfo.setPaleoSitePublication(paleoSitePub);
                ArrayList<PaleoSitePublication> pubList = new ArrayList<PaleoSitePublication>();
                pubList.add(paleoSitePub);
                paleoSite.setPaleoSitePubList(pubList);
                ArrayList<String> siteTypeNames = new ArrayList<String>();
                siteTypeNames.add(UNKNOWN);
                paleoSitePub.setSiteTypeNames(siteTypeNames);
                this.combinedDispInfo = new CombinedDisplacementInfo();
                this.combinedSlipRateInfo = new CombinedSlipRateInfo();
                this.combinedNumEventsInfo = new CombinedNumEventsInfo();
                this.isDisp = false;
                this.isSlipRate = false;
                this.isNumEvents = false;
                this.startTime = new TimeEstimate();
                this.endTime = new TimeEstimate();
                try {
                    for (int c = 0; c <= 48; ++c) {
                        HSSFCell cell = row.getCell((int)((short)c));
                        Object value = null;
                        if (cell != null && cell.getCellType() != 3) {
                            value = cell.getCellType() == 1 ? cell.getStringCellValue().trim() : "" + cell.getNumericCellValue();
                        }
                        this.process(c, (String)value, paleoSite, combinedEventsInfo, paleoSitePub);
                    }
                }
                catch (InvalidRowException e) {
                    System.out.println("Row " + (r + 1) + ":" + e.getMessage());
                    continue;
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    continue;
                }
                combinedEventsInfo.setStartTime(this.startTime);
                combinedEventsInfo.setEndTime(this.endTime);
                ArrayList<Reference> refList = new ArrayList<Reference>();
                refList.add(paleoSitePub.getReference());
                combinedEventsInfo.setReferenceList(refList);
                if (this.isDisp) {
                    this.combinedDispInfo.setSenseOfMotionQual(this.senseOfMotion);
                    this.combinedDispInfo.setMeasuredComponentQual(this.measuredComponent);
                    combinedEventsInfo.setCombinedDisplacementInfo(this.combinedDispInfo);
                }
                if (this.isSlipRate) {
                    this.combinedSlipRateInfo.setSenseOfMotionQual(this.senseOfMotion);
                    this.combinedSlipRateInfo.setMeasuredComponentQual(this.measuredComponent);
                    combinedEventsInfo.setCombinedSlipRateInfo(this.combinedSlipRateInfo);
                }
                if (this.isNumEvents) {
                    combinedEventsInfo.setCombinedNumEventsInfo(this.combinedNumEventsInfo);
                }
                if ((siteInDB = this.isSiteInDB(paleoSite.getSiteName())) == null) {
                    this.paleoSiteDAO.addPaleoSite(paleoSite);
                    siteInDB = paleoSite;
                    Thread.sleep(1000L);
                }
                paleoSitePub.setSiteEntryDate(siteInDB.getEntryDate());
                paleoSitePub.setSiteId(siteInDB.getSiteId());
                combinedEventsInfo.setIsExpertOpinion(false);
                combinedEventsInfo.setSiteId(siteInDB.getSiteId());
                combinedEventsInfo.setSiteEntryDate(siteInDB.getEntryDate());
                this.combinedEventsInfoDAO.addCombinedEventsInfo(combinedEventsInfo);
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PaleoSite isSiteInDB(String siteName) {
        return this.paleoSiteDAO.getPaleoSite(siteName);
    }

    private void process(int columnNumber, String value, PaleoSite paleoSite, CombinedEventsInfo combinedEventsInfo, PaleoSitePublication paleoSitePub) {
        switch (columnNumber) {
            case 0: {
                if (value == null || !value.equalsIgnoreCase(NO)) break;
                throw new InvalidRowException("No need to put into database as ingest=no");
            }
            case 1: {
                break;
            }
            case 2: {
                if (value != null && !value.equalsIgnoreCase("")) {
                    combinedEventsInfo.setNeokinemaFaultNumber(value);
                    combinedEventsInfo.setDataSource("Peter Bird");
                    break;
                }
                combinedEventsInfo.setDataSource("Qfaults");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                String comments = paleoSite.getGeneralComments();
                if (comments == null) {
                    comments = "";
                }
                paleoSite.setGeneralComments(comments);
            }
            case 7: {
                break;
            }
            case 8: {
                paleoSite.setOldSiteId(value);
                break;
            }
            case 9: {
                if (value == null || value.startsWith("per")) {
                    value = "";
                }
                paleoSite.setSiteName(value);
                break;
            }
            case 10: {
                if (value == null) {
                    throw new InvalidRowException("Site Longitude is missing");
                }
                paleoSite.setSiteLon1(Float.parseFloat(value));
                paleoSite.setSiteLon2(Float.NaN);
                break;
            }
            case 11: {
                if (value == null) {
                    throw new InvalidRowException("Site latitude is missing");
                }
                paleoSite.setSiteLat1(Float.parseFloat(value));
                paleoSite.setSiteLat2(Float.NaN);
                break;
            }
            case 12: {
                if (value == null) break;
                paleoSite.setSiteLon2(Float.parseFloat(value));
                break;
            }
            case 13: {
                if (value != null) {
                    paleoSite.setSiteLat2(Float.parseFloat(value));
                    ArrayList<String> siteTypeNames = paleoSitePub.getSiteTypeNames();
                    siteTypeNames.clear();
                    siteTypeNames.add(BETWEEN_LOCATIONS_SITE_TYPE);
                    if (!paleoSite.getSiteName().equalsIgnoreCase("")) break;
                    paleoSite.setSiteName(GUI_Utils.latFormat.format(paleoSite.getSiteLat1()) + "," + GUI_Utils.lonFormat.format(paleoSite.getSiteLon1()) + ";" + GUI_Utils.latFormat.format(paleoSite.getSiteLat2()) + "," + GUI_Utils.lonFormat.format(paleoSite.getSiteLon2()));
                    break;
                }
                if (!paleoSite.getSiteName().equalsIgnoreCase("")) break;
                paleoSite.setSiteName(GUI_Utils.latFormat.format(paleoSite.getSiteLat1()) + "," + GUI_Utils.lonFormat.format(paleoSite.getSiteLon1()));
                break;
            }
            case 14: {
                Object generalComments = paleoSite.getGeneralComments();
                if (generalComments == null) {
                    generalComments = "";
                }
                if (value != null) {
                    generalComments = (String)generalComments + value + "\n";
                }
                paleoSite.setGeneralComments((String)generalComments);
            }
            case 15: {
                this.refSummary = value;
                if (!paleoSite.getSiteName().equalsIgnoreCase("") && !paleoSite.getSiteName().equalsIgnoreCase("per")) break;
                paleoSite.setSiteName("per " + this.refSummary);
                break;
            }
            case 16: {
                if (value != null) {
                    paleoSitePub.setReference(this.referenceDAO.getReferenceByQfaultId((int)Double.parseDouble(value)));
                    break;
                }
                Reference ref = this.getReference(this.refSummary);
                Reference refFromDB = this.referenceDAO.getReference(ref.getRefAuth(), ref.getRefYear());
                if (refFromDB == null) {
                    paleoSitePub.setReference(this.addReferenceToDatabase(this.refSummary));
                    break;
                }
                paleoSitePub.setReference(refFromDB);
                break;
            }
            case 17: {
                if (value == null) {
                    value = "";
                }
                combinedEventsInfo.setDatedFeatureComments(value);
                break;
            }
            case 18: {
                if (value == null) {
                    value = UNKNOWN;
                }
                paleoSitePub.setRepresentativeStrandName(value);
                break;
            }
            case 19: {
                if (value == null) {
                    value = UNKNOWN;
                }
                if (value.equalsIgnoreCase("A")) {
                    this.measuredComponent = "Total";
                    break;
                }
                if (value.equalsIgnoreCase("B")) {
                    this.measuredComponent = "Vertical";
                    break;
                }
                if (value.equalsIgnoreCase("C")) {
                    this.measuredComponent = "Horizontal,Trace-Parallel";
                    break;
                }
                if (!value.equalsIgnoreCase("D")) break;
                this.measuredComponent = "Horizontal,Trace-NORMAL";
                break;
            }
            case 20: {
                this.senseOfMotion = value;
                break;
            }
            case 21: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.isDisp = true;
                this.pref = Double.parseDouble(value);
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.isDisp = true;
                this.min = Double.parseDouble(value);
                break;
            }
            case 24: {
                if (value == null) {
                    this.max = Double.NaN;
                } else {
                    this.isDisp = true;
                    this.max = Double.parseDouble(value);
                }
                if (!this.isDisp) break;
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                this.combinedDispInfo.setDisplacementEstimate(new EstimateInstances(estimate, "m"));
                break;
            }
            case 25: {
                if (value == null) {
                    value = "";
                }
                this.combinedDispInfo.setDisplacementComments(value);
                break;
            }
            case 26: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.isNumEvents = true;
                this.pref = Double.parseDouble(value);
                break;
            }
            case 27: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.isNumEvents = true;
                this.min = Double.parseDouble(value);
                break;
            }
            case 28: {
                if (value == null) {
                    this.max = Double.NaN;
                } else {
                    this.isNumEvents = true;
                    this.max = Double.parseDouble(value);
                }
                if (!this.isNumEvents) break;
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                this.combinedNumEventsInfo.setNumEventsEstimate(new EstimateInstances(estimate, " "));
                break;
            }
            case 29: {
                if (value == null) {
                    value = "";
                }
                this.combinedNumEventsInfo.setNumEventsComments(value);
                break;
            }
            case 30: {
                if (value == null) {
                    value = "";
                }
                combinedEventsInfo.setDatedFeatureComments(combinedEventsInfo.getDatedFeatureComments() + "\n" + value);
                break;
            }
            case 31: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.pref = Double.parseDouble(value);
                break;
            }
            case 32: {
                if (value != null) {
                    this.startTimeUnits = value;
                    break;
                }
                this.startTimeUnits = "";
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                if (value == null) {
                    this.max = Double.NaN;
                    break;
                }
                this.max = Double.parseDouble(value);
                break;
            }
            case 35: {
                this.min = value == null ? Double.NaN : Double.parseDouble(value);
                if (Double.isNaN(this.min) && Double.isNaN(this.max) && Double.isNaN(this.pref)) {
                    this.startTime = null;
                    break;
                }
                if (this.startTimeUnits.equalsIgnoreCase("")) {
                    throw new InvalidRowException("Start Time units are missing");
                }
                if (this.startTimeUnits.equalsIgnoreCase(MA)) {
                    this.min *= 1000.0;
                    this.max *= 1000.0;
                    this.pref *= 1000.0;
                    this.startTimeUnits = KA;
                }
                if (!this.startTimeUnits.equalsIgnoreCase(KA)) {
                    double temp = this.min;
                    this.min = this.max;
                    this.max = temp;
                }
                MinMaxPrefEstimate est = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                if (!this.startTimeUnits.equalsIgnoreCase("BC") && !this.startTimeUnits.equalsIgnoreCase(KA)) {
                    this.startTimeUnits = "AD";
                }
                if (this.startTimeUnits.equalsIgnoreCase(KA)) {
                    ((TimeEstimate)this.startTime).setForKaUnits(est, 1950);
                } else {
                    ((TimeEstimate)this.startTime).setForCalendarYear(est, this.startTimeUnits);
                }
                ArrayList<Reference> refList = new ArrayList<Reference>();
                refList.add(paleoSitePub.getReference());
                this.startTime.setReferencesList(refList);
                break;
            }
            case 36: {
                if (value == null) {
                    this.max = Double.NaN;
                    break;
                }
                this.max = Double.parseDouble(value);
                break;
            }
            case 37: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.pref = Double.parseDouble(value);
                break;
            }
            case 38: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.min = Double.parseDouble(value);
                break;
            }
            case 39: {
                this.endTimeUnits = this.startTimeUnits;
                if (this.startTime == null) {
                    this.endTime = null;
                    break;
                }
                if (Double.isNaN(this.min) && Double.isNaN(this.max) && Double.isNaN(this.pref)) {
                    this.endTime = new ExactTime(Integer.parseInt(paleoSitePub.getReference().getRefYear()), 0, 0, 0, 0, 0, "AD", true);
                } else {
                    if (this.endTimeUnits.equalsIgnoreCase("")) {
                        throw new InvalidRowException("End Time units are missing");
                    }
                    if (this.endTimeUnits.equalsIgnoreCase(MA)) {
                        this.min *= 1000.0;
                        this.max *= 1000.0;
                        this.pref *= 1000.0;
                        this.endTimeUnits = KA;
                    }
                    if (!this.endTimeUnits.equalsIgnoreCase(KA)) {
                        double temp = this.min;
                        this.min = this.max;
                        this.max = temp;
                    }
                    MinMaxPrefEstimate endTimeEst = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                    if (!this.endTimeUnits.equalsIgnoreCase("BC")) {
                        this.endTimeUnits = "AD";
                    }
                    if (this.endTimeUnits.equalsIgnoreCase(KA)) {
                        ((TimeEstimate)this.endTime).setForKaUnits(endTimeEst, 1950);
                    } else {
                        ((TimeEstimate)this.endTime).setForCalendarYear(endTimeEst, this.endTimeUnits);
                    }
                }
                ArrayList<Reference> refList1 = new ArrayList<Reference>();
                refList1.add(paleoSitePub.getReference());
                this.endTime.setReferencesList(refList1);
                break;
            }
            case 40: {
                if (value == null) {
                    value = "";
                }
                combinedEventsInfo.setDatedFeatureComments(combinedEventsInfo.getDatedFeatureComments() + "\n" + value);
                break;
            }
            case 41: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.min = Double.parseDouble(value);
                break;
            }
            case 42: {
                if (value == null) {
                    this.max = Double.NaN;
                    break;
                }
                this.max = Double.parseDouble(value);
                break;
            }
            case 43: {
                this.pref = value == null ? Double.NaN : Double.parseDouble(value);
                if (Double.isNaN(this.min) && Double.isNaN(this.max) && Double.isNaN(this.pref)) break;
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                this.combinedSlipRateInfo.setASeismicSlipFactorEstimateForSlip(new EstimateInstances(estimate, " "));
                break;
            }
            case 44: {
                if (value == null) {
                    this.pref = Double.NaN;
                    break;
                }
                this.isSlipRate = true;
                this.pref = Double.parseDouble(value);
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                if (value == null) {
                    this.min = Double.NaN;
                    break;
                }
                this.isSlipRate = true;
                this.min = Double.parseDouble(value);
                break;
            }
            case 47: {
                if (value == null) {
                    this.max = Double.NaN;
                } else {
                    this.isSlipRate = true;
                    this.max = Double.parseDouble(value);
                }
                if (!this.isSlipRate) break;
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(this.min, this.max, this.pref, Double.NaN, Double.NaN, Double.NaN);
                this.combinedSlipRateInfo.setSlipRateEstimate(new EstimateInstances(estimate, "mm/yr"));
                break;
            }
            case 48: {
                if (value == null) {
                    value = "";
                }
                this.combinedSlipRateInfo.setSlipRateComments(value);
            }
        }
    }

    private Reference addReferenceToDatabase(String referenceSummary) {
        Reference ref = this.getReference(referenceSummary);
        int id = this.referenceDAO.addReference(ref);
        ref.setReferenceId(id);
        return ref;
    }

    private Reference getReference(String referenceSummary) {
        Reference ref = new Reference();
        ref.setFullBiblioReference("");
        int index = referenceSummary.indexOf("(");
        ref.setRefAuth(referenceSummary.substring(0, index));
        ref.setRefYear(referenceSummary.substring(index + 1, referenceSummary.indexOf(")")));
        return ref;
    }
}

