/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileWriter;
import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSection2002DB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSection2002;
import org.opensha.sha.faultSurface.FaultTrace;

public class Read2002FaultSections {
    private FaultSection2002DB_DAO faultSection2002DAO = new FaultSection2002DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final String SECTION_TRACE_OUT_FILENAME = "FaultSections_Trace2002.txt";
    private static final String SECTION_NAMES_FILENAME = "FaultSections_Name2002.txt";

    public Read2002FaultSections() {
        ArrayList<FaultSection2002> faultSections = this.faultSection2002DAO.getAllFaultSections();
        try {
            FileWriter fwTrace = new FileWriter(SECTION_TRACE_OUT_FILENAME);
            FileWriter fwNames = new FileWriter(SECTION_NAMES_FILENAME);
            fwTrace.write("#SectionName,AvgUppeSeisDepth, AvgLowerSeisDepth, AveDip\n");
            for (int i = 0; i < faultSections.size(); ++i) {
                FaultSection2002 faultSection = faultSections.get(i);
                fwTrace.write("#" + faultSection.getSectionName() + "," + faultSection.getAveUpperSeisDepth() + "," + faultSection.getAveLowerSeisDepth() + "," + faultSection.getAveDip() + "\n");
                fwNames.write("#" + faultSection.getSectionName() + "\n");
                FaultTrace faultTrace = faultSection.getFaultTrace();
                int numFaultTraceLocations = faultTrace.getNumLocations();
                double upperSeisDepth = faultSection.getAveUpperSeisDepth();
                for (int j = 0; j < numFaultTraceLocations; ++j) {
                    Location loc = (Location)faultTrace.get(j);
                    fwTrace.write(loc.getLongitude() + "\t" + loc.getLatitude() + "\t" + upperSeisDepth + "\n");
                }
            }
            fwTrace.close();
            fwNames.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Read2002FaultSections read2002FaultSections1 = new Read2002FaultSections();
    }
}

