/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.DiscretizedFuncEstimate;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.IntegerEstimate;
import org.opensha.commons.data.estimate.LogNormalEstimate;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.refFaultParamDb.dao.db.CombinedEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.gui.LoginWindow;
import org.opensha.refFaultParamDb.gui.view.SiteSelectionAPI;
import org.opensha.refFaultParamDb.gui.view.ViewCumDisplacement;
import org.opensha.refFaultParamDb.gui.view.ViewIndividualEvent;
import org.opensha.refFaultParamDb.gui.view.ViewNumEvents;
import org.opensha.refFaultParamDb.gui.view.ViewSequences;
import org.opensha.refFaultParamDb.gui.view.ViewSiteCharacteristics;
import org.opensha.refFaultParamDb.gui.view.ViewSlipRate;
import org.opensha.refFaultParamDb.gui.view.ViewTimeSpan;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.EventSequence;
import org.opensha.refFaultParamDb.vo.PaleoEvent;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.Reference;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public class PaleoSiteApp2
extends JFrame
implements SiteSelectionAPI,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String APP_NAME = "California Reference Geologic Fault Parameter (Paleo Site) GUI";
    public static final String APP_SHORT_NAME = "PaleoSites";
    private static ApplicationVersion version;
    private static DefaultExceptionHandler eh;
    private static final DB_AccessAPI dbConnection;
    private static final int WIDTH = 925;
    private static final int HEIGHT = 800;
    private static final String TIMESPAN_PARAM_NAME = "TimeSpans";
    private static final String DATA_SPECIFIC_TO_TIME_INTERVALS = "Data currently in this database";
    private static final String SLIP_DISP_NUMEVENTS_SEQUENCES_TITLE = "Slip Rate, Displacement and Num Events";
    private static final String EVENTS_TITLE = "Events";
    private static final String SLIP_RATE_TITLE = "Slip Rate";
    private static final String DISPLACEMENT_TITLE = "Displacement";
    private static final String NUM_EVENTS_TITLE = "Num Events";
    private static final String SEQUENCE_TITLE = "Sequences";
    private ViewSiteCharacteristics viewPaleoSites;
    private StringParameter timeSpanParam;
    private ConstrainedStringParameterEditor timeSpanParamEditor;
    private BorderLayout borderLayout2 = new BorderLayout();
    private JSplitPane topSplitPane = new JSplitPane();
    private JPanel mainPanel = new JPanel();
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane infoForTimeSpanSplitPane = new JSplitPane();
    private JSplitPane timespanSplitPane = new JSplitPane();
    private JSplitPane timeSpanSelectionSplitPane = new JSplitPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane statusScrollPane = new JScrollPane();
    private JTextArea statusTextArea = new JTextArea();
    private JTabbedPane eventSequenceTabbedPane = new JTabbedPane();
    private JTabbedPane slipDispNumEventsTabbedPane = new JTabbedPane();
    private ViewTimeSpan timeSpanPanel = new ViewTimeSpan();
    private LabeledBoxPanel availableTimeSpansPanel;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private ViewSlipRate slipRatePanel = new ViewSlipRate();
    private ViewCumDisplacement displacementPanel = new ViewCumDisplacement();
    private ViewNumEvents numEventsPanel = new ViewNumEvents();
    private ViewIndividualEvent individualEventPanel = new ViewIndividualEvent(dbConnection);
    private ViewSequences sequencesPanel = new ViewSequences();
    private ArrayList combinedEventsInfoList;
    private CombinedEventsInfo combinedEventsInfo;
    private PaleoSite paleoSite;
    private CombinedEventsInfoDB_DAO combinedEventsInfoDAO;
    private static final String NOT_AVAILABLE = "Not Available";
    private CalcProgressBar progressBar = new CalcProgressBar("Retrieving data", "Retrieving data from database....");
    private static final String MSG_ERROR_RETRIEVING_DATA = "Error Retrieving data for the site";

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public PaleoSiteApp2() {
        eh.setApp(this);
        eh.setParent(this);
        this.combinedEventsInfoDAO = new CombinedEventsInfoDB_DAO(dbConnection);
        try {
            this.setTitle("California Reference Geologic Fault Parameter (Paleo Site) GUI (" + String.valueOf(PaleoSiteApp2.getAppVersion()) + ")");
            this.jbInit();
            this.addTimeSpansPanel();
            this.addSitesPanel();
            this.pack();
            this.setSize(925, 800);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTimeSpansPanel() {
        this.availableTimeSpansPanel = new LabeledBoxPanel(this.gridBagLayout);
        this.availableTimeSpansPanel.setTitle(DATA_SPECIFIC_TO_TIME_INTERVALS);
        this.timeSpanSelectionSplitPane.add((Component)this.availableTimeSpansPanel, "top");
    }

    private void makeTimeSpanParamAndEditor() throws ConstraintException {
        if (this.timeSpanParamEditor != null) {
            this.availableTimeSpansPanel.remove(this.timeSpanParamEditor);
        }
        ArrayList timeSpans = this.getAllTimeSpans();
        this.timeSpanParam = new StringParameter(TIMESPAN_PARAM_NAME, timeSpans, (String)timeSpans.get(0));
        this.timeSpanParam.addParameterChangeListener(this);
        this.timeSpanParamEditor = new ConstrainedStringParameterEditor(this.timeSpanParam);
        this.availableTimeSpansPanel.add((Component)this.timeSpanParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewInfoBasedOnSelectedTimeSpan();
        this.availableTimeSpansPanel.updateUI();
    }

    private ArrayList getAllTimeSpans() {
        ArrayList<Object> timeSpansList = new ArrayList<Object>();
        if (this.isTestSite()) {
            timeSpansList.add("TimeSpan 1");
            timeSpansList.add("TimeSpan 2");
        } else if (!this.isValidSiteAndInfoAvailable()) {
            timeSpansList.add(NOT_AVAILABLE);
        } else {
            for (int i = this.combinedEventsInfoList.size() - 1; i >= 0; --i) {
                CombinedEventsInfo combinedEventsInfo = (CombinedEventsInfo)this.combinedEventsInfoList.get(i);
                ArrayList<Reference> referenceList = combinedEventsInfo.getReferenceList();
                timeSpansList.add(this.getTimeString(combinedEventsInfo.getStartTime()) + " to " + this.getTimeString(combinedEventsInfo.getEndTime()) + "     (Entry Date:" + combinedEventsInfo.getEntryDate() + ")");
            }
        }
        return timeSpansList;
    }

    private String getReferencesAsString(ArrayList references) {
        Object str = "";
        for (int i = 0; i < references.size(); ++i) {
            str = (String)str + ((Reference)references.get(i)).getSummary() + ";";
        }
        return str;
    }

    private boolean isTestSite() {
        return this.combinedEventsInfoList == null && (this.paleoSite == null || this.paleoSite.getSiteName().equalsIgnoreCase("A Sample Site"));
    }

    private boolean isValidSiteAndInfoAvailable() {
        return this.combinedEventsInfoList != null && this.combinedEventsInfoList.size() > 0;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(TIMESPAN_PARAM_NAME)) {
            this.viewInfoBasedOnSelectedTimeSpan();
        }
    }

    private void viewInfoBasedOnSelectedTimeSpan() {
        ArrayList<String> allowedStrings = this.timeSpanParam.getAllowedStrings();
        String timeSpan = (String)this.timeSpanParam.getValue();
        int index = allowedStrings.indexOf(timeSpan);
        this.combinedEventsInfo = this.isValidSiteAndInfoAvailable() ? (CombinedEventsInfo)this.combinedEventsInfoList.get(index) : null;
        this.viewSlipRateForTimePeriod(this.combinedEventsInfo);
        this.viewNumEventsForTimePeriod(this.combinedEventsInfo);
        this.viewDisplacementForTimePeriod(this.combinedEventsInfo);
        this.viewSequencesForTimePeriod(this.combinedEventsInfo);
        this.viewTimeSpanInfo(this.combinedEventsInfo);
    }

    private String getTimeString(TimeAPI time) {
        Object timeString = "";
        DecimalFormat yearFormat = new DecimalFormat("0");
        DecimalFormat kaFormat = new DecimalFormat("0.##");
        if (time instanceof ExactTime) {
            ExactTime exactTime = (ExactTime)time;
            timeString = exactTime.getIsNow() ? (String)timeString + "Now" : (String)timeString + exactTime.getYear() + " " + exactTime.getEra();
        } else if (time instanceof TimeEstimate) {
            TimeEstimate timeEstimate = (TimeEstimate)time;
            DecimalFormat format = timeEstimate.isKaSelected() ? kaFormat : yearFormat;
            Estimate estimate = timeEstimate.getEstimate();
            if (estimate instanceof NormalEstimate) {
                timeString = (String)timeString + format.format(estimate.getMean());
            } else if (estimate instanceof LogNormalEstimate) {
                timeString = (String)timeString + format.format(((LogNormalEstimate)estimate).getLinearMedian());
            } else if (estimate instanceof DiscretizedFuncEstimate) {
                AbstractDiscretizedFunc func = ((DiscretizedFuncEstimate)estimate).getValues();
                timeString = (String)timeString + format.format(func.getFirstInterpolatedX(func.getMaxY()));
            } else if (estimate instanceof MinMaxPrefEstimate) {
                MinMaxPrefEstimate minMaxPrefEst = (MinMaxPrefEstimate)estimate;
                if (!Double.isNaN(minMaxPrefEst.getPreferred())) {
                    timeString = (String)timeString + format.format(minMaxPrefEst.getPreferred());
                } else if (!Double.isNaN(minMaxPrefEst.getMaximum())) {
                    timeString = (String)timeString + format.format(minMaxPrefEst.getMaximum());
                } else if (!Double.isNaN(minMaxPrefEst.getMinimum())) {
                    timeString = (String)timeString + format.format(minMaxPrefEst.getMinimum());
                }
            }
            timeString = timeEstimate.isKaSelected() ? (String)timeString + "ka" : (String)timeString + " " + timeEstimate.getEra();
        }
        return timeString;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout2);
        this.mainPanel.setLayout(this.borderLayout1);
        this.mainSplitPane.setOrientation(1);
        this.timespanSplitPane.setOrientation(1);
        this.topSplitPane.setOrientation(0);
        this.timeSpanSelectionSplitPane.setOrientation(0);
        this.statusTextArea.setEnabled(false);
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setText("");
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.topSplitPane, "Center");
        this.topSplitPane.add((Component)this.mainPanel, "top");
        this.mainPanel.add((Component)this.mainSplitPane, "Center");
        this.eventSequenceTabbedPane.add(SLIP_DISP_NUMEVENTS_SEQUENCES_TITLE, this.timeSpanSelectionSplitPane);
        this.eventSequenceTabbedPane.add(EVENTS_TITLE, this.individualEventPanel);
        this.mainSplitPane.add((Component)this.eventSequenceTabbedPane, "right");
        this.timeSpanSelectionSplitPane.add((Component)this.timespanSplitPane, "bottom");
        this.timespanSplitPane.add((Component)this.slipDispNumEventsTabbedPane, "right");
        this.topSplitPane.add((Component)this.statusScrollPane, "bottom");
        this.statusScrollPane.getViewport().add((Component)this.statusTextArea, null);
        this.timespanSplitPane.add((Component)this.timeSpanPanel, "left");
        this.topSplitPane.setDividerLocation(625);
        this.mainSplitPane.setDividerLocation(200);
        this.timeSpanSelectionSplitPane.setDividerLocation(75);
        this.timespanSplitPane.setDividerLocation(300);
        this.slipDispNumEventsTabbedPane.add(SLIP_RATE_TITLE, this.slipRatePanel);
        this.slipDispNumEventsTabbedPane.add(DISPLACEMENT_TITLE, this.displacementPanel);
        this.slipDispNumEventsTabbedPane.add(NUM_EVENTS_TITLE, this.numEventsPanel);
        this.slipDispNumEventsTabbedPane.add(SEQUENCE_TITLE, this.sequencesPanel);
    }

    private void addSitesPanel() {
        this.viewPaleoSites = new ViewSiteCharacteristics(dbConnection, this);
        this.mainSplitPane.add((Component)this.viewPaleoSites, "left");
    }

    @Override
    public CombinedEventsInfo getSelectedCombinedInfo() {
        return this.combinedEventsInfo;
    }

    private void viewSlipRateForTimePeriod(CombinedEventsInfo combinedEventsInfo) {
        if (this.isTestSite()) {
            CombinedSlipRateInfo combinedSlipRateInfo = new CombinedSlipRateInfo();
            LogNormalEstimate slipRateEstimate = new LogNormalEstimate(1.5, 0.25);
            combinedSlipRateInfo.setSlipRateEstimate(new EstimateInstances(slipRateEstimate, "units"));
            NormalEstimate aSiemsicSlipEstimate = new NormalEstimate(0.7, 0.5);
            combinedSlipRateInfo.setASeismicSlipFactorEstimateForSlip(new EstimateInstances(aSiemsicSlipEstimate, "units"));
            String comments = "Pertinent comments will be displayed here";
            combinedSlipRateInfo.setSlipRateComments(comments);
            this.slipRatePanel.setInfo(combinedSlipRateInfo);
        } else if (this.isValidSiteAndInfoAvailable() && combinedEventsInfo.getCombinedSlipRateInfo() != null) {
            CombinedSlipRateInfo combinedSlipRateInfo = combinedEventsInfo.getCombinedSlipRateInfo();
            this.slipRatePanel.setInfo(combinedSlipRateInfo);
        } else {
            this.slipRatePanel.setInfo(null);
        }
    }

    private void viewSequencesForTimePeriod(CombinedEventsInfo combinedEventsInfo) {
        if (this.isTestSite()) {
            ArrayList<EventSequence> fakeSeqList = new ArrayList<EventSequence>();
            EventSequence seq1 = new EventSequence();
            EventSequence seq2 = new EventSequence();
            fakeSeqList.add(seq1);
            fakeSeqList.add(seq2);
            seq1.setSequenceName("Test Sequence 1");
            seq2.setSequenceName("Test Sequence 2");
            String comments = "Comments about this sequence";
            seq1.setComments(comments);
            seq2.setComments(comments);
            PaleoEvent event1 = new PaleoEvent();
            event1.setEventName("Event 5");
            PaleoEvent event2 = new PaleoEvent();
            event2.setEventName("Event 6");
            ArrayList<PaleoEvent> eventsList = new ArrayList<PaleoEvent>();
            eventsList.add(event1);
            eventsList.add(event2);
            seq1.setEventsParam(eventsList);
            seq2.setEventsParam(eventsList);
            double sequenceProb = 0.5;
            seq1.setSequenceProb(sequenceProb);
            seq2.setSequenceProb(sequenceProb);
            double[] missedEventProb = new double[]{0.1, 0.5, 0.4};
            seq1.setMissedEventsProbList(missedEventProb);
            seq2.setMissedEventsProbList(missedEventProb);
            this.sequencesPanel.setSequenceList(fakeSeqList);
        } else if (this.isValidSiteAndInfoAvailable() && combinedEventsInfo.getEventSequence() != null) {
            this.sequencesPanel.setSequenceList(combinedEventsInfo.getEventSequence());
        } else {
            this.sequencesPanel.setSequenceList(null);
        }
    }

    private void viewDisplacementForTimePeriod(CombinedEventsInfo combinedEventsInfo) {
        if (this.isTestSite()) {
            CombinedDisplacementInfo combinedDisplacementInfo = new CombinedDisplacementInfo();
            combinedDisplacementInfo.setMeasuredComponentQual("Total");
            MinMaxPrefEstimate diplacementEstimate = new MinMaxPrefEstimate(60.0, 150.0, 95.0, 0.2, 0.8, 0.7);
            combinedDisplacementInfo.setDisplacementEstimate(new EstimateInstances(diplacementEstimate, "units"));
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            func.set(0.0, 0.1);
            func.set(0.5, 0.4);
            func.set(0.6, 0.4);
            func.set(1.0, 0.1);
            DiscreteValueEstimate aSiemsicSlipEstimate = new DiscreteValueEstimate(func, true);
            combinedDisplacementInfo.setASeismicSlipFactorEstimateForDisp(new EstimateInstances(aSiemsicSlipEstimate, "units"));
            String comments = "Pertinent comments will be displayed here";
            combinedDisplacementInfo.setDisplacementComments(comments);
            combinedDisplacementInfo.setSenseOfMotionQual("RL-R");
            MinMaxPrefEstimate rakeEst = new MinMaxPrefEstimate(165.0, 180.0, 170.0, 0.4, 0.7, 0.5);
            combinedDisplacementInfo.setSenseOfMotionRake(new EstimateInstances(rakeEst, ""));
            this.displacementPanel.setInfo(combinedDisplacementInfo);
        } else if (this.isValidSiteAndInfoAvailable() && combinedEventsInfo.getCombinedDisplacementInfo() != null) {
            CombinedDisplacementInfo combinedDisplacementInfo = combinedEventsInfo.getCombinedDisplacementInfo();
            this.displacementPanel.setInfo(combinedDisplacementInfo);
        } else {
            this.displacementPanel.setInfo(null);
        }
    }

    private void viewNumEventsForTimePeriod(CombinedEventsInfo combinedEventsInfo) {
        if (this.isTestSite()) {
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            func.set(4.0, 0.2);
            func.set(5.0, 0.3);
            func.set(6.0, 0.1);
            func.set(7.0, 0.4);
            func.setXAxisName("# Events");
            func.setYAxisName("Prob this is correct #");
            IntegerEstimate numEventsEstimate = new IntegerEstimate(func, false);
            String comments = "Pertinent comments will be displayed here";
            this.numEventsPanel.setInfo(numEventsEstimate, comments);
        } else if (this.isValidSiteAndInfoAvailable() && combinedEventsInfo.getCombinedNumEventsInfo() != null) {
            CombinedNumEventsInfo combinedNumEventsInfo = combinedEventsInfo.getCombinedNumEventsInfo();
            this.numEventsPanel.setInfo(combinedNumEventsInfo.getNumEventsEstimate().getEstimate(), combinedNumEventsInfo.getNumEventsComments());
        } else {
            this.numEventsPanel.setInfo(null, null);
        }
    }

    @Override
    public void siteSelected(PaleoSite paleoSite, int referenceId) {
        this.paleoSite = paleoSite;
        this.progressBar.setVisible(true);
        try {
            if (paleoSite == null) {
                String siteName = "A Sample Site";
                this.combinedEventsInfoList = null;
            } else {
                String siteName = paleoSite.getSiteName();
                this.combinedEventsInfoList = this.combinedEventsInfoDAO.getCombinedEventsInfoList(paleoSite.getSiteId(), referenceId);
            }
            this.makeTimeSpanParamAndEditor();
            this.individualEventPanel.setSite(paleoSite);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, MSG_ERROR_RETRIEVING_DATA);
        }
        this.progressBar.setVisible(false);
    }

    private void viewTimeSpanInfo(CombinedEventsInfo combinedEventsInfo) {
        if (this.isTestSite()) {
            ExactTime endTime = new ExactTime(1857, 1, 15, 10, 56, 21, "AD", false);
            TimeEstimate startTime = new TimeEstimate();
            startTime.setForKaUnits(new NormalEstimate(1000.0, 50.0), 1950);
            String comments = "Summary of Dating techniques and dated features ";
            ArrayList<String> references = new ArrayList<String>();
            references.add("Ref 4");
            references.add("Ref 1");
            this.timeSpanPanel.setTimeSpan(startTime, endTime, comments, references, null, null, null);
        } else if (this.isValidSiteAndInfoAvailable()) {
            ArrayList<Reference> refList = combinedEventsInfo.getReferenceList();
            ArrayList<String> summaryList = new ArrayList<String>();
            for (int i = 0; i < refList.size(); ++i) {
                summaryList.add(refList.get(i).getSummary());
            }
            this.timeSpanPanel.setTimeSpan(combinedEventsInfo.getStartTime(), combinedEventsInfo.getEndTime(), combinedEventsInfo.getDatedFeatureComments(), summaryList, combinedEventsInfo.getEntryDate(), combinedEventsInfo.getContributorName(), combinedEventsInfo.getDataSource());
        } else {
            this.timeSpanPanel.setTimeSpan(null, null, null, null, null, null, null);
        }
    }

    public static void main(String[] args) {
        eh = new DefaultExceptionHandler(APP_SHORT_NAME, PaleoSiteApp2.getAppVersion(), null, null);
        new LoginWindow(dbConnection, PaleoSiteApp2.class.getName());
    }

    static {
        dbConnection = DB_ConnectionPool.getLatestReadWriteConn();
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

