/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.connections;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionConnectionsDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.connections.ConnectionsTableModel;
import org.opensha.refFaultParamDb.gui.addEdit.connections.PotentialConnectionPoint;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.FaultSectionConnection;
import org.opensha.refFaultParamDb.vo.FaultSectionConnectionList;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public class ConnectionsEditor
extends JPanel
implements ActionListener,
ParameterChangeListener {
    private FaultSectionVer2_DB_DAO fs2db;
    private FaultSectionConnectionsDB_DAO connsDB;
    private DB_AccessAPI db;
    FaultSectionConnectionList conns;
    private JTable table;
    private ConnectionsTableModel model;
    private JButton updateForEditingButton = new JButton("Enable/Refresh For Editing");
    private ArrayList<FaultSectionData> sectionData;
    private HashMap<Integer, FaultSectionData> sectionDataIDMap;
    private HashMap<Integer, ArrayList<PotentialConnectionPoint>> potentialConnectionsMap;
    private static final String DEFAULT_PARAM_MESSAGE = "(enable above to edit)";
    private static final String FIRST_SELECTION_NAME = "Fault 1";
    private StringParameter firstSectionSelector;
    private static final String SECOND_SELECTION_NAME = "Fault 2";
    private StringParameter secondSectionSelector;
    private static final String LOCATION_SELECTION_NAME = "End Locations";
    private static final String LOCATION_SELECTION_START_START = "[Start] to [Start]";
    private static final String LOCATION_SELECTION_START_END = "[Start] to [End]";
    private static final String LOCATION_SELECTION_END_START = "[End] to [Start]";
    private static final String LOCATION_SELECTION_END_END = "[End] to [End]";
    private StringParameter locationSelector;
    private FaultSectionData curFirstSection;
    private ArrayList<PotentialConnectionPoint> curSortedPotentialConnections;
    private PotentialConnectionPoint curSelectedConnection;
    private JButton addButton = new JButton("Add");
    private JButton removeButton = new JButton("Remove Selected");

    public ConnectionsEditor(DB_AccessAPI db) {
        super(new BorderLayout());
        this.db = db;
        this.connsDB = new FaultSectionConnectionsDB_DAO(db);
        this.fs2db = new FaultSectionVer2_DB_DAO(db);
        this.model = new ConnectionsTableModel(null, null);
        this.table = new JTable(this.model);
        this.updateConnections();
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.updateForEditingButton.addActionListener(this);
        this.add((Component)this.updateForEditingButton, "North");
        this.add((Component)tableScroll, "Center");
        this.firstSectionSelector = new StringParameter(FIRST_SELECTION_NAME, Lists.newArrayList((Object[])new String[]{DEFAULT_PARAM_MESSAGE}));
        this.firstSectionSelector.setValue(DEFAULT_PARAM_MESSAGE);
        this.firstSectionSelector.addParameterChangeListener(this);
        this.secondSectionSelector = new StringParameter(SECOND_SELECTION_NAME, Lists.newArrayList((Object[])new String[]{DEFAULT_PARAM_MESSAGE}));
        this.secondSectionSelector.setValue(DEFAULT_PARAM_MESSAGE);
        this.secondSectionSelector.addParameterChangeListener(this);
        this.locationSelector = new StringParameter(LOCATION_SELECTION_NAME, Lists.newArrayList((Object[])new String[]{DEFAULT_PARAM_MESSAGE}));
        this.locationSelector.setValue(DEFAULT_PARAM_MESSAGE);
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BoxLayout(editorPanel, 1));
        JPanel paramEditPanel = new JPanel();
        paramEditPanel.setLayout(new BoxLayout(paramEditPanel, 0));
        paramEditPanel.add(this.firstSectionSelector.getEditor().getComponent());
        paramEditPanel.add(this.secondSectionSelector.getEditor().getComponent());
        paramEditPanel.add(this.locationSelector.getEditor().getComponent());
        paramEditPanel.add(this.addButton);
        this.addButton.addActionListener(this);
        paramEditPanel.add(this.removeButton);
        this.removeButton.addActionListener(this);
        editorPanel.add(paramEditPanel);
        this.updateEnables();
        this.add((Component)editorPanel, "South");
    }

    private void updateConnections() {
        this.conns = this.connsDB.getAllConnections();
        this.model.setConnections(this.conns);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateForEditingButton) {
            System.out.println("Fetching fault sections...");
            CalcProgressBar progress = new CalcProgressBar("Updating", null);
            progress.setProgressMessage("Fetching Fault Sections...");
            progress.showProgress(true);
            this.sectionData = this.fs2db.getAllFaultSections();
            Collections.sort(this.sectionData, new NamedComparator());
            this.sectionDataIDMap = new HashMap();
            this.potentialConnectionsMap = new HashMap();
            progress.setProgressMessage("Calculating Distances...");
            for (FaultSectionData data : this.sectionData) {
                this.sectionDataIDMap.put(data.getSectionId(), data);
                this.potentialConnectionsMap.put(data.getSectionId(), new ArrayList());
            }
            System.out.println("Finding possible connections...");
            for (FaultSectionData data1 : this.sectionData) {
                ArrayList<PotentialConnectionPoint> conns = this.potentialConnectionsMap.get(data1.getSectionId());
                for (FaultSectionData data2 : this.sectionData) {
                    PotentialConnectionPoint conn;
                    if (data1 == data2 || conns.contains(conn = new PotentialConnectionPoint(data1, data2))) continue;
                    conn.compute();
                    conns.add(conn);
                    this.potentialConnectionsMap.get(data2.getSectionId()).add(conn.getReversal());
                }
            }
            progress.showProgress(false);
            System.out.println("done.");
            this.model.setFaultSectionData(this.sectionDataIDMap);
            this.updateEnables();
            this.updateFirstSelector();
        } else if (e.getSource() == this.addButton) {
            Location loc2;
            Location loc1;
            int id2;
            int id1 = this.curSelectedConnection.getFSD1().getSectionId();
            if (this.conns.containsConnectionBetween(id1, id2 = this.curSelectedConnection.getFSD2().getSectionId())) {
                JOptionPane.showMessageDialog(this, "A connection already exists between these faults", "Connection Already Exsists!", 0);
                return;
            }
            FaultTrace trace1 = this.curSelectedConnection.getFSD1().getFaultTrace();
            FaultTrace trace2 = this.curSelectedConnection.getFSD2().getFaultTrace();
            int locInd = ((StringConstraint)this.locationSelector.getConstraint()).getAllowedStrings().indexOf(this.locationSelector.getValue());
            switch (locInd) {
                case 0: {
                    loc1 = (Location)trace1.get(0);
                    loc2 = (Location)trace2.get(0);
                    break;
                }
                case 1: {
                    loc1 = (Location)trace1.get(0);
                    loc2 = (Location)trace2.get(trace2.size() - 1);
                    break;
                }
                case 2: {
                    loc1 = (Location)trace1.get(trace1.size() - 1);
                    loc2 = (Location)trace2.get(0);
                    break;
                }
                case 3: {
                    loc1 = (Location)trace1.get(trace1.size() - 1);
                    loc2 = (Location)trace2.get(trace2.size() - 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal location index: " + locInd);
                }
            }
            FaultSectionConnection conn = new FaultSectionConnection(id1, id2, loc1, loc2);
            this.connsDB.addConnection(conn);
            this.updateConnections();
        } else if (e.getSource() == this.removeButton) {
            int[] rows = this.table.getSelectedRows();
            if (rows == null || rows.length == 0) {
                JOptionPane.showMessageDialog(this, "No connections selected for removal.", "Nothing selected.", 1);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove " + rows.length + " rows?", "Removing " + rows.length + " Rows", 2, 2);
            if (ret == 0) {
                for (int row : rows) {
                    int id1 = (Integer)this.model.getValueAt(row, 0);
                    int id2 = (Integer)this.model.getValueAt(row, 2);
                    System.out.println("Removing connection: " + id1 + " => " + id2);
                    this.connsDB.removeConnection(id1, id2);
                }
            }
            this.updateConnections();
        }
    }

    private void updateEnables() {
        boolean updated = this.sectionData != null;
        boolean editable = SessionInfo.getContributor() != null;
        this.firstSectionSelector.getEditor().setEnabled(updated);
        this.secondSectionSelector.getEditor().setEnabled(updated);
        this.locationSelector.getEditor().setEnabled(updated);
        this.addButton.setEnabled(updated && editable);
        this.removeButton.setEnabled(editable);
    }

    private ArrayList<String> getSectionNames(int skipID) {
        ArrayList<String> names = new ArrayList<String>();
        for (FaultSectionData data : this.sectionData) {
            if (data.getSectionId() == skipID) continue;
            names.add(data.getSectionId() + ". " + data.getSectionName());
        }
        return names;
    }

    private void updateFirstSelector() {
        System.out.println("Updating first selector");
        ArrayList<String> names = this.getSectionNames(-1);
        StringConstraint constr = (StringConstraint)this.firstSectionSelector.getConstraint();
        constr.setStrings(names);
        this.firstSectionSelector.setValue(names.get(0));
        this.firstSectionSelector.getEditor().refreshParamEditor();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.firstSectionSelector) {
            System.out.println("Updating second selector");
            int sectionInd = ((StringConstraint)this.firstSectionSelector.getConstraint()).getAllowedStrings().indexOf(this.firstSectionSelector.getValue());
            this.curFirstSection = this.sectionData.get(sectionInd);
            this.curSortedPotentialConnections = new ArrayList();
            this.curSortedPotentialConnections.addAll((Collection<PotentialConnectionPoint>)this.potentialConnectionsMap.get(this.curFirstSection.getSectionId()));
            Collections.sort(this.curSortedPotentialConnections);
            ArrayList<CallSite> potentialNames = new ArrayList<CallSite>();
            for (PotentialConnectionPoint pot : this.curSortedPotentialConnections) {
                potentialNames.add((CallSite)((Object)(pot.getFSD2().getSectionId() + ". " + pot.getFSD2().getName())));
            }
            this.secondSectionSelector.removeParameterChangeListener(this);
            ((StringConstraint)this.secondSectionSelector.getConstraint()).setStrings(potentialNames);
            this.secondSectionSelector.setValue((String)potentialNames.get(0));
            this.secondSectionSelector.getEditor().refreshParamEditor();
            this.secondUpdated();
            this.secondSectionSelector.addParameterChangeListener(this);
        } else if (event.getParameter() == this.secondSectionSelector) {
            this.secondUpdated();
        }
    }

    private void secondUpdated() {
        double d00;
        System.out.println("Updating location");
        this.curSelectedConnection = this.curSortedPotentialConnections.get(((StringConstraint)this.secondSectionSelector.getConstraint()).getAllowedStrings().indexOf(this.secondSectionSelector.getValue()));
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        int minInd = -1;
        double min = d00 = this.curSelectedConnection.getDistance(0, 0);
        minInd = 0;
        strings.add((CallSite)((Object)("[Start] to [Start]: " + (float)d00 + " KM")));
        double d01 = this.curSelectedConnection.getDistance(0, 1);
        if (d01 < min) {
            min = d01;
            minInd = 1;
        }
        strings.add((CallSite)((Object)("[Start] to [End]: " + (float)d01 + " KM")));
        double d10 = this.curSelectedConnection.getDistance(1, 0);
        if (d10 < min) {
            min = d10;
            minInd = 2;
        }
        strings.add((CallSite)((Object)("[End] to [Start]: " + (float)d10 + " KM")));
        double d11 = this.curSelectedConnection.getDistance(1, 1);
        if (d11 < min) {
            min = d11;
            minInd = 3;
        }
        strings.add((CallSite)((Object)("[End] to [End]: " + (float)d11 + " KM")));
        ((StringConstraint)this.locationSelector.getConstraint()).setStrings(strings);
        this.locationSelector.setValue((String)strings.get(minInd));
        this.locationSelector.getEditor().refreshParamEditor();
    }
}

