/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class EditAseismicSlipFactor
extends JFrame
implements ActionListener {
    private static final String ASEISMIC_SLIP_FACTOR_PARAM_NAME = "Aseismic Slip Factor Estimate(0-1, 1=all aseismic)";
    private static final String ASEISMIC_SLIP_FACTOR = "Aseismic Slip Factor";
    private static final double ASEISMIC_SLIP_FACTOR_MIN = Double.NEGATIVE_INFINITY;
    private static final double ASEISMIC_SLIP_FACTOR_MAX = Double.POSITIVE_INFINITY;
    public static final String ASEISMIC_SLIP_FACTOR_UNITS = "";
    private EstimateParameter aSeismicSlipFactorParam;
    private ConstrainedEstimateParameterEditor aSeismicSlipFactorParamEditor;
    private static final String ASEISMIC_SLIP_FACTOR_PARAMS_TITLE = "Aseismic Slip Factor";
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    DeformationModelDB_DAO deformationModelDAO;
    private static final String MSG_UPDATE_SUCCESS = "Aseimsic Slip Factor updated succesfully for fault section in deformation model";
    private int deformationModelId;
    private int faultSectionId;
    private EstimateInstances aseismicSlipEst;

    public EditAseismicSlipFactor(DB_AccessAPI dbConnection, int deformationModelId, int faultSectionId, EstimateInstances aseismicSlipEst) {
        this.deformationModelDAO = new DeformationModelDB_DAO(dbConnection);
        this.deformationModelId = deformationModelId;
        this.faultSectionId = faultSectionId;
        this.aseismicSlipEst = aseismicSlipEst;
        this.getContentPane().setLayout(GUI_Utils.gridBagLayout);
        this.setTitle("Aseismic Slip Factor");
        this.makeAseismicSlipParameterAndEditor();
        this.addToGUI();
        if (SessionInfo.getContributor() == null) {
            this.okButton.setEnabled(false);
        }
        this.pack();
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.okButton) {
            try {
                this.deformationModelDAO.updateAseimsicSlipFactor(this.deformationModelId, this.faultSectionId, this.getAseismicSlipEstimate());
                JOptionPane.showMessageDialog(this, MSG_UPDATE_SUCCESS);
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
    }

    private void addToGUI() {
        this.getContentPane().add((Component)this.aSeismicSlipFactorParamEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void makeAseismicSlipParameterAndEditor() {
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.aSeismicSlipFactorParam = new EstimateParameter(ASEISMIC_SLIP_FACTOR_PARAM_NAME, ASEISMIC_SLIP_FACTOR_UNITS, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        if (this.aseismicSlipEst != null && this.aseismicSlipEst.getEstimate() != null) {
            this.aSeismicSlipFactorParam.setValue(this.aseismicSlipEst.getEstimate());
        }
        this.aSeismicSlipFactorParamEditor = new ConstrainedEstimateParameterEditor(this.aSeismicSlipFactorParam, true);
    }

    private EstimateInstances getAseismicSlipEstimate() {
        this.aSeismicSlipFactorParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.aSeismicSlipFactorParam.getValue(), ASEISMIC_SLIP_FACTOR_UNITS);
    }
}

