/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.AddDeformationModel;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.DeformationModelTable;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.DeformationModelTableModel;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.view.DeformationModelFileWriter;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;

public class EditDeformationModel
extends JPanel
implements ActionListener,
ParameterChangeListener {
    private ArrayList<DeformationModelSummary> deformationModelsList;
    private ArrayList<FaultSectionSummary> faultSectionsSummaryList;
    private DeformationModelDB_DAO deformationModelDB_DAO;
    private DeformationModelSummaryDB_DAO deformationModelSummaryDB_DAO;
    private FaultSectionVer2_DB_DAO faultSectionDB_DAO;
    private StringParameter deformationModelsParam;
    private static final String AVAILABLE_DEFORMATION_MODEL_PARAM_NAME = "Choose Deformation Model";
    private ConstrainedStringParameterEditor deformationModelsParamEditor;
    private JButton removeModelButton = new JButton("Remove Model");
    private JButton addModelButton = new JButton("Add Model");
    private DeformationModelTableModel tableModel;
    private DeformationModelTable table;
    private static final String TITLE = "Deformation Model";
    private JButton saveButton = new JButton("Save All to File");
    private static final String SAVE_BUTTON_TOOL_TIP = "Save All Fault Sections in this Fault Model to a txt file";
    private static final String MSG_ADD_MODEL_SUCCESS = "Deformation Model Added Successfully";
    private static final String MSG_REMOVE_MODEL_SUCCESS = "Deformation Model Removed Successfully";
    private static final String MSG_UPDATE_MODEL_SUCCESS = "Deformation Model Updated Successfully";
    private static final String MSG_NO_DEF_MODEL_EXISTS = "Currently, there is no Deformation Model";
    private StringParameter faultModelNameParam = new StringParameter("Fault Model");
    private StringParameterEditor faultModelNameParamEditor;
    private int selectedDeformationModelId;
    private ArrayList<Integer> faultSectionsIdListInDefModel;
    private DB_AccessAPI dbConnection;

    public EditDeformationModel(DB_AccessAPI dbConnection) {
        this.dbConnection = dbConnection;
        this.deformationModelDB_DAO = new DeformationModelDB_DAO(dbConnection);
        this.deformationModelSummaryDB_DAO = new DeformationModelSummaryDB_DAO(dbConnection);
        this.faultSectionDB_DAO = new FaultSectionVer2_DB_DAO(dbConnection);
        this.tableModel = new DeformationModelTableModel(dbConnection);
        this.table = new DeformationModelTable(dbConnection, this.tableModel);
        if (SessionInfo.getContributor() == null) {
            this.addModelButton.setEnabled(false);
            this.removeModelButton.setEnabled(false);
        } else {
            this.addModelButton.setEnabled(true);
            this.removeModelButton.setEnabled(true);
        }
        try {
            this.faultModelNameParamEditor = new StringParameterEditor((Parameter)this.faultModelNameParam);
            this.faultModelNameParamEditor.setEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadAllDeformationModels();
        this.addActionListeners();
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new GridBagLayout());
        int yPos = 1;
        JPanel buttonPanel = this.getButtonPanel();
        this.add((Component)buttonPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.faultModelNameParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.removeModelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.addModelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return buttonPanel;
    }

    private void addActionListeners() {
        this.removeModelButton.addActionListener(this);
        this.addModelButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.saveButton.setToolTipText(SAVE_BUTTON_TOOL_TIP);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        try {
            if (source == this.addModelButton) {
                new AddDeformationModel(this.dbConnection, this);
            } else if (source == this.removeModelButton) {
                String selectedDeformationModel = (String)this.deformationModelsParam.getValue();
                int deformationModelId = this.getDeformationModelSummary(selectedDeformationModel).getDeformationModelId();
                this.deformationModelSummaryDB_DAO.removeDeformationModel(deformationModelId);
                JOptionPane.showMessageDialog(this, MSG_REMOVE_MODEL_SUCCESS);
                this.loadAllDeformationModels();
            } else if (source == this.saveButton) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.showSaveDialog(this);
                File file = fileChooser.getSelectedFile();
                if (file != null) {
                    this.writeSectionsToFile(file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void writeSectionsToFile(File file) {
        DeformationModelFileWriter defModelWriter = new DeformationModelFileWriter(this.dbConnection);
        defModelWriter.writeForDeformationModel(this.selectedDeformationModelId, file, true);
    }

    public void newDeformationModelAdded() {
        this.loadAllDeformationModels();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setFaultSectionsBasedOnDefModel();
    }

    private void setFaultSectionsBasedOnDefModel() {
        String selectedDefModel = (String)this.deformationModelsParam.getValue();
        DeformationModelSummary defModelSummary = this.getDeformationModelSummary(selectedDefModel);
        this.selectedDeformationModelId = defModelSummary.getDeformationModelId();
        this.faultModelNameParam.setValue(defModelSummary.getFaultModel().getFaultModelName());
        this.faultModelNameParamEditor.refreshParamEditor();
        this.faultSectionsIdListInDefModel = this.deformationModelDB_DAO.getFaultSectionIdsForDeformationModel(this.selectedDeformationModelId);
        this.tableModel.setDeformationModel(this.selectedDeformationModelId, this.faultSectionsIdListInDefModel);
        this.tableModel.fireTableDataChanged();
    }

    private DeformationModelSummary getDeformationModelSummary(String selectedDeformationModel) {
        for (int i = 0; i < this.deformationModelsList.size(); ++i) {
            DeformationModelSummary deformationModel = this.deformationModelsList.get(i);
            if (!deformationModel.getDeformationModelName().equalsIgnoreCase(selectedDeformationModel)) continue;
            return deformationModel;
        }
        return null;
    }

    private void loadAllDeformationModels() {
        this.deformationModelsList = this.deformationModelSummaryDB_DAO.getAllDeformationModels();
        if (this.deformationModelsParamEditor != null) {
            this.remove(this.deformationModelsParamEditor);
        }
        this.updateUI();
        ArrayList<String> deformationModelNames = new ArrayList<String>();
        for (int i = 0; i < this.deformationModelsList.size(); ++i) {
            deformationModelNames.add(this.deformationModelsList.get(i).getDeformationModelName());
        }
        if (deformationModelNames == null || deformationModelNames.size() == 0) {
            this.removeModelButton.setEnabled(false);
            this.faultModelNameParam.setValue("");
            this.faultModelNameParamEditor.refreshParamEditor();
            return;
        }
        if (SessionInfo.getContributor() != null) {
            this.removeModelButton.setEnabled(true);
        }
        this.deformationModelsParam = new StringParameter(AVAILABLE_DEFORMATION_MODEL_PARAM_NAME, deformationModelNames, (String)deformationModelNames.get(0));
        this.deformationModelsParam.addParameterChangeListener(this);
        this.deformationModelsParamEditor = new ConstrainedStringParameterEditor(this.deformationModelsParam);
        this.add((Component)this.deformationModelsParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setFaultSectionsBasedOnDefModel();
        this.updateUI();
    }
}

