/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class EditSlipRate
extends JFrame
implements ActionListener {
    private static final String SLIP_RATE_PARAM_NAME = "Slip Rate Estimate";
    private static final String SLIP_RATE = "Slip Rate";
    public static final String SLIP_RATE_UNITS = "mm/yr";
    private static final double SLIP_RATE_MIN = Double.NEGATIVE_INFINITY;
    private static final double SLIP_RATE_MAX = Double.POSITIVE_INFINITY;
    private EstimateParameter slipRateEstimateParam;
    private ConstrainedEstimateParameterEditor slipRateEstimateParamEditor;
    private static final String SLIP_RATE_PARAMS_TITLE = "Slip Rate Params";
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    DeformationModelDB_DAO deformationModelDAO;
    private static final String MSG_UPDATE_SUCCESS = "Slip Rate updated succesfully for fault section in deformation model";
    private int deformationModelId;
    private int faultSectionId;
    private EstimateInstances slipRateEst;

    public EditSlipRate(DB_AccessAPI dbConnection, int deformationModelId, int faultSectionId, EstimateInstances slipRateEst) {
        this.deformationModelDAO = new DeformationModelDB_DAO(dbConnection);
        this.deformationModelId = deformationModelId;
        this.faultSectionId = faultSectionId;
        this.slipRateEst = slipRateEst;
        this.getContentPane().setLayout(GUI_Utils.gridBagLayout);
        this.setTitle(SLIP_RATE_PARAMS_TITLE);
        this.makeSlipRateParameterAndEditor();
        this.addToGUI();
        if (SessionInfo.getContributor() == null) {
            this.okButton.setEnabled(false);
        }
        this.pack();
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.okButton) {
            try {
                this.deformationModelDAO.updateSlipRate(this.deformationModelId, this.faultSectionId, this.getSlipRateEstimate());
                JOptionPane.showMessageDialog(this, MSG_UPDATE_SUCCESS);
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
    }

    private void addToGUI() {
        this.getContentPane().add((Component)this.slipRateEstimateParamEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void makeSlipRateParameterAndEditor() {
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.slipRateEstimateParam = new EstimateParameter(SLIP_RATE_PARAM_NAME, SLIP_RATE_UNITS, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        if (this.slipRateEst != null && this.slipRateEst.getEstimate() != null) {
            this.slipRateEstimateParam.setValue(this.slipRateEst.getEstimate());
        }
        this.slipRateEstimateParamEditor = new ConstrainedEstimateParameterEditor(this.slipRateEstimateParam, true);
    }

    private EstimateInstances getSlipRateEstimate() {
        this.slipRateEstimateParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.slipRateEstimateParam.getValue(), SLIP_RATE_UNITS);
    }
}

