/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.DeformationModelTableModel;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.EditAseismicSlipFactor;
import org.opensha.refFaultParamDb.gui.addEdit.deformationModel.EditSlipRate;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

class MouseListener
extends MouseAdapter {
    private JTable table;
    private DB_AccessAPI dbConnection;

    public MouseListener(DB_AccessAPI dbConnection, JTable table) {
        this.table = table;
        this.dbConnection = dbConnection;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Point p = event.getPoint();
        int row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        DeformationModelTableModel tableModel = (DeformationModelTableModel)this.table.getModel();
        int deformationModelId = tableModel.getdeformationModelId();
        int faultSectionId = tableModel.getFaultSectionId(row);
        if (column == 1) {
            EstimateInstances slipRateEst = (EstimateInstances)tableModel.getValueForSlipAndAseismicFactor(row, column);
            new EditSlipRate(this.dbConnection, deformationModelId, faultSectionId, slipRateEst);
        } else if (column == 2) {
            EstimateInstances aseismicSlipFactorEst = (EstimateInstances)tableModel.getValueForSlipAndAseismicFactor(row, column);
            new EditAseismicSlipFactor(this.dbConnection, deformationModelId, faultSectionId, aseismicSlipFactorEst);
        }
    }
}

