/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.faultModel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.CustomFileFilter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.faultModel.FaultModelTable;
import org.opensha.refFaultParamDb.gui.addEdit.faultModel.FaultModelTableModel;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.view.AbstractSectionInfoFileWriter;
import org.opensha.refFaultParamDb.gui.view.SectionInfoCSVFileWriter;
import org.opensha.refFaultParamDb.gui.view.SectionInfoTextFileWriter;
import org.opensha.refFaultParamDb.vo.FaultModelSummary;

public class AddEditFaultModel
extends JPanel
implements ActionListener,
ParameterChangeListener {
    private ArrayList faultModelsList;
    private ArrayList faultSectionsSummaryList;
    private FaultModelSummaryDB_DAO faultModelDB_DAO;
    private FaultModelDB_DAO faultModelSectionDB_DAO;
    private FaultSectionVer2_DB_DAO faultSectionDB_DAO;
    private StringParameter faultModelsParam;
    private static final String AVAILABLE_FAULT_MODEL_PARAM_NAME = "Choose Fault Model";
    private ConstrainedStringParameterEditor faultModelsParamEditor;
    private JButton removeModelButton = new JButton("Remove Model");
    private JButton addModelButton = new JButton("Add Model");
    private JButton updateModelButton = new JButton("Update Model");
    private JButton selectAllButton = new JButton("Select All");
    private JButton deselectAllButton = new JButton("Deselect All");
    private FaultModelTableModel tableModel;
    private FaultModelTable table;
    private static final String TITLE = "Fault Model";
    private JButton saveButton = new JButton("Save All to File");
    private static final String SAVE_BUTTON_TOOL_TIP = "Save All Fault Sections in this Fault Model to a txt file";
    private static final String MSG_ADD_MODEL_SUCCESS = "Model Added Successfully";
    private static final String MSG_REMOVE_MODEL_SUCCESS = "Model Removed Successfully";
    private static final String MSG_UPDATE_MODEL_SUCCESS = "Model Updated Successfully";
    private static final String MSG_NO_FAULT_MODEL_EXISTS = "Currently, there is no Fault Model";
    private static final String TEXT_PARAMS_DESC = "Text File - Fault Paramaters";
    private JFileChooser fileChooser;
    private DB_AccessAPI dbConnection;

    public AddEditFaultModel(DB_AccessAPI dbConnection) {
        this.dbConnection = dbConnection;
        this.faultModelDB_DAO = new FaultModelSummaryDB_DAO(dbConnection);
        this.faultModelSectionDB_DAO = new FaultModelDB_DAO(dbConnection);
        this.faultSectionDB_DAO = new FaultSectionVer2_DB_DAO(dbConnection);
        if (SessionInfo.getContributor() == null) {
            this.addModelButton.setEnabled(false);
            this.removeModelButton.setEnabled(false);
            this.updateModelButton.setEnabled(false);
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        } else {
            this.addModelButton.setEnabled(true);
            this.removeModelButton.setEnabled(true);
            this.updateModelButton.setEnabled(true);
            this.selectAllButton.setEnabled(true);
            this.deselectAllButton.setEnabled(true);
        }
        this.loadAllFaultSectionsSummary();
        this.loadAllFaultModels();
        this.addActionListeners();
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new GridBagLayout());
        int yPos = 1;
        JPanel adRemoveButtonPanel = this.getAddRemoveButtonPanel();
        this.add((Component)adRemoveButtonPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getSelectDeselectUpdateButtonPanel(), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getSelectDeselectUpdateButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.selectAllButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.deselectAllButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.updateModelButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return buttonPanel;
    }

    private JPanel getAddRemoveButtonPanel() {
        JPanel adRemoveButtonPanel = new JPanel();
        adRemoveButtonPanel.setLayout(new GridBagLayout());
        adRemoveButtonPanel.add((Component)this.removeModelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        adRemoveButtonPanel.add((Component)this.addModelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        adRemoveButtonPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return adRemoveButtonPanel;
    }

    private void addActionListeners() {
        this.removeModelButton.addActionListener(this);
        this.addModelButton.addActionListener(this);
        this.updateModelButton.addActionListener(this);
        this.selectAllButton.addActionListener(this);
        this.deselectAllButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.saveButton.setToolTipText(SAVE_BUTTON_TOOL_TIP);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        try {
            if (source == this.addModelButton) {
                String faultModelName = JOptionPane.showInputDialog(this, (Object)"Enter Fault Model Name");
                if (faultModelName == null) {
                    return;
                }
                this.addFaultModelToDB(faultModelName);
                JOptionPane.showMessageDialog(this, MSG_ADD_MODEL_SUCCESS);
                this.loadAllFaultModels();
            } else if (source == this.removeModelButton) {
                String selectedFaultModel = (String)this.faultModelsParam.getValue();
                int faultModelId = this.getFaultModelId(selectedFaultModel);
                this.faultModelDB_DAO.removeFaultModel(faultModelId);
                JOptionPane.showMessageDialog(this, MSG_REMOVE_MODEL_SUCCESS);
                this.loadAllFaultModels();
            } else if (source == this.updateModelButton) {
                ArrayList faultSectionIdList = this.tableModel.getSelectedFaultSectionsId();
                String selectedFaultModel = (String)this.faultModelsParam.getValue();
                int faultModelId = this.getFaultModelId(selectedFaultModel);
                this.faultModelSectionDB_DAO.replaceFaultSectionIDs(faultModelId, faultSectionIdList);
                JOptionPane.showMessageDialog(this, MSG_UPDATE_MODEL_SUCCESS);
            } else if (source == this.selectAllButton) {
                this.setAllRowsSelection(true);
            } else if (source == this.deselectAllButton) {
                this.setAllRowsSelection(false);
            } else if (source == this.saveButton) {
                this.doSave();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void doSave() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            CustomFileFilter textFilter = new CustomFileFilter("txt", TEXT_PARAMS_DESC);
            CustomFileFilter csvAllFilter = new CustomFileFilter("csv", SectionInfoCSVFileWriter.SaveType.CSV_ALL_POINTS.getDescription());
            CustomFileFilter csvTopBottomFilter = new CustomFileFilter("csv", SectionInfoCSVFileWriter.SaveType.CSV_TOP_BOTTOM_POINTS.getDescription());
            CustomFileFilter csvTraceFilter = new CustomFileFilter("csv", SectionInfoCSVFileWriter.SaveType.CSV_TRACE_DESC.getDescription());
            this.fileChooser.addChoosableFileFilter(textFilter);
            this.fileChooser.addChoosableFileFilter(csvAllFilter);
            this.fileChooser.addChoosableFileFilter(csvTopBottomFilter);
            this.fileChooser.addChoosableFileFilter(csvTraceFilter);
            this.fileChooser.setFileFilter(textFilter);
        }
        this.fileChooser.showSaveDialog(this);
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            this.writeSectionsToFile(file);
        }
    }

    private void writeSectionsToFile(File file) {
        ArrayList faultSectionIdList = this.getFaultSectionIdList();
        int[] faultSectionIds = new int[faultSectionIdList.size()];
        for (int i = 0; i < faultSectionIdList.size(); ++i) {
            faultSectionIds[i] = (Integer)faultSectionIdList.get(i);
        }
        CustomFileFilter filter = (CustomFileFilter)this.fileChooser.getFileFilter();
        AbstractSectionInfoFileWriter fileWriter = filter.getDescription().equals(TEXT_PARAMS_DESC) ? new SectionInfoTextFileWriter(this.dbConnection) : new SectionInfoCSVFileWriter(this.dbConnection, SectionInfoCSVFileWriter.SaveType.forDesc(filter.getDescription()));
        if (!StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)filter.getExtension())) {
            file = new File(file.getAbsolutePath() + filter.getExtension());
        }
        fileWriter.writeForFaultModel(faultSectionIds, file);
    }

    private void setAllRowsSelection(boolean isSelected) {
        int numRows = this.tableModel.getRowCount();
        Boolean val = isSelected;
        for (int i = 0; i < numRows; ++i) {
            this.tableModel.setValueAt(val, i, 0);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void addFaultModelToDB(String faultModelName) {
        FaultModelSummary faultModel = new FaultModelSummary();
        faultModel.setFaultModelName(faultModelName);
        this.faultModelDB_DAO.addFaultModel(faultModel);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setFaultSectionsBasedOnFaultModel();
    }

    private void setFaultSectionsBasedOnFaultModel() {
        ArrayList faultSectionIdList = this.getFaultSectionIdList();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt(false, i, 0);
        }
        int numSectionsInFaultModel = faultSectionIdList.size();
        for (int i = 0; i < numSectionsInFaultModel; ++i) {
            Integer faultSectionId = (Integer)faultSectionIdList.get(i);
            this.tableModel.setSelected(faultSectionId, true);
        }
        this.tableModel.fireTableDataChanged();
    }

    private ArrayList getFaultSectionIdList() {
        String selectedFaultModel = (String)this.faultModelsParam.getValue();
        int faultModelId = this.getFaultModelId(selectedFaultModel);
        ArrayList<Integer> faultSectionIdList = this.faultModelSectionDB_DAO.getFaultSectionIdList(faultModelId);
        return faultSectionIdList;
    }

    private int getFaultModelId(String selectedFaultModel) {
        for (int i = 0; i < this.faultModelsList.size(); ++i) {
            FaultModelSummary faultModel = (FaultModelSummary)this.faultModelsList.get(i);
            if (!faultModel.getFaultModelName().equalsIgnoreCase(selectedFaultModel)) continue;
            return faultModel.getFaultModelId();
        }
        return -1;
    }

    private void loadAllFaultModels() {
        this.faultModelsList = this.faultModelDB_DAO.getAllFaultModels();
        if (this.faultModelsParamEditor != null) {
            this.remove(this.faultModelsParamEditor);
        }
        this.updateUI();
        ArrayList<String> faultModelNames = new ArrayList<String>();
        for (int i = 0; i < this.faultModelsList.size(); ++i) {
            faultModelNames.add(((FaultModelSummary)this.faultModelsList.get(i)).getFaultModelName());
        }
        if (faultModelNames == null || faultModelNames.size() == 0) {
            this.updateModelButton.setEnabled(false);
            this.removeModelButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, MSG_NO_FAULT_MODEL_EXISTS);
            return;
        }
        if (SessionInfo.getContributor() != null) {
            this.updateModelButton.setEnabled(true);
            this.removeModelButton.setEnabled(true);
        }
        this.faultModelsParam = new StringParameter(AVAILABLE_FAULT_MODEL_PARAM_NAME, faultModelNames, (String)faultModelNames.get(0));
        this.faultModelsParam.addParameterChangeListener(this);
        this.setFaultSectionsBasedOnFaultModel();
        this.faultModelsParamEditor = new ConstrainedStringParameterEditor(this.faultModelsParam);
        this.add((Component)this.faultModelsParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateUI();
    }

    private void loadAllFaultSectionsSummary() {
        this.faultSectionsSummaryList = this.faultSectionDB_DAO.getAllFaultSectionsSummary();
        this.tableModel = new FaultModelTableModel(this.faultSectionsSummaryList);
        this.table = new FaultModelTable(this.dbConnection, this.tableModel);
    }
}

