/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringListParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.param.impl.StringListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteRepresentationDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddNewReference;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddNewSiteType;
import org.opensha.refFaultParamDb.gui.event.DbAdditionFrame;
import org.opensha.refFaultParamDb.gui.event.DbAdditionListener;
import org.opensha.refFaultParamDb.gui.event.DbAdditionSuccessEvent;
import org.opensha.refFaultParamDb.gui.infotools.ConnectToEmailServlet;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.Reference;
import org.opensha.refFaultParamDb.vo.SiteRepresentation;
import org.opensha.refFaultParamDb.vo.SiteType;

public class AddEditSiteCharacteristics
extends DbAdditionFrame
implements ActionListener,
ParameterChangeListener,
DbAdditionListener {
    private static final String SITE_NAME_PARAM_NAME = "Site Name";
    private static final String OLD_SITE_ID_PARAM_NAME = "QFault Site Id";
    private static final String SITE_LOCATION_PARAM_NAME = "Site Location";
    private static final String COMMENTS_PARAM_NAME = "Comments";
    private static final String CHOOSE_REFERENCE_PARAM_NAME = "Choose Reference";
    private static final String ASSOCIATED_WITH_FAULT_PARAM_NAME = "Associated With Fault";
    private static final String SITE_TYPE_PARAM_NAME = "Site Type";
    private static final String DIP_PARAM_NAME = "Dip Estimate";
    private static final String DIP_NAME = "Dip";
    private static final String DIP_UNITS = "Degrees";
    private static final String SITE_REPRESENTATION_PARAM_NAME = "How Representative is this Site";
    private static final String LAT_PARAM_NAME = "Site Latitude";
    private static final String LON_PARAM_NAME = "Site Longitude";
    private static final String ELEVATION_PARAM_NAME = "Site Elevation";
    private static final double DEFAULT_LAT_VAL = 34.0;
    private static final double DEFAULT_LON_VAL = -118.0;
    private static final String TITLE = "Add/Edit Paleo Site";
    private static final String BETWEEN_LOCATIONS_SITE_TYPE = "Between Locations";
    private static final String LAT_LON_UNITS = "Decimal Degrees";
    private static final String ELEVATION_UNITS = "meters";
    private static final int WIDTH = 600;
    private static final int HEIGHT = 700;
    private static final double DIP_MIN = Double.NEGATIVE_INFINITY;
    private static final double DIP_MAX = Double.POSITIVE_INFINITY;
    private static final String MSG_COMMENTS_MISSING = "Please Enter Comments";
    private static final String MSG_REFERENCES_MISSING = "Please choose atleast 1 reference";
    private static final String MSG_INSERT_SUCCESS = "Site added sucessfully to the database";
    private static final String MSG_UPDATE_SUCCESS = "Site updated sucessfully in the database";
    private static final String MSG_DIP_INCORRECT = "Dip Value is incorrect/missing.\n Due to put the site into database anyway?";
    private StringParameter siteNameParam;
    private LocationParameter siteLocationParam;
    private LocationParameter siteLocationParam2;
    private StringParameter assocWithFaultParam;
    private StringListParameter siteTypeParam;
    private StringParameter siteRepresentationParam;
    private StringListParameter siteReferenceParam;
    private StringParameter commentsParam;
    private StringParameter oldSiteIdParam;
    private EstimateParameter dipEstParam;
    private StringParameterEditor siteNameParamEditor;
    private ParameterListParameterEditor siteLocationParamEditor;
    private ParameterListParameterEditor siteLocationParamEditor2;
    private ConstrainedStringParameterEditor assocWithFaultParamEditor;
    private ConstrainedStringListParameterEditor siteTypeParamEditor;
    private ConstrainedStringParameterEditor siteRepresentationParamEditor;
    private ConstrainedStringListParameterEditor siteReferenceParamEditor;
    private CommentsParameterEditor commentsParamEditor;
    private StringParameterEditor oldSiteIdParamEditor;
    private ConstrainedEstimateParameterEditor dipEstParamEditor;
    private JButton addNewSiteButton = new JButton("Add New Site Type");
    private JButton okButton = new JButton("Submit");
    private JButton cancelButton = new JButton("Cancel");
    private JButton addNewReferenceButton = new JButton("Add New Reference");
    private static final String ADD_NEW_REF_TOOL_TIP = "Add Reference not currently in database";
    private SiteTypeDB_DAO siteTypeDAO;
    private ReferenceDB_DAO referenceDAO;
    private SiteRepresentationDB_DAO siteRepresentationDAO;
    private PaleoSiteDB_DAO paleoSiteDAO;
    private FaultSectionVer2_DB_DAO faultSectionDAO;
    private AddNewSiteType addNewSiteType;
    private AddNewReference addNewReference;
    private LabeledBoxPanel labeledBoxPanel;
    private LabeledBoxPanel labeledBoxPanel2;
    private ArrayList referenceList;
    private ArrayList referenceSummaryList;
    private DB_AccessAPI dbConnection;

    public AddEditSiteCharacteristics(DB_AccessAPI dbConnection) {
        this.dbConnection = dbConnection;
        this.siteTypeDAO = new SiteTypeDB_DAO(dbConnection);
        this.referenceDAO = new ReferenceDB_DAO(dbConnection);
        this.siteRepresentationDAO = new SiteRepresentationDB_DAO(dbConnection);
        this.paleoSiteDAO = new PaleoSiteDB_DAO(dbConnection);
        this.faultSectionDAO = new FaultSectionVer2_DB_DAO(dbConnection);
        try {
            this.initParametersAndEditors();
            this.jbInit();
            this.makeSiteTypeParamAndEditor();
            this.setSecondLocationVisible();
            this.makeReferenceParamAndEditor();
            this.setTitle(TITLE);
            this.addActionListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        this.setSize(600, 700);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void addActionListeners() {
        this.addNewSiteButton.addActionListener(this);
        this.addNewReferenceButton.addActionListener(this);
        this.addNewReferenceButton.setToolTipText(ADD_NEW_REF_TOOL_TIP);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addNewSiteButton) {
            this.addNewSiteType = new AddNewSiteType(this.dbConnection);
            this.addNewSiteType.addDbAdditionSuccessListener(this);
        } else if (source == this.addNewReferenceButton) {
            this.addNewReference = new AddNewReference(this.dbConnection);
            this.addNewReference.addDbAdditionSuccessListener(this);
        } else if (source == this.okButton) {
            this.putSiteInDatabase();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void putSiteInDatabase() {
        PaleoSite paleoSite;
        block8: {
            paleoSite = new PaleoSite();
            paleoSite.setSiteName((String)this.siteNameParam.getValue());
            String comments = (String)this.commentsParam.getValue();
            if (comments == null || comments.trim().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, MSG_COMMENTS_MISSING);
                return;
            }
            paleoSite.setGeneralComments(comments);
            paleoSite.setOldSiteId((String)this.oldSiteIdParam.getValue());
            FaultSectionSummary faultSectionSummary = FaultSectionSummary.getFaultSectionSummary((String)this.assocWithFaultParam.getValue());
            paleoSite.setFaultSectionNameId(faultSectionSummary.getSectionName(), faultSectionSummary.getSectionId());
            ArrayList siteReferences = (ArrayList)this.siteReferenceParam.getValue();
            if (siteReferences == null || siteReferences.size() == 0) {
                JOptionPane.showMessageDialog(this, MSG_REFERENCES_MISSING);
                return;
            }
            ArrayList<PaleoSitePublication> paleoSitePubList = new ArrayList<PaleoSitePublication>();
            String siteRep = (String)this.siteRepresentationParam.getValue();
            ArrayList siteTypes = (ArrayList)this.siteTypeParam.getValue();
            for (int i = 0; i < siteReferences.size(); ++i) {
                int index = this.referenceSummaryList.indexOf(siteReferences.get(i));
                PaleoSitePublication paleoSitePub = new PaleoSitePublication();
                paleoSitePub.setReference((Reference)this.referenceList.get(index));
                paleoSitePub.setRepresentativeStrandName(siteRep);
                paleoSitePub.setSiteTypeNames(siteTypes);
                paleoSitePubList.add(paleoSitePub);
            }
            paleoSite.setPaleoSitePubList(paleoSitePubList);
            try {
                this.dipEstParamEditor.setEstimateInParameter();
                paleoSite.setDipEstimate(new EstimateInstances((Estimate)this.dipEstParam.getValue(), DIP_UNITS));
            }
            catch (Exception e) {
                int option = JOptionPane.showConfirmDialog(this, MSG_DIP_INCORRECT, TITLE, 0);
                if (option != 1) break block8;
                return;
            }
        }
        Location loc1 = (Location)this.siteLocationParam.getValue();
        paleoSite.setSiteLat1((float)loc1.getLatitude());
        paleoSite.setSiteLon1((float)loc1.getLongitude());
        paleoSite.setSiteElevation1((float)loc1.getDepth());
        float lat2 = Float.NaN;
        float lon2 = Float.NaN;
        float elev2 = Float.NaN;
        ArrayList selectedSiteType = (ArrayList)this.siteTypeParam.getValue();
        if (selectedSiteType.contains(BETWEEN_LOCATIONS_SITE_TYPE)) {
            Location loc2 = (Location)this.siteLocationParam.getValue();
            lat2 = (float)loc2.getLatitude();
            lon2 = (float)loc2.getLongitude();
            elev2 = (float)loc2.getDepth();
        }
        paleoSite.setSiteLat2(lat2);
        paleoSite.setSiteLon2(lon2);
        paleoSite.setSiteElevation2(elev2);
        try {
            ConnectToEmailServlet.sendEmail(SessionInfo.getUserName() + " trying to add new Site Characteristics to database\n" + paleoSite.toString());
            this.paleoSiteDAO.addPaleoSite(paleoSite);
            JOptionPane.showMessageDialog(this, MSG_INSERT_SUCCESS);
            ConnectToEmailServlet.sendEmail("Site Characteristics added successfully for a new site by " + SessionInfo.getUserName());
            this.sendEventToListeners(paleoSite);
            this.dispose();
        }
        catch (InsertException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void makeSiteTypeParamAndEditor() {
        if (this.siteTypeParamEditor != null) {
            this.labeledBoxPanel.remove(this.siteTypeParamEditor);
        }
        ArrayList siteTypes = this.getSiteTypes();
        ArrayList defaultSiteType = new ArrayList();
        defaultSiteType.add(siteTypes.get(0));
        this.siteTypeParam = new StringListParameter(SITE_TYPE_PARAM_NAME, siteTypes, defaultSiteType);
        this.siteTypeParamEditor = new ConstrainedStringListParameterEditor(this.siteTypeParam);
        this.siteTypeParam.addParameterChangeListener(this);
        this.labeledBoxPanel.add((Component)this.siteTypeParamEditor, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void makeReferenceParamAndEditor() {
        if (this.siteReferenceParamEditor != null) {
            this.labeledBoxPanel.remove(this.siteReferenceParamEditor);
        }
        ArrayList referencesList = this.getAvailableReferences();
        ArrayList dafaultReference = new ArrayList();
        this.siteReferenceParam = new StringListParameter(CHOOSE_REFERENCE_PARAM_NAME, referencesList, dafaultReference);
        this.siteReferenceParamEditor = new ConstrainedStringListParameterEditor(this.siteReferenceParam);
        this.labeledBoxPanel2.add((Component)this.siteReferenceParamEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void jbInit() {
        this.labeledBoxPanel = new LabeledBoxPanel(GUI_Utils.gridBagLayout);
        this.labeledBoxPanel.setTitle(TITLE);
        this.labeledBoxPanel2 = new LabeledBoxPanel(GUI_Utils.gridBagLayout);
        this.labeledBoxPanel2.setTitle(TITLE);
        int yPos = 0;
        this.labeledBoxPanel.add((Component)this.siteNameParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel.add((Component)this.oldSiteIdParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel.add((Component)this.siteLocationParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel.add((Component)this.assocWithFaultParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel.add((Component)this.addNewSiteButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel.add((Component)this.siteLocationParamEditor2, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        yPos = 0;
        this.labeledBoxPanel2.add((Component)this.dipEstParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel2.add((Component)this.siteRepresentationParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel2.add((Component)this.commentsParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        int n = ++yPos;
        this.labeledBoxPanel2.add((Component)this.addNewReferenceButton, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel2.add((Component)this.okButton, new GridBagConstraints(0, ++yPos, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.labeledBoxPanel2.add((Component)this.cancelButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(GUI_Utils.gridBagLayout);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.add((Component)this.labeledBoxPanel, "left");
        splitPane.add((Component)this.labeledBoxPanel2, "right");
        splitPane.setDividerLocation(300);
        contentPane.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initParametersAndEditors() throws Exception {
        ArrayList faultSectionNamesList = this.getFaultSectionNames();
        ArrayList siteRepresentations = this.getSiteRepresentations();
        Estimate dipEstVal = null;
        String defaultSiteName = " ";
        String defaultOldSiteId = " ";
        String defaultFaultSectionName = (String)faultSectionNamesList.get(0);
        String defaultSiteRepresentation = (String)siteRepresentations.get(0);
        String defaultComments = " ";
        Location defaultLocation1 = new Location(34.0, -118.0);
        Location defaultLocation2 = new Location(34.0, -118.0);
        dipEstVal = null;
        this.siteNameParam = new StringParameter(SITE_NAME_PARAM_NAME, defaultSiteName);
        this.siteNameParamEditor = new StringParameterEditor((Parameter)this.siteNameParam);
        this.oldSiteIdParam = new StringParameter(OLD_SITE_ID_PARAM_NAME, defaultOldSiteId);
        this.oldSiteIdParamEditor = new StringParameterEditor((Parameter)this.oldSiteIdParam);
        this.siteLocationParam = this.createLocationParam(defaultLocation1);
        this.siteLocationParamEditor = (ParameterListParameterEditor)this.siteLocationParam.getEditor();
        this.siteLocationParam2 = this.createLocationParam(defaultLocation2);
        this.siteLocationParamEditor2 = (ParameterListParameterEditor)this.siteLocationParam2.getEditor();
        this.assocWithFaultParam = new StringParameter(ASSOCIATED_WITH_FAULT_PARAM_NAME, faultSectionNamesList, defaultFaultSectionName);
        this.assocWithFaultParamEditor = new ConstrainedStringParameterEditor(this.assocWithFaultParam);
        this.siteRepresentationParam = new StringParameter(SITE_REPRESENTATION_PARAM_NAME, siteRepresentations, defaultSiteRepresentation);
        this.siteRepresentationParamEditor = new ConstrainedStringParameterEditor(this.siteRepresentationParam);
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        EstimateConstraint estConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        this.dipEstParam = new EstimateParameter(DIP_PARAM_NAME, estConstraint, DIP_UNITS, dipEstVal);
        this.dipEstParamEditor = new ConstrainedEstimateParameterEditor(this.dipEstParam, true);
        this.commentsParam = new StringParameter(COMMENTS_PARAM_NAME, defaultComments);
        this.commentsParamEditor = new CommentsParameterEditor(this.commentsParam);
    }

    private LocationParameter createLocationParam(Location loc) throws InvalidRangeException, ParameterException, ConstraintException {
        Location siteLoc = new Location(loc.getLatitude(), loc.getLongitude());
        return new LocationParameter(SITE_LOCATION_PARAM_NAME, siteLoc);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equalsIgnoreCase(SITE_TYPE_PARAM_NAME)) {
            this.setSecondLocationVisible();
        }
    }

    private void setSecondLocationVisible() {
        ArrayList selectedSiteType = (ArrayList)this.siteTypeParam.getValue();
        if (selectedSiteType.contains(BETWEEN_LOCATIONS_SITE_TYPE)) {
            this.siteLocationParamEditor2.setVisible(true);
        } else {
            this.siteLocationParamEditor2.setVisible(false);
        }
    }

    private ArrayList getSiteRepresentations() {
        ArrayList<SiteRepresentation> siteRepresentationVOs = this.siteRepresentationDAO.getAllSiteRepresentations();
        ArrayList<String> siteRepresentations = new ArrayList<String>();
        for (int i = 0; i < siteRepresentationVOs.size(); ++i) {
            siteRepresentations.add(siteRepresentationVOs.get(i).getSiteRepresentationName());
        }
        return siteRepresentations;
    }

    private ArrayList getAvailableReferences() {
        this.referenceList = this.referenceDAO.getAllReferencesSummary();
        this.referenceSummaryList = new ArrayList();
        for (int i = 0; this.referenceList != null && i < this.referenceList.size(); ++i) {
            this.referenceSummaryList.add(((Reference)this.referenceList.get(i)).getSummary());
        }
        return this.referenceSummaryList;
    }

    private ArrayList getFaultSectionNames() {
        ArrayList<FaultSectionSummary> faultSectionSummaryList = this.faultSectionDAO.getAllFaultSectionsSummary();
        ArrayList<String> faultSectionNamesList = new ArrayList<String>();
        for (int i = 0; i < faultSectionSummaryList.size(); ++i) {
            faultSectionNamesList.add(faultSectionSummaryList.get(i).getAsString());
        }
        return faultSectionNamesList;
    }

    private ArrayList getSiteTypes() {
        ArrayList<SiteType> siteTypeVOs = this.siteTypeDAO.getAllSiteTypes();
        ArrayList<String> siteTypesList = new ArrayList<String>();
        for (int i = 0; i < siteTypeVOs.size(); ++i) {
            siteTypesList.add(siteTypeVOs.get(i).getSiteType());
        }
        return siteTypesList;
    }

    @Override
    public void dbAdditionSuccessful(DbAdditionSuccessEvent event) {
        Object source = event.getSource();
        if (source == this.addNewSiteType) {
            this.makeSiteTypeParamAndEditor();
        } else if (source == this.addNewReference) {
            this.makeReferenceParamAndEditor();
        }
        this.labeledBoxPanel.updateUI();
    }
}

