/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.MeasuredCompPanel;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.SenseOfMotionPanel;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class AddEditSlipRate
extends LabeledBoxPanel
implements ParameterChangeListener {
    private static final String ASEISMIC_AVAILABLE_PARAM_NAME = "Asiesmic Slip Factor";
    private static final String KNOWN = "Known";
    private static final String UNKNOWN = "Unknown";
    private static final String SLIP_RATE_PARAM_NAME = "Slip Rate Estimate";
    private static final String SLIP_RATE = "Slip Rate";
    private static final String SLIP_RATE_COMMENTS_PARAM_NAME = "Slip Rate Comments";
    private static final String SLIP_RATE_REFERENCES_PARAM_NAME = "Choose References";
    public static final String SLIP_RATE_UNITS = "mm/yr";
    private static final double SLIP_RATE_MIN = 0.0;
    private static final double SLIP_RATE_MAX = Double.POSITIVE_INFINITY;
    private static final String ASEISMIC_SLIP_FACTOR_PARAM_NAME = "Aseismic Slip Factor Estimate(0-1, 1=all aseismic)";
    private static final String ASEISMIC_SLIP_FACTOR = "Aseismic Slip Factor";
    private static final double ASEISMIC_SLIP_FACTOR_MIN = 0.0;
    private static final double ASEISMIC_SLIP_FACTOR_MAX = 1.0;
    public static final String ASEISMIC_SLIP_FACTOR_UNITS = " ";
    private EstimateParameter slipRateEstimateParam;
    private EstimateParameter aSeismicSlipFactorParam;
    private StringParameter slipRateCommentsParam;
    private StringParameter aseismicAvailableParam;
    private ConstrainedEstimateParameterEditor slipRateEstimateParamEditor;
    private ConstrainedEstimateParameterEditor aSeismicSlipFactorParamEditor;
    private ConstrainedStringParameterEditor aseismicAvailableParamEditor;
    private CommentsParameterEditor slipRateCommentsParamEditor;
    private SenseOfMotionPanel senseOfMotionPanel;
    private MeasuredCompPanel measuredCompPanel;
    private static final String SLIP_RATE_PARAMS_TITLE = "Slip Rate Params";

    public AddEditSlipRate() {
        try {
            this.senseOfMotionPanel = new SenseOfMotionPanel();
            this.measuredCompPanel = new MeasuredCompPanel();
            this.setLayout(GUI_Utils.gridBagLayout);
            this.addSlipRateInfoParameters();
            this.setAseismicEditorVisibility();
            this.setMinimumSize(new Dimension(0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddEditSlipRate(CombinedSlipRateInfo combinedSlipRateInfo) {
        this();
        if (combinedSlipRateInfo != null) {
            this.setValuesInParameters(combinedSlipRateInfo);
        }
    }

    private void setValuesInParameters(CombinedSlipRateInfo combinedSlipRateInfo) {
        this.slipRateEstimateParam.setValue(combinedSlipRateInfo.getSlipRateEstimate().getEstimate());
        this.slipRateEstimateParamEditor.refreshParamEditor();
        EstimateInstances aseismicSlipFactor = combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip();
        if (aseismicSlipFactor == null) {
            this.aseismicAvailableParam.setValue(UNKNOWN);
        } else {
            this.aseismicAvailableParam.setValue(KNOWN);
            this.aSeismicSlipFactorParam.setValue(aseismicSlipFactor.getEstimate());
            this.aSeismicSlipFactorParamEditor.refreshParamEditor();
        }
        this.aseismicAvailableParamEditor.refreshParamEditor();
        this.slipRateCommentsParam.setValue(combinedSlipRateInfo.getSlipRateComments());
        this.slipRateCommentsParamEditor.refreshParamEditor();
        this.measuredCompPanel.setMeasuredCompVal(combinedSlipRateInfo.getMeasuredComponentQual());
        EstimateInstances somQuan = combinedSlipRateInfo.getSenseOfMotionRake();
        Estimate rake = null;
        if (somQuan != null) {
            rake = somQuan.getEstimate();
        }
        this.senseOfMotionPanel.setSenseOfMotion(combinedSlipRateInfo.getSenseOfMotionQual(), rake);
    }

    private void addSlipRateInfoParameters() throws Exception {
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.slipRateEstimateParam = new EstimateParameter(SLIP_RATE_PARAM_NAME, SLIP_RATE_UNITS, 0.0, Double.POSITIVE_INFINITY, allowedEstimates);
        this.slipRateEstimateParamEditor = new ConstrainedEstimateParameterEditor(this.slipRateEstimateParam, true);
        ArrayList<String> allowedVals = new ArrayList<String>();
        allowedVals.add(KNOWN);
        allowedVals.add(UNKNOWN);
        this.aseismicAvailableParam = new StringParameter(ASEISMIC_AVAILABLE_PARAM_NAME, allowedVals, (String)allowedVals.get(0));
        this.aseismicAvailableParamEditor = new ConstrainedStringParameterEditor(this.aseismicAvailableParam);
        this.aseismicAvailableParam.addParameterChangeListener(this);
        this.aSeismicSlipFactorParam = new EstimateParameter(ASEISMIC_SLIP_FACTOR_PARAM_NAME, ASEISMIC_SLIP_FACTOR_UNITS, 0.0, 1.0, allowedEstimates);
        this.aSeismicSlipFactorParamEditor = new ConstrainedEstimateParameterEditor(this.aSeismicSlipFactorParam, true);
        this.slipRateCommentsParam = new StringParameter(SLIP_RATE_COMMENTS_PARAM_NAME);
        this.slipRateCommentsParamEditor = new CommentsParameterEditor(this.slipRateCommentsParam);
        int yPos = 0;
        this.add((Component)this.measuredCompPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slipRateEstimateParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.aseismicAvailableParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.aSeismicSlipFactorParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.senseOfMotionPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slipRateCommentsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(SLIP_RATE_PARAMS_TITLE);
    }

    public CombinedSlipRateInfo getCombinedSlipRateInfo() {
        CombinedSlipRateInfo combinedSlipRateInfo = new CombinedSlipRateInfo();
        combinedSlipRateInfo.setSlipRateComments(this.getSlipRateComments());
        combinedSlipRateInfo.setASeismicSlipFactorEstimateForSlip(this.getAseismicEstimate());
        combinedSlipRateInfo.setSlipRateEstimate(this.getSlipRateEstimate());
        combinedSlipRateInfo.setMeasuredComponentQual(this.measuredCompPanel.getMeasuredComp());
        combinedSlipRateInfo.setSenseOfMotionRake(this.senseOfMotionPanel.getSenseOfMotionRake());
        combinedSlipRateInfo.setSenseOfMotionQual(this.senseOfMotionPanel.getSenseOfMotionQual());
        return combinedSlipRateInfo;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equalsIgnoreCase(ASEISMIC_AVAILABLE_PARAM_NAME)) {
            this.setAseismicEditorVisibility();
        }
    }

    private void setAseismicEditorVisibility() {
        String aseismicSlipFactorAvailability = (String)this.aseismicAvailableParam.getValue();
        if (aseismicSlipFactorAvailability.equalsIgnoreCase(KNOWN)) {
            this.aSeismicSlipFactorParamEditor.setVisible(true);
        } else {
            this.aSeismicSlipFactorParamEditor.setVisible(false);
        }
    }

    private EstimateInstances getSlipRateEstimate() {
        this.slipRateEstimateParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.slipRateEstimateParam.getValue(), SLIP_RATE_UNITS);
    }

    private EstimateInstances getAseismicEstimate() {
        String aseismicSlipFactorAvailability = (String)this.aseismicAvailableParam.getValue();
        if (aseismicSlipFactorAvailability.equalsIgnoreCase(UNKNOWN)) {
            return null;
        }
        this.aSeismicSlipFactorParamEditor.setEstimateInParameter();
        return new EstimateInstances((Estimate)this.aSeismicSlipFactorParam.getValue(), ASEISMIC_SLIP_FACTOR_UNITS);
    }

    private String getSlipRateComments() {
        return (String)this.slipRateCommentsParam.getValue();
    }
}

