/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.DBConnectException;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.gui.event.DbAdditionFrame;
import org.opensha.refFaultParamDb.gui.infotools.ConnectToEmailServlet;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.gui.view.ViewAllReferences;
import org.opensha.refFaultParamDb.vo.Reference;

public class AddNewReference
extends DbAdditionFrame
implements ActionListener {
    private static final String AUTHOR_PARAM_NAME = "Short Citation";
    private static final String AUTHOR_PARAM_DEFAULT = "e.g. Knight & Dey";
    private static final String BIBLIO_PARAM_NAME = "Full Bibliographic Ref";
    private static final String BIBLIO_PARAM_DEFAULT = "Enter full citation here";
    private static final String YEAR_PARAM_NAME = "Year";
    private static final String MSG_AUTHOR = "Author is missing";
    private static final String MSG_FULL_BIBLIO = "Full Bibliographic Reference is missing";
    private static final String MSG_YEAR = "Year is missing";
    private StringParameter authorParam;
    private StringParameter biblioParam;
    private StringParameter yearParam;
    private StringParameterEditor authorParameterEditor;
    private CommentsParameterEditor biblioParameterEditor;
    private StringParameterEditor yearParamEditor;
    private static final String NEW_SITE_TYPE_LABEL = "Add Reference";
    private JButton okButton = new JButton("Submit");
    private JButton cancelButton = new JButton("Cancel");
    private JButton viewAllRefsButton = new JButton("View All References");
    private ReferenceDB_DAO referenceDAO;
    private static final String MSG_INSERT_SUCCESS = "Reference added sucessfully to the database";
    private static final String MSG_SINGLE_QUOTES_NOT_ALLOWED = "Single quotes are not allowed for author, year or full bibliographic reference";
    private DB_AccessAPI dbConnection;

    public AddNewReference(DB_AccessAPI dbConnection) {
        this.dbConnection = dbConnection;
        this.referenceDAO = new ReferenceDB_DAO(dbConnection);
        this.initParamsAndEditors();
        this.addEditorsToGUI();
        this.addActionListeners();
        this.setTitle(NEW_SITE_TYPE_LABEL);
        this.pack();
        this.setSize(400, 400);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void addActionListeners() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.viewAllRefsButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            this.addReferenceToDatabase();
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.viewAllRefsButton) {
            new ViewAllReferences(this.dbConnection);
        }
    }

    private void addReferenceToDatabase() {
        String author = (String)this.authorParam.getValue();
        String fullBiblio = (String)this.biblioParam.getValue();
        String year = (String)this.yearParam.getValue();
        if (author == null || author.trim().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_AUTHOR);
            return;
        }
        if (fullBiblio == null || fullBiblio.trim().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_FULL_BIBLIO);
            return;
        }
        if (year == null || year.trim().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_YEAR);
            return;
        }
        if (author.indexOf("'") >= 0 || fullBiblio.indexOf("'") >= 0 || year.indexOf("'") >= 0) {
            JOptionPane.showMessageDialog(this, MSG_SINGLE_QUOTES_NOT_ALLOWED);
            return;
        }
        try {
            Reference reference = new Reference(author, year, fullBiblio);
            ConnectToEmailServlet.sendEmail(SessionInfo.getUserName() + " trying to add new Reference to database\n" + reference.toString());
            this.referenceDAO.addReference(reference);
            this.sendEventToListeners(reference);
            JOptionPane.showMessageDialog(this, MSG_INSERT_SUCCESS);
            ConnectToEmailServlet.sendEmail("New Reference " + fullBiblio + " added sucessfully by " + SessionInfo.getUserName());
            this.dispose();
        }
        catch (InsertException insertException) {
            JOptionPane.showMessageDialog(this, insertException.getMessage());
        }
        catch (DBConnectException connectException) {
            JOptionPane.showMessageDialog(this, connectException.getMessage());
        }
    }

    private void addEditorsToGUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(GUI_Utils.gridBagLayout);
        int yPos = 0;
        contentPane.add((Component)this.authorParameterEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.yearParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.biblioParameterEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.viewAllRefsButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.okButton, new GridBagConstraints(0, yPos, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.cancelButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initParamsAndEditors() {
        this.authorParam = new StringParameter(AUTHOR_PARAM_NAME, AUTHOR_PARAM_DEFAULT);
        this.biblioParam = new StringParameter(BIBLIO_PARAM_NAME, BIBLIO_PARAM_DEFAULT);
        this.yearParam = new StringParameter(YEAR_PARAM_NAME);
        this.authorParameterEditor = null;
        this.biblioParameterEditor = null;
        try {
            this.authorParameterEditor = new StringParameterEditor((Parameter)this.authorParam);
            this.biblioParameterEditor = new CommentsParameterEditor(this.biblioParam);
            this.yearParamEditor = new StringParameterEditor((Parameter)this.yearParam);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

