/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.SiteTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.DBConnectException;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.gui.event.DbAdditionFrame;
import org.opensha.refFaultParamDb.gui.infotools.ConnectToEmailServlet;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.SiteType;

public class AddNewSiteType
extends DbAdditionFrame
implements ActionListener {
    private static final String SITE_TYPE_NAME_PARAM_NAME = "Site Type Name";
    private static final String SITE_TYPE_COMMENTS_PARAM_NAME = "Site Type Comments";
    private static final String SITE_TYPE_NAME_PARAM_DEFAULT = "Enter Name Here";
    private static final String MSG_SITE_TYPE_NAME_MISSING = "Site Type Name is Missing";
    private static final String MSG_SINGLE_QUOTES_NOT_ALLOWED = "Single quotes are not allowed in Site type name";
    private static final String MSG_SITE_TYPE_COMMENTS_MISSING = "Site Type comments are missing";
    private StringParameter siteTypeParam;
    private StringParameter siteTypeCommentsParam;
    private StringParameterEditor siteTypeNameParameterEditor = null;
    private CommentsParameterEditor siteTypeCommentsParamEditor = null;
    private static final String NEW_SITE_TYPE_LABEL = "Add New Site Type";
    private JButton okButton = new JButton("Submit");
    private JButton cancelButton = new JButton("Cancel");
    private static final String MSG_INSERT_SUCCESS = "Site type added sucessfully to the database";
    private SiteTypeDB_DAO siteTypeDAO;

    public AddNewSiteType(DB_AccessAPI dbConnection) {
        this.siteTypeDAO = new SiteTypeDB_DAO(dbConnection);
        this.initParamsAndEditors();
        this.addEditorsToGUI();
        this.addActionListeners();
        this.setTitle(NEW_SITE_TYPE_LABEL);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void addActionListeners() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            this.addNewSiteType();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void addNewSiteType() {
        String siteTypeName = (String)this.siteTypeParam.getValue();
        String siteTypeComments = (String)this.siteTypeCommentsParam.getValue();
        if (siteTypeName.trim().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_SITE_TYPE_NAME_MISSING);
            return;
        }
        if (siteTypeName.trim().indexOf("'") >= 0) {
            JOptionPane.showMessageDialog(this, MSG_SINGLE_QUOTES_NOT_ALLOWED);
            return;
        }
        if (siteTypeComments.trim().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_SITE_TYPE_COMMENTS_MISSING);
            return;
        }
        SiteType siteType = new SiteType(siteTypeName, SessionInfo.getContributor(), siteTypeComments);
        try {
            ConnectToEmailServlet.sendEmail(SessionInfo.getUserName() + " trying to add New SiteType to database\n" + siteType.toString());
            this.siteTypeDAO.addSiteType(siteType);
            JOptionPane.showMessageDialog(this, MSG_INSERT_SUCCESS);
            ConnectToEmailServlet.sendEmail("New SiteType " + siteTypeName + " added sucessfully by " + SessionInfo.getUserName());
            this.sendEventToListeners(siteType);
            this.dispose();
        }
        catch (InsertException insertException) {
            JOptionPane.showMessageDialog(this, insertException.getMessage());
        }
        catch (DBConnectException connectException) {
            JOptionPane.showMessageDialog(this, connectException.getMessage());
        }
    }

    private void addEditorsToGUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(GUI_Utils.gridBagLayout);
        int yPos = 0;
        contentPane.add((Component)this.siteTypeNameParameterEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.siteTypeCommentsParamEditor, new GridBagConstraints(0, yPos++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.okButton, new GridBagConstraints(0, yPos, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.cancelButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initParamsAndEditors() {
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME_PARAM_NAME, SITE_TYPE_NAME_PARAM_DEFAULT);
        this.siteTypeCommentsParam = new StringParameter(SITE_TYPE_COMMENTS_PARAM_NAME);
        try {
            this.siteTypeNameParameterEditor = new StringParameterEditor((Parameter)this.siteTypeParam);
            this.siteTypeCommentsParamEditor = new CommentsParameterEditor(this.siteTypeCommentsParam);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

