/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;

public class MeasuredCompPanel
extends JPanel {
    private static final String MEASURED_COMP_PARAM_NAME = "Measured Component";
    private static final String UNKNOWN = "Unknown";
    private StringParameter measuredCompParam;
    private ConstrainedStringParameterEditor measuredCompParamEditor;

    public MeasuredCompPanel() {
        this.setLayout(GUI_Utils.gridBagLayout);
        this.initParamListAndEditor();
        this.addEditorsToGUI();
    }

    private void initParamListAndEditor() {
        try {
            ArrayList allowedMeasuredComps = this.getAllowedMeasuredComponents();
            this.measuredCompParam = new StringParameter(MEASURED_COMP_PARAM_NAME, allowedMeasuredComps, (String)allowedMeasuredComps.get(0));
            this.measuredCompParamEditor = new ConstrainedStringParameterEditor(this.measuredCompParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMeasuredCompVal(String value) {
        if (value == null) {
            value = UNKNOWN;
        }
        this.measuredCompParam.setValue(value);
        this.measuredCompParamEditor.refreshParamEditor();
    }

    private void addEditorsToGUI() {
        int yPos = 0;
        this.add((Component)this.measuredCompParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ArrayList getAllowedMeasuredComponents() {
        ArrayList<String> measuredComps = new ArrayList<String>();
        measuredComps.add(UNKNOWN);
        measuredComps.add("Total");
        measuredComps.add("Vertical");
        measuredComps.add("Horizontal,Trace-Parallel");
        measuredComps.add("Horizontal,Trace-NORMAL");
        return measuredComps;
    }

    public String getMeasuredComp() {
        String value = (String)this.measuredCompParam.getValue();
        if (value.equalsIgnoreCase(UNKNOWN)) {
            return null;
        }
        return value;
    }
}

