/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class SenseOfMotionPanel
extends JPanel
implements ParameterChangeListener,
ActionListener {
    private static final String SOM_PARAM_NAME = "Sense of Motion";
    private static final String SOM_RAKE_PARAM_NAME = "Rake";
    private static final String QUAL_PARAM_NAME = "Qualitative";
    private static final String QUANTITATIVE = "Quantitative (Rake)";
    private static final String QUALITATIVE = "Qualitative";
    private static final String UNKNOWN = "Unknown";
    private static final String BOTH = "Both";
    private static final double RAKE_MIN = -180.0;
    private static final double RAKE_MAX = 180.0;
    private static final String RAKE_CONVENTION = "We use rake as defined by Aki & Richards, 1980; p.106:\nRake is the angle, in degrees, between the strike and the slip direction, measured contra-clockwise from above.\nRake may take values from [-180,180]:\n- rake is 0 for pure left lateral strike slip;\n- rake is 180 or -180 for pure right lateral strike slip;\n- rake is -90 for pure normal dip slip;\n- rake is 90 for pure reverse dip slip;\n- rake is in range [0 , 90] for reverse sinistral fault;\n- rake is in [90, 180] for reverse dextral faults\n- rake is in [-180, -90] for normal dextral faults\n- rake is in [-90, 0] for normal sinistral fault\n";
    private StringParameter somParam;
    private EstimateParameter somRakeEstParam;
    private StringParameter somQualParam;
    private ConstrainedStringParameterEditor somParamEditor;
    private ConstrainedStringParameterEditor somQualParamEditor;
    private ConstrainedEstimateParameterEditor somRakeEstParamEditor;
    private JButton rakeConventionButton = new JButton("Rake Conventions");

    public SenseOfMotionPanel() {
        this.setLayout(GUI_Utils.gridBagLayout);
        this.initParamListAndEditor();
        this.addEditorsToGUI();
        this.rakeConventionButton.addActionListener(this);
        this.setSOM_RakeParamVisibility();
    }

    public void setSenseOfMotion(String somQual, Estimate somRake) {
        if (somQual == null && somRake != null) {
            this.somParam.setValue(QUANTITATIVE);
            this.somRakeEstParam.setValue(somRake);
            this.somRakeEstParamEditor.refreshParamEditor();
        }
        if (somRake == null && somQual != null) {
            this.somParam.setValue(QUANTITATIVE);
            this.somQualParam.setValue(somQual);
            this.somQualParamEditor.refreshParamEditor();
        } else {
            this.somParam.setValue(UNKNOWN);
        }
        this.somParamEditor.refreshParamEditor();
    }

    private void initParamListAndEditor() {
        try {
            ArrayList allowedSOMs = this.getAllowedSOMs();
            this.somParam = new StringParameter(SOM_PARAM_NAME, allowedSOMs, (String)allowedSOMs.get(0));
            this.somParam.addParameterChangeListener(this);
            this.somParamEditor = new ConstrainedStringParameterEditor(this.somParam);
            ArrayList qualitativeSOMs = this.getAllowedQualitativeSOMs();
            this.somQualParam = new StringParameter("Qualitative", qualitativeSOMs, (String)qualitativeSOMs.get(0));
            this.somQualParamEditor = new ConstrainedStringParameterEditor(this.somQualParam);
            ArrayList allowedEstimates = this.getAllowedEstimatesForRake();
            this.somRakeEstParam = new EstimateParameter(SOM_RAKE_PARAM_NAME, -180.0, 180.0, allowedEstimates);
            this.somRakeEstParamEditor = new ConstrainedEstimateParameterEditor(this.somRakeEstParam, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getAllowedEstimatesForRake() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    private void addEditorsToGUI() {
        int yPos = 0;
        this.add((Component)this.somParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.somQualParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rakeConventionButton, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.somRakeEstParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ArrayList getAllowedQualitativeSOMs() {
        ArrayList<String> somQualList = new ArrayList<String>();
        somQualList.add("R");
        somQualList.add("N");
        somQualList.add("RL");
        somQualList.add("LL");
        somQualList.add("RL-N");
        somQualList.add("LL-N");
        somQualList.add("RL-R");
        somQualList.add("LL-R");
        somQualList.add("N-RL");
        somQualList.add("N-LL");
        somQualList.add("R-RL");
        somQualList.add("R-LL");
        return somQualList;
    }

    private ArrayList getAllowedSOMs() {
        ArrayList<String> somList = new ArrayList<String>();
        somList.add(UNKNOWN);
        somList.add("Qualitative");
        somList.add(QUANTITATIVE);
        somList.add(BOTH);
        return somList;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(SOM_PARAM_NAME)) {
            this.setSOM_RakeParamVisibility();
        }
    }

    private void setSOM_RakeParamVisibility() {
        String value = (String)this.somParam.getValue();
        this.somRakeEstParamEditor.setVisible(false);
        this.somQualParamEditor.setVisible(false);
        this.rakeConventionButton.setVisible(false);
        if (value.equalsIgnoreCase(QUANTITATIVE) || value.equalsIgnoreCase(BOTH)) {
            this.somRakeEstParamEditor.setVisible(true);
            this.rakeConventionButton.setVisible(true);
        }
        if (value.equalsIgnoreCase("Qualitative") || value.equalsIgnoreCase(BOTH)) {
            this.somQualParamEditor.setVisible(true);
        }
    }

    public EstimateInstances getSenseOfMotionRake() {
        String value = (String)this.somParam.getValue();
        if (value.equalsIgnoreCase("Qualitative") || value.equalsIgnoreCase(UNKNOWN)) {
            return null;
        }
        this.somRakeEstParamEditor.setEstimateInParameter();
        Estimate rakeEst = (Estimate)this.somRakeEstParam.getValue();
        return new EstimateInstances(rakeEst, "");
    }

    public String getSenseOfMotionQual() {
        String value = (String)this.somParam.getValue();
        if (value.equalsIgnoreCase(QUANTITATIVE) || value.equalsIgnoreCase(UNKNOWN)) {
            return null;
        }
        return (String)this.somQualParam.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.rakeConventionButton) {
            JOptionPane.showMessageDialog(this, RAKE_CONVENTION);
        }
    }
}

