/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public abstract class AbstractSectionInfoFileWriter
implements Runnable {
    private PrefFaultSectionDataDB_DAO faultSectionPrefDAO;
    private CalcProgressBar progressBar;
    private int totSections;
    private int currSection;

    public AbstractSectionInfoFileWriter(DB_AccessAPI dbConnection) {
        this.faultSectionPrefDAO = new PrefFaultSectionDataDB_DAO(dbConnection);
    }

    public void writeForFaultModel(int[] faultSectionIds, File file) {
        try {
            this.currSection = 0;
            this.totSections = faultSectionIds.length;
            this.progressBar = new CalcProgressBar("Writing to file", "Writing Fault sections");
            this.progressBar.displayProgressBar();
            Thread t = new Thread(this);
            t.start();
            FileWriter fw = new FileWriter(file);
            Object header = this.getFileHeader();
            if (!((String)header).endsWith("\n")) {
                header = (String)header + "\n";
            }
            fw.write((String)header);
            this.currSection = 0;
            while (this.currSection < this.totSections) {
                System.out.println(this.currSection);
                this.writeForFaultModel(faultSectionIds[this.currSection], fw);
                ++this.currSection;
            }
            fw.close();
            this.progressBar.showProgress(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "Error: " + e.getMessage() + "\nSee console output for more details.";
            JOptionPane.showMessageDialog(null, message, "Error Saving File!", 0);
        }
    }

    @Override
    public void run() {
        try {
            while (this.currSection < this.totSections) {
                this.progressBar.updateProgress(this.currSection, this.totSections);
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeForFaultModel(int faultSectionId, FileWriter fw) throws IOException {
        this.writeForFaultModel(this.faultSectionPrefDAO.getFaultSectionPrefData(faultSectionId), fw);
    }

    public void writeForFaultModel(FaultSectionPrefData faultSectionPrefData, FileWriter fw) throws IOException {
        fw.write(this.getFaultAsString(faultSectionPrefData));
    }

    protected String getValue(double val) {
        if (Double.isNaN(val)) {
            return "Not Available";
        }
        return GUI_Utils.decimalFormat.format(val);
    }

    protected String getValue(String val) {
        if (val == null || val.equalsIgnoreCase("")) {
            return "Not Available";
        }
        return val;
    }

    public abstract String getFaultAsString(FaultSectionPrefData var1);

    public abstract String getFileHeader();
}

