/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public class FaultSectionsDistanceCalcGUI
extends JPanel
implements ActionListener {
    private static final double GRID_SPACING = 1.0;
    private FaultSectionVer2_DB_DAO faultSectionDAO;
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO;
    private StringParameter faultSection1Param;
    private StringParameter faultSection2Param;
    private StringParameter faultModelParam;
    private static final String FAULT_SECTION1_PARAM_NAME = "Fault Section 1";
    private static final String FAULT_SECTION2_PARAM_NAME = "Fault Section 2";
    private static final String STIRLING = "Stirling's";
    private static final String FRANKEL = "Frankel's";
    private static final String FAULT_MODEL_PARAM_NAME = "Fault Model Name";
    private ConstrainedStringParameterEditor faultSection1ParamEditor;
    private ConstrainedStringParameterEditor faultSection2ParamEditor;
    private ConstrainedStringParameterEditor faultModelParamEditor;
    private JButton calcButton = new JButton("Calculate Distance");
    private DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public FaultSectionsDistanceCalcGUI(DB_AccessAPI dbConnection) {
        this.faultSectionDAO = new FaultSectionVer2_DB_DAO(dbConnection);
        this.prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbConnection);
        this.makeFaultSectionNamesParamAndEditor();
        this.makeFaultModelParamAndEditor();
        this.calcButton.addActionListener(this);
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        int pos = 0;
        this.add((Component)this.faultSection1ParamEditor, new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.faultSection2ParamEditor, new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.faultModelParamEditor, new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.calcButton, new GridBagConstraints(0, pos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void makeFaultSectionNamesParamAndEditor() {
        ArrayList<FaultSectionSummary> faultSectionsSummaryList = this.faultSectionDAO.getAllFaultSectionsSummary();
        ArrayList<String> faultSectionsList = new ArrayList<String>();
        for (int i = 0; i < faultSectionsSummaryList.size(); ++i) {
            faultSectionsList.add(faultSectionsSummaryList.get(i).getAsString());
        }
        this.faultSection1Param = new StringParameter(FAULT_SECTION1_PARAM_NAME, faultSectionsList, (String)faultSectionsList.get(0));
        this.faultSection1ParamEditor = new ConstrainedStringParameterEditor(this.faultSection1Param);
        this.faultSection2Param = new StringParameter(FAULT_SECTION2_PARAM_NAME, faultSectionsList, (String)faultSectionsList.get(0));
        this.faultSection2ParamEditor = new ConstrainedStringParameterEditor(this.faultSection2Param);
    }

    private void makeFaultModelParamAndEditor() {
        ArrayList<String> faultModels = new ArrayList<String>();
        faultModels.add(FRANKEL);
        faultModels.add(STIRLING);
        this.faultModelParam = new StringParameter(FAULT_MODEL_PARAM_NAME, faultModels, (String)faultModels.get(0));
        this.faultModelParamEditor = new ConstrainedStringParameterEditor(this.faultModelParam);
    }

    private void calculateDistances() {
        FaultSectionSummary faultSection1Summary = FaultSectionSummary.getFaultSectionSummary((String)this.faultSection1Param.getValue());
        FaultSectionPrefData faultSection1PrefData = this.prefFaultSectionDAO.getFaultSectionPrefData(faultSection1Summary.getSectionId());
        FaultSectionSummary faultSection2Summary = FaultSectionSummary.getFaultSectionSummary((String)this.faultSection2Param.getValue());
        FaultSectionPrefData faultSection2PrefData = this.prefFaultSectionDAO.getFaultSectionPrefData(faultSection2Summary.getSectionId());
        FaultTrace faultTrace1 = faultSection1PrefData.getFaultTrace();
        FaultTrace faultTrace2 = faultSection2PrefData.getFaultTrace();
        AbstractEvenlyGriddedSurfaceWithSubsets surface1 = this.getEvenlyGriddedSurface(faultSection1PrefData);
        AbstractEvenlyGriddedSurfaceWithSubsets surface2 = this.getEvenlyGriddedSurface(faultSection2PrefData);
        JOptionPane.showMessageDialog(this, "Minimum Fault Trace distance=" + this.DECIMAL_FORMAT.format(faultTrace1.getMinDistance(faultTrace2, 1.0)) + " km\nMinimum 3D distance=" + this.DECIMAL_FORMAT.format(surface1.getMinDistance(surface2)) + " km");
    }

    private AbstractEvenlyGriddedSurfaceWithSubsets getEvenlyGriddedSurface(FaultSectionPrefData faultSectionPrefData) {
        SimpleFaultData simpleFaultData = faultSectionPrefData.getSimpleFaultData(false);
        String selectedFaultModel = (String)this.faultModelParam.getValue();
        if (selectedFaultModel.equalsIgnoreCase(FRANKEL)) {
            return new FrankelGriddedSurface(simpleFaultData, 1.0);
        }
        return new StirlingGriddedSurface(simpleFaultData, 1.0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.calcButton) {
            this.calculateDistances();
        }
    }

    public static void main(String[] args) {
        PrefFaultSectionDataDB_DAO prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_ConnectionPool.getLatestReadWriteConn());
        ArrayList<FaultSectionPrefData> prefFaultSectionsList = prefFaultSectionDAO.getAllFaultSectionPrefData();
        ArrayList<StirlingGriddedSurface> surfaceList = new ArrayList<StirlingGriddedSurface>();
        for (int i = 0; i < prefFaultSectionsList.size(); ++i) {
            SimpleFaultData simpleFaultData = prefFaultSectionsList.get(i).getSimpleFaultData(false);
            surfaceList.add(new StirlingGriddedSurface(simpleFaultData, 1.0));
        }
        try {
            FileWriter fw = new FileWriter("FaultSectionDist.txt");
            for (int i = 0; i < surfaceList.size(); ++i) {
                for (int j = i + 1; j < surfaceList.size(); ++j) {
                    fw.write(prefFaultSectionsList.get(i).getSectionName() + ";" + prefFaultSectionsList.get(j).getSectionName() + ";" + ((AbstractEvenlyGriddedSurfaceWithSubsets)surfaceList.get(i)).getMinDistance((RuptureSurface)surfaceList.get(j)) + "\n");
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

