/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class ViewSlipRate
extends LabeledBoxPanel {
    private static final String SLIP_RATE_TITLE = "Slip Rate";
    private static final String SLIP_RATE_PANEL_TITLE = "Slip Rate Estimate(mm/yr)";
    private static final String ASEISMIC_PANEL_TITLE = "Aseismic Slip Factor(0-1, 1=all aseismic)";
    private static final String MEASURED_COMP_SLIP_TITLE = "Measured Component of Slip";
    private static final String SENSE_OF_MOTION_TITLE = "Sense of Motion";
    private static final String SLIP_RATE = "Slip Rate";
    private static final String ASEISMIC_SLIP_FACTOR = "Aseismic Slip Factor";
    private static final String PROB = "Prob this is correct value";
    private static final String RAKE = "Rake";
    private static final String QUALITATIVE = "Qualitative";
    private InfoLabel slipRateEstimateLabel = new InfoLabel();
    private InfoLabel aSesimicSlipFactorLabel = new InfoLabel();
    private InfoLabel senseOfMotionRakeLabel = new InfoLabel();
    private InfoLabel senseOfMotionQualLabel = new InfoLabel();
    private InfoLabel measuredCompQualLabel = new InfoLabel();
    private StringParameter commentsParam = new StringParameter("Slip Rate Comments");
    private CommentsParameterEditor commentsParameterEditor;

    public ViewSlipRate() {
        super(GUI_Utils.gridBagLayout);
        try {
            this.viewSlipRateForTimePeriod();
            this.setTitle("Slip Rate");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInfo(CombinedSlipRateInfo combinedSlipRateInfo) {
        if (combinedSlipRateInfo == null) {
            this.setInfo(null, null, null, null, null, null);
        } else {
            EstimateInstances aseismicSlipEstInstance = combinedSlipRateInfo.getASeismicSlipFactorEstimateForSlip();
            Estimate aseismicSlipEst = null;
            if (aseismicSlipEstInstance != null) {
                aseismicSlipEst = aseismicSlipEstInstance.getEstimate();
            }
            this.setInfo(combinedSlipRateInfo.getSlipRateEstimate().getEstimate(), aseismicSlipEst, combinedSlipRateInfo.getSlipRateComments(), combinedSlipRateInfo.getSenseOfMotionRake(), combinedSlipRateInfo.getSenseOfMotionQual(), combinedSlipRateInfo.getMeasuredComponentQual());
        }
    }

    private void setInfo(Estimate slipRateEstimate, Estimate aSeismicSlipFactorEstimate, String comments, EstimateInstances rakeForSenseOfMotion, String senseOfMotionQual, String measuredSlipQual) {
        this.slipRateEstimateLabel.setTextAsHTML(slipRateEstimate, "Slip Rate", PROB);
        this.aSesimicSlipFactorLabel.setTextAsHTML(aSeismicSlipFactorEstimate, ASEISMIC_SLIP_FACTOR, PROB);
        this.commentsParam.setValue(comments);
        this.commentsParameterEditor.refreshParamEditor();
        this.measuredCompQualLabel.setTextAsHTML(QUALITATIVE, measuredSlipQual);
        Estimate rakeEst = null;
        if (rakeForSenseOfMotion != null) {
            rakeEst = rakeForSenseOfMotion.getEstimate();
        }
        this.senseOfMotionRakeLabel.setTextAsHTML(rakeEst, RAKE, PROB);
        this.senseOfMotionQualLabel.setTextAsHTML(QUALITATIVE, senseOfMotionQual);
    }

    private void viewSlipRateForTimePeriod() throws Exception {
        JPanel slipRateEstimatePanel = GUI_Utils.getPanel(this.slipRateEstimateLabel, SLIP_RATE_PANEL_TITLE);
        JPanel aseismicPanel = GUI_Utils.getPanel(this.aSesimicSlipFactorLabel, ASEISMIC_PANEL_TITLE);
        JPanel senseOfMotionPanel = GUI_Utils.getPanel(SENSE_OF_MOTION_TITLE);
        JPanel measuredSlipCompPanel = GUI_Utils.getPanel(MEASURED_COMP_SLIP_TITLE);
        this.commentsParameterEditor = new CommentsParameterEditor(this.commentsParam);
        this.commentsParameterEditor.setEnabled(false);
        senseOfMotionPanel.add((Component)this.senseOfMotionRakeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        senseOfMotionPanel.add((Component)this.senseOfMotionQualLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        measuredSlipCompPanel.add((Component)this.measuredCompQualLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int yPos = 0;
        this.add((Component)slipRateEstimatePanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)measuredSlipCompPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)senseOfMotionPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)aseismicPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.commentsParameterEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

