/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.servlets;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.CachedRowSet;
import org.opensha.commons.util.MailUtil;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.exception.DBConnectException;

public class DB_AccessServlet
extends HttpServlet {
    private static ArrayList<String> allowedGuestOperations = new ArrayList();
    private MailUtil.MailProps props = null;
    private static final String CONNECT_FAILURE_MSG = "Connection to the database server failed.\nCheck username/password or try again later";
    private static final String PROP_NAME = "DbConnectionPropertiesFileName";
    private DB_AccessAPI myBroker;
    private ContributorDB_DAO contributorDAO;
    private PrefFaultSectionDataDB_DAO prefDataDAO;

    public void init() throws ServletException {
        try {
            Properties p = new Properties();
            String fileName = this.getInitParameter(PROP_NAME);
            p.load(new FileInputStream(fileName));
            String dbDriver = (String)p.get("dbDriver");
            String dbServer = (String)p.get("dbServer");
            int minConns = Integer.parseInt((String)p.get("minConns"));
            int maxConns = Integer.parseInt((String)p.get("maxConns"));
            String logFileString = (String)p.get("logFileString");
            double maxConnTime = Double.valueOf((String)p.get("maxConnTime"));
            String usrName = (String)p.get("userName");
            String password = (String)p.get("password");
            this.myBroker = new DB_ConnectionPool(dbDriver, dbServer, usrName, password, minConns, maxConns, logFileString, maxConnTime);
            this.contributorDAO = new ContributorDB_DAO(this.myBroker);
            String emailFileName = this.getInitParameter("EmailConfig");
            this.props = MailUtil.loadMailPropsFromFile(emailFileName);
        }
        catch (FileNotFoundException f) {
            f.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.myBroker == null) {
            this.init();
        }
        ObjectInputStream inputFromApp = new ObjectInputStream((InputStream)request.getInputStream());
        ObjectOutputStream outputToApp = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            boolean valid;
            String user = (String)inputFromApp.readObject();
            String pass = (String)inputFromApp.readObject();
            String functionToPerform = (String)inputFromApp.readObject();
            if (user == null || pass == null || user.isEmpty() || pass.isEmpty()) {
                valid = false;
            } else {
                valid = this.contributorDAO.isContributorValid(user, pass);
                if (!valid) {
                    System.out.println("DB_AccessServlet: attempting to connect with invalid credentials: " + user);
                }
            }
            if (!valid && !allowedGuestOperations.contains(functionToPerform)) {
                inputFromApp.close();
                DBConnectException exception = new DBConnectException(CONNECT_FAILURE_MSG);
                outputToApp.writeObject(exception);
                outputToApp.close();
                return;
            }
            Object query = inputFromApp.readObject();
            if (functionToPerform.equals("get sequence number")) {
                int seqNo = this.myBroker.getNextSequenceNumber((String)query);
                outputToApp.writeObject(seqNo);
            } else if (functionToPerform.equals("insert/update/delete query")) {
                if (query instanceof ArrayList) {
                    ArrayList sqls = (ArrayList)query;
                    Boolean rollbackOnFail = (Boolean)inputFromApp.readObject();
                    int[] ret = this.myBroker.insertUpdateOrDeleteBatch(sqls, rollbackOnFail);
                    outputToApp.writeObject(ret);
                } else {
                    int key = this.myBroker.insertUpdateOrDeleteData((String)query);
                    outputToApp.writeObject(key);
                }
            } else if (functionToPerform.equals("insert/update spatial")) {
                ArrayList geomteryObjectList = (ArrayList)inputFromApp.readObject();
                int key = this.myBroker.insertUpdateOrDeleteData((String)query, geomteryObjectList);
                outputToApp.writeObject(key);
            } else if (functionToPerform.equals("select query")) {
                CachedRowSet resultSet = this.myBroker.queryData((String)query);
                outputToApp.writeObject(resultSet);
            } else if (functionToPerform.equals("select query spatial")) {
                String sqlWithNoSaptialColumnNames = (String)inputFromApp.readObject();
                ArrayList geomteryObjectList = (ArrayList)inputFromApp.readObject();
                SpatialQueryResult resultSet = this.myBroker.queryData((String)query, sqlWithNoSaptialColumnNames, geomteryObjectList);
                outputToApp.writeObject(resultSet);
            } else if (functionToPerform.equalsIgnoreCase("reset password")) {
                String email = (String)query;
                String randomPass = ContributorDB_DAO.getRandomPassword();
                String encr = ContributorDB_DAO.getEnryptedPassword(randomPass);
                System.out.println("New random encr pw: " + encr);
                query = "update Contributors set Password= '" + encr + "' where Email='" + email + "'";
                int key = this.myBroker.insertUpdateOrDeleteData((String)query);
                this.props.setEmailTo(email);
                this.props.setEmailSubject("Login information in CA Ref Fault Param GUI");
                String userName = this.contributorDAO.getContributorByEmail(email).getName();
                String emailMessage = "Account info - \nuser name: " + userName + "\nPassword: " + randomPass + "\n";
                if (key > 0) {
                    MailUtil.sendMail(this.props, emailMessage);
                }
                outputToApp.writeObject(key);
            } else if (functionToPerform.equalsIgnoreCase("Update Pref Data")) {
                if (this.prefDataDAO == null) {
                    this.prefDataDAO = new PrefFaultSectionDataDB_DAO(this.myBroker);
                }
                this.prefDataDAO.rePopulatePrefDataTable();
                outputToApp.writeObject(true);
            }
            inputFromApp.close();
            outputToApp.close();
        }
        catch (SQLException e) {
            outputToApp.writeObject(e);
            outputToApp.close();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    static {
        allowedGuestOperations.add("reset password");
        allowedGuestOperations.add("select query");
        allowedGuestOperations.add("select query spatial");
    }
}

