/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.vo;

import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.vo.FaultSectionConnection;

public class FaultSectionConnectionList
extends ArrayList<FaultSectionConnection> {
    private static final long serialVersionUID = 1L;

    public FaultSectionConnectionList getConnectionsForSection(int id) {
        FaultSectionConnectionList conns = new FaultSectionConnectionList();
        for (FaultSectionConnection conn : this) {
            if (!conn.involvesSection(id)) continue;
            conns.add(conn);
        }
        return conns;
    }

    public FaultSectionConnectionList getConnectionsForSections(Collection<Integer> ids) {
        FaultSectionConnectionList conns = new FaultSectionConnectionList();
        for (FaultSectionConnection conn : this) {
            if (!ids.contains(conn.getId1()) || !ids.contains(conn.getId2())) continue;
            conns.add(conn);
        }
        return conns;
    }

    public FaultSectionConnectionList getConnectionsForLocation(int id, Location loc) {
        FaultSectionConnectionList conns = new FaultSectionConnectionList();
        for (FaultSectionConnection conn : this) {
            if (!conn.involvesSectionAtLocation(id, loc)) continue;
            conns.add(conn);
        }
        return conns;
    }

    public int countConnectionsForLocation(int id, Location loc) {
        int cnt = 0;
        for (FaultSectionConnection conn : this) {
            if (!conn.involvesSectionAtLocation(id, loc)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean containsConnectionBetween(int id1, int id2) {
        for (FaultSectionConnection conn : this) {
            if (!conn.involvesSection(id1) || !conn.involvesSection(id2)) continue;
            return true;
        }
        return false;
    }
}

