/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.SiteFileLoader;

public class SiteFileWriter {
    private final boolean lonFirst;
    private final ArrayList<String> siteDataTypes;
    private static final String SEP = " ";

    public SiteFileWriter(boolean lonFirst, ArrayList<String> siteDataTypes) {
        this.lonFirst = lonFirst;
        this.siteDataTypes = siteDataTypes;
    }

    public void writeFile(ArrayList<Location> locs, ArrayList<ParameterList> siteDataParams, File file) throws IOException {
        if (locs.size() != siteDataParams.size()) {
            throw new RuntimeException("locs.size != siteDataParams.size");
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(SiteFileLoader.COM + SEP);
            if (this.lonFirst) {
                fileWriter.write("Lon Lat");
            } else {
                fileWriter.write("Lat Lon");
            }
            for (String dataType : this.siteDataTypes) {
                String label = dataType;
                if (label.equals("Depth to Vs = 1.0 km/sec")) {
                    label = "Z1.0";
                } else if (label.equals("Depth to Vs = 2.5 km/sec")) {
                    label = "Z2.5";
                }
                if (label.contains(SEP)) {
                    fileWriter.write(" \"" + label + "\"");
                    continue;
                }
                fileWriter.write(SEP + label);
            }
            fileWriter.write("\n");
            for (int i = 0; i < locs.size(); ++i) {
                ArrayList<Object> line = new ArrayList<Object>();
                Location loc = locs.get(i);
                if (this.lonFirst) {
                    line.add(loc.getLongitude());
                    line.add(loc.getLatitude());
                } else {
                    line.add(loc.getLatitude());
                    line.add(loc.getLongitude());
                }
                ParameterList siteData = siteDataParams.get(i);
                for (String siteDataType : this.siteDataTypes) {
                    if (siteDataType.equals("Vs30") && siteData.containsParameter("Vs30")) {
                        line.add(siteData.getValue("Vs30"));
                        continue;
                    }
                    if (siteDataType.equals("Depth to Vs = 2.5 km/sec") && siteData.containsParameter("Depth 2.5 km/sec")) {
                        line.add(siteData.getValue("Depth 2.5 km/sec"));
                        continue;
                    }
                    if (!siteDataType.equals("Depth to Vs = 1.0 km/sec") || !siteData.containsParameter("Depth 1.0 km/sec")) continue;
                    Double val = (Double)siteData.getValue("Depth 1.0 km/sec");
                    if (val != null) {
                        val = val / 1000.0;
                    }
                    line.add(val);
                }
                if (line.size() != this.siteDataTypes.size() + 2) {
                    throw new RuntimeException("Site data values written mismatch requested types");
                }
                fileWriter.write(line.stream().map(String::valueOf).collect(Collectors.joining(SEP)));
                fileWriter.write("\n");
            }
        }
    }
}

