/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.IM_EventSet.gui.IMT_ChooserPanel;
import org.opensha.sha.calc.IM_EventSet.gui.NamesListPanel;
import org.opensha.sha.calc.IM_EventSet.gui.SitesPanel;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class IMR_ChooserPanel
extends NamesListPanel
implements ScalarIMRChangeListener {
    private final IMR_MultiGuiBean imrGuiBean;
    private final IMT_ChooserPanel imtChooser;
    private final SitesPanel sitesPanel;
    private final HashMap<String, ScalarIMR> imrNameMap = new HashMap();
    private List<? extends ScalarIMR> allIMRs;

    public IMR_ChooserPanel(IMT_ChooserPanel imtChooser, SitesPanel sitesPanel) {
        super(null, "Selected IMR(s):");
        imtChooser.setForceDisableAddButton(true);
        this.imtChooser = imtChooser;
        this.sitesPanel = sitesPanel;
        this.buildValidIMRs(List.of("Abrahamson (2000)", "Atkinson and Boore (2002) 140bar", "Atkinson and Boore (2002) 200bar"));
        this.imrGuiBean = new IMR_MultiGuiBean(this.allIMRs);
        this.imrGuiBean.addIMRChangeListener(this);
        JPanel imPanel = new JPanel();
        imPanel.setLayout(new BoxLayout(imPanel, 1));
        imPanel.add(this.imrGuiBean);
        this.updateSiteParams();
        this.setLowerPanel(imPanel);
        this.updateIMTs();
    }

    private void buildValidIMRs() {
        this.buildValidIMRs(null);
    }

    private void buildValidIMRs(List<String> excluded) {
        this.allIMRs = AttenRelRef.instanceList(null, true, ServerPrefUtils.SERVER_PREFS);
        if (excluded != null && !excluded.isEmpty()) {
            this.allIMRs.removeIf(imr -> excluded.contains(imr.getName()));
        }
        for (ScalarIMR scalarIMR : this.allIMRs) {
            scalarIMR.setParamDefaults();
            this.imrNameMap.put(scalarIMR.getName(), scalarIMR);
        }
    }

    public void updateSiteParams() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        this.updateSiteParams(imr);
    }

    private void updateSiteParams(ScalarIMR imr) {
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        ParameterList list = new ParameterList();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            list.addParameter(param);
        }
        this.validate();
    }

    private boolean shouldEnableAddButton(ScalarIMR imr) {
        ListModel model = this.namesList.getModel();
        boolean match = false;
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).toString().equals(imr.getName())) continue;
            match = true;
            break;
        }
        return !match;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 600);
        ArrayList params = new ArrayList();
        params.add(new WillsMap2000());
        OrderedSiteDataProviderList providers = new OrderedSiteDataProviderList(params);
        SitesPanel sites = new SitesPanel(new OrderedSiteDataGUIBean(providers));
        frame.setContentPane(new IMR_ChooserPanel(new IMT_ChooserPanel(), sites));
        frame.setVisible(true);
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        HashMap<TectonicRegionType, ScalarIMR> imrMap = event.getNewIMRs();
        ScalarIMR imr = TRTUtils.getFirstIMR(imrMap);
        this.addButton.setEnabled(this.shouldEnableAddButton(imr));
        this.updateSiteParams();
    }

    @Override
    public void addButton_actionPerformed() {
        ListModel model = this.namesList.getModel();
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        String[] names = new String[model.getSize() + 1];
        for (int i = 0; i < model.getSize(); ++i) {
            names[i] = (String)model.getElementAt(i);
        }
        names[names.length - 1] = imr.getName();
        this.namesList.setListData(names);
        this.addButton.setEnabled(false);
        List<String> removedIMTs = this.imtChooser.getIMTsRemoveFor(this.getSelectedIMRs());
        int confirmation = 0;
        if (!removedIMTs.isEmpty()) {
            confirmation = JOptionPane.showConfirmDialog(null, "Are you sure you want to select IMR: " + imr.getName() + "?\nThis will result in the deselection of IMT" + (removedIMTs.size() > 1 ? "s: \n" : ": ") + String.join((CharSequence)", ", removedIMTs), "Confirm IMR Selection", 0);
        }
        if (confirmation == 0) {
            this.updateIMTs();
            this.sitesPanel.updateSiteDataParams(this.getSelectedIMRs());
        } else {
            this.namesList.setListData(Arrays.copyOf(names, names.length - 1));
        }
    }

    @Override
    public void removeButton_actionPerformed() {
        int confirmation;
        ListModel model = this.namesList.getModel();
        if (model.getSize() == 1 && !this.imtChooser.getIMTStrings().isEmpty() && (confirmation = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove the only selected IMR?\nThis will result in the removal of your selected IMTs.", "Confirm IMR Deselection", 0)) != 0) {
            return;
        }
        String[] names = new String[model.getSize() - 1];
        int selected = this.namesList.getSelectedIndex();
        int cnt = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            if (selected == i) continue;
            names[cnt] = (String)model.getElementAt(i);
            ++cnt;
        }
        this.namesList.setListData(names);
        this.updateIMTs();
        this.sitesPanel.updateSiteDataParams(this.getSelectedIMRs());
    }

    public ArrayList<ScalarIMR> getSelectedIMRs() {
        ListModel model = this.namesList.getModel();
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        for (int i = 0; i < model.getSize(); ++i) {
            String name = (String)model.getElementAt(i);
            imrs.add(this.imrNameMap.get(name));
        }
        return imrs;
    }

    private void updateIMTs() {
        ArrayList imrs = this.getSelectedIMRs();
        if (imrs.isEmpty()) {
            imrs = (ArrayList)this.allIMRs;
        }
        this.imtChooser.setIMRs(imrs);
    }

    @Override
    public boolean shouldEnableAddButton() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        return this.shouldEnableAddButton(imr);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.namesList.getSelectedIndex();
        if (index >= 0) {
            String name = (String)this.namesList.getSelectedValue();
            this.imrGuiBean.setSelectedSingleIMR(name);
        }
        super.valueChanged(e);
    }
}

