/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class NamesListPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JList<String> namesList;
    protected JButton addButton = new JButton("Add");
    protected JButton removeButton = new JButton("Remove");

    public NamesListPanel(JPanel upperPanel, String label) {
        super(new BorderLayout());
        this.namesList = new JList();
        this.namesList.setSelectionMode(0);
        this.namesList.setSelectedIndex(0);
        this.namesList.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.namesList);
        listScroller.setPreferredSize(new Dimension(250, 150));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JLabel(label), "North");
        listPanel.add((Component)listScroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        listPanel.add((Component)buttonPanel, "South");
        if (upperPanel != null) {
            upperPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.add((Component)upperPanel, "North");
            this.validate();
            this.add((Component)listPanel, "Center");
        } else {
            this.add((Component)listPanel, "North");
        }
    }

    public NamesListPanel(String label) {
        this(null, label);
    }

    public void setLowerPanel(JPanel lowerPanel) {
        this.add((Component)lowerPanel, "Center");
        this.validate();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.removeButton.setEnabled(this.shouldEnableRemoveButton());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addButton_actionPerformed();
            this.addButton.setEnabled(this.shouldEnableAddButton());
        } else if (e.getSource() == this.removeButton) {
            this.removeButton_actionPerformed();
            this.removeButton.setEnabled(this.shouldEnableRemoveButton());
            this.addButton.setEnabled(this.shouldEnableAddButton());
        }
    }

    public abstract void addButton_actionPerformed();

    public abstract void removeButton_actionPerformed();

    public abstract boolean shouldEnableAddButton();

    public boolean shouldEnableRemoveButton() {
        return !this.namesList.isSelectionEmpty();
    }
}

