/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.SiteFileLoader;
import org.opensha.sha.calc.IM_EventSet.SiteFileWriter;

public class SiteExporterPanel
extends JPanel
implements ActionListener {
    private final JLabel formatLabel = new JLabel();
    private final JButton reverseButton = new JButton("Swap lat/lon");
    private final JButton addButton = new JButton("Add Site Data Column");
    private final JButton removeButton = new JButton("Remove Site Data Column");
    private final JComboBox<String> typeChooser;
    private final JTextField fileField = new JTextField();
    private final JButton browseButton = new JButton("Browse");
    protected JFileChooser chooser;
    private boolean lonFirst = true;
    private final ArrayList<String> siteDataTypes = new ArrayList();
    protected ArrayList<Location> locs;
    protected ArrayList<ParameterList> siteDataParams;
    private static final File cwd = new File(System.getProperty("user.dir"));

    public SiteExporterPanel(ArrayList<Location> locs, ArrayList<ParameterList> siteDataParams) {
        this.setLayout(new BoxLayout(this, 1));
        this.locs = locs;
        this.siteDataParams = siteDataParams;
        this.typeChooser = new JComboBox<String>(SiteFileLoader.allSiteDataTypes);
        this.chooser = new JFileChooser(cwd);
        this.updateLabel();
        this.reverseButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.reverseButton, "West");
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        rightButtonPanel.add(this.typeChooser);
        rightButtonPanel.add(this.addButton);
        rightButtonPanel.add(this.removeButton);
        buttonPanel.add((Component)rightButtonPanel, "East");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(this.formatLabel);
        this.add(labelPanel);
        JPanel newButtonPanel = new JPanel();
        newButtonPanel.add(buttonPanel);
        this.add(newButtonPanel);
        this.add(new JSeparator(0));
        JPanel browsePanel = new JPanel(new BorderLayout());
        browsePanel.add((Component)this.fileField, "Center");
        browsePanel.add((Component)this.browseButton, "East");
        this.fileField.setColumns(40);
        this.browseButton.addActionListener(this);
        JPanel newBrowsePanel = new JPanel();
        newBrowsePanel.add(browsePanel);
        this.add(newBrowsePanel);
        this.setSize(700, 150);
    }

    public void updateSiteData(ArrayList<Location> locs, ArrayList<ParameterList> siteDataParams) {
        this.locs = locs;
        this.siteDataParams = siteDataParams;
    }

    public void exportFile() throws IOException {
        SiteFileWriter writer = new SiteFileWriter(this.lonFirst, this.siteDataTypes);
        writer.writeFile(this.locs, this.siteDataParams, this.getSelectedFile());
    }

    private void updateLabel() {
        StringBuilder label = new StringBuilder("File format: ");
        if (this.lonFirst) {
            label.append("<Longitude> <Latitude>");
        } else {
            label.append("<Latitude> <Longitude>");
        }
        for (String dataType : this.siteDataTypes) {
            label.append(" <").append(dataType).append(">");
        }
        this.formatLabel.setText(label.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        if (e.getSource().equals(this.reverseButton)) {
            this.lonFirst = !this.lonFirst;
        } else if (e.getSource().equals(this.addButton)) {
            int selected = this.typeChooser.getSelectedIndex();
            this.siteDataTypes.add((String)this.typeChooser.getSelectedItem());
            this.typeChooser.removeItemAt(selected);
        } else if (e.getSource().equals(this.removeButton)) {
            int index = this.siteDataTypes.size() - 1;
            this.typeChooser.addItem(this.siteDataTypes.get(index));
            this.siteDataTypes.remove(index);
        } else if (e.getSource().equals(this.browseButton) && (returnVal = this.chooser.showSaveDialog(this)) == 0) {
            File file = this.chooser.getSelectedFile();
            this.fileField.setText(file.getAbsolutePath());
        }
        this.addButton.setEnabled(this.typeChooser.getItemCount() > 0);
        boolean hasTypes = !this.siteDataTypes.isEmpty();
        this.removeButton.setEnabled(hasTypes);
        this.updateLabel();
    }

    public File getSelectedFile() {
        String fileName = this.fileField.getText();
        return new File(fileName);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new SiteExporterPanel(new ArrayList<Location>(), new ArrayList<ParameterList>()));
        frame.setSize(700, 150);
        frame.setVisible(true);
    }
}

