/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.data.DefaultKeyedValues2D;
import org.jfree.chart3d.table.AbstractTableElement;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;
import org.jfree.chart3d.table.TableElementVisitor;

class CustomWidthGridElement<R extends Comparable<R>, C extends Comparable<C>>
extends AbstractTableElement
implements TableElement,
Serializable {
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private DefaultKeyedValues2D<R, C, TableElement> elements = new DefaultKeyedValues2D();

    public CustomWidthGridElement() {
        this.setBackgroundColor(TRANSPARENT_COLOR);
    }

    public void setElement(TableElement element, R rowKey, C columnKey) {
        this.elements.setValue((Object)element, rowKey, columnKey);
    }

    public void receive(TableElementVisitor visitor) {
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = (TableElement)this.elements.getValue(r, c);
                if (element == null) continue;
                element.receive(visitor);
            }
        }
        visitor.visit((TableElement)this);
    }

    private double[][] findCellDimensions(Graphics2D g2, Rectangle2D bounds) {
        int c;
        int rowCount = this.elements.getRowCount();
        int columnCount = this.elements.getColumnCount();
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = (TableElement)this.elements.getValue(r, c);
                if (element == null) continue;
                Dimension2D dim = element.preferredSize(g2, bounds);
                maxWidth = Math.max(maxWidth, dim.getWidth());
                maxHeight = Math.max(maxHeight, dim.getHeight());
            }
        }
        double[] widths = new double[columnCount];
        for (c = 0; c < columnCount; ++c) {
            widths[c] = columnCount == 1 ? bounds.getWidth() : maxWidth;
        }
        double[] heights = new double[rowCount];
        for (int r = 0; r < rowCount; ++r) {
            heights[r] = maxHeight;
        }
        return new double[][]{widths, heights};
    }

    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        Insets insets = this.getInsets();
        double[][] cellDimensions = this.findCellDimensions(g2, bounds);
        double[] widths = cellDimensions[0];
        double[] heights = cellDimensions[1];
        double w = insets.left + insets.right;
        for (int i = 0; i < widths.length; ++i) {
            w += widths[i];
        }
        double h = insets.top + insets.bottom;
        for (int i = 0; i < heights.length; ++i) {
            h += heights[i];
        }
        return new Dimension((int)w, (int)h);
    }

    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        int bufferEach = 10;
        double totWidth = bounds.getWidth() - (double)(2 * bufferEach);
        double wdithEach = totWidth / (double)this.elements.getColumnCount();
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(this.elements.getRowCount() * this.elements.getColumnCount());
        double y = bounds.getY() + (double)this.getInsets().top;
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            double x = bounds.getX() + (double)bufferEach;
            double maxHeight = 0.0;
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = (TableElement)this.elements.getValue(r, c);
                double height = element.preferredSize(g2, bounds).getHeight();
                maxHeight = Math.max(maxHeight, height);
                Rectangle2D.Double cellBounds = new Rectangle2D.Double(x, y, wdithEach, height);
                element.layoutElements(g2, (Rectangle2D)cellBounds, null);
                result.add(cellBounds);
                x += wdithEach;
            }
            y += maxHeight;
        }
        return result;
    }

    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw((TableElement)this, g2, bounds);
        }
        if (this.getBackground() != null) {
            this.getBackground().fill(g2, bounds);
        }
        List<Rectangle2D> positions = this.layoutElements(g2, bounds, null);
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = (TableElement)this.elements.getValue(r, c);
                if (element == null) continue;
                Rectangle2D pos = positions.get(r * this.elements.getColumnCount() + c);
                element.draw(g2, pos, onDrawHandler);
            }
        }
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw((TableElement)this, g2, bounds);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomWidthGridElement)) {
            return false;
        }
        CustomWidthGridElement that = (CustomWidthGridElement)obj;
        return this.elements.equals(that.elements);
    }

    public String toString() {
        return "GridElement[rowCount=" + this.elements.getRowCount() + ", columnCount=" + this.elements.getColumnCount() + "]";
    }
}

