/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import org.jfree.chart3d.Chart3D;
import org.jfree.chart3d.Chart3DPanel;
import org.jfree.chart3d.axis.CategoryAxis3D;
import org.jfree.chart3d.axis.LabelOrientation;
import org.jfree.chart3d.axis.NumberAxis3D;
import org.jfree.chart3d.axis.StandardCategoryAxis3D;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.export.ExportUtils;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.graphics3d.Drawable3D;
import org.jfree.chart3d.graphics3d.Offset2D;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.label.CategoryLabelGenerator;
import org.jfree.chart3d.plot.CategoryPlot3D;
import org.jfree.chart3d.plot.Plot3D;
import org.jfree.chart3d.renderer.category.CategoryColorSource;
import org.jfree.chart3d.renderer.category.CategoryRenderer3D;
import org.jfree.chart3d.style.ChartStyle;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.pdf.PDF_UTF8_FontMapper;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;
import org.opensha.sha.calc.disaggregation.chart3d.DisaggBarRenderer3D;
import org.opensha.sha.calc.disaggregation.chart3d.DisaggChart3D;
import org.opensha.sha.calc.disaggregation.chart3d.DisaggChartStyle;
import org.opensha.sha.calc.disaggregation.chart3d.DisaggDataset3D;
import org.opensha.sha.calc.disaggregation.chart3d.DisaggLegendBuilder;
import org.opensha.sha.calc.disaggregation.chart3d.FixedPerspectiveChart3DPanel;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;

public class PureJavaDisaggPlotter {
    private static DecimalFormat magDF = new DecimalFormat("0.0#");
    private static DecimalFormat distDF = new DecimalFormat("0");

    public static Chart3DPanel buildChartPanel(DisaggregationPlotData data) {
        return PureJavaDisaggPlotter.buildChartPanel(data, true);
    }

    public static Chart3DPanel buildChartPanel(DisaggregationPlotData data, boolean fixedPerspective) {
        Chart3D chart = PureJavaDisaggPlotter.buildChart(data);
        FixedPerspectiveChart3DPanel chartPanel = fixedPerspective ? new FixedPerspectiveChart3DPanel(chart) : new Chart3DPanel(chart);
        chartPanel.setMargin(0.2);
        chartPanel.setSize(800, 800);
        chartPanel.setPreferredSize(new Dimension(800, 800));
        chartPanel.zoomToFit();
        return chartPanel;
    }

    public static Chart3D buildChart(DisaggregationPlotData data) {
        DisaggDataset3D dataset = new DisaggDataset3D(data);
        double maxZ = 0.0;
        double[][][] pdf3D = data.getPdf3D();
        for (int i = 0; i < pdf3D.length; ++i) {
            for (int j = 0; j < pdf3D[i].length; ++j) {
                double sumZ = 0.0;
                for (double contrib : pdf3D[i][j]) {
                    sumZ += contrib;
                }
                maxZ = Math.max(maxZ, sumZ);
            }
        }
        maxZ = 10.0 * Math.ceil(maxZ / 10.0);
        DisaggCategoryLabelGenerator labelGen = new DisaggCategoryLabelGenerator();
        BasicStroke axisStroke = new BasicStroke(1.0f);
        double tickLen = 4.0;
        StandardCategoryAxis3D rowAxis = new StandardCategoryAxis3D("Rupture Distance (km)");
        rowAxis.setTickLabelOrientation(LabelOrientation.PARALLEL);
        rowAxis.setTickLabelGenerator((CategoryLabelGenerator)labelGen);
        rowAxis.setLineColor(Color.BLACK);
        rowAxis.setLineStroke((Stroke)axisStroke);
        rowAxis.setFirstCategoryHalfWidth(true);
        rowAxis.setLastCategoryHalfWidth(true);
        rowAxis.setTickMarkStroke((Stroke)axisStroke);
        rowAxis.setTickMarkLength(tickLen);
        StandardCategoryAxis3D columnAxis = new StandardCategoryAxis3D("Magnitude");
        columnAxis.setTickLabelOrientation(LabelOrientation.PARALLEL);
        columnAxis.setTickLabelGenerator((CategoryLabelGenerator)labelGen);
        columnAxis.setLineColor(Color.BLACK);
        columnAxis.setLineStroke((Stroke)axisStroke);
        columnAxis.setFirstCategoryHalfWidth(true);
        columnAxis.setLastCategoryHalfWidth(true);
        columnAxis.setTickMarkStroke((Stroke)axisStroke);
        columnAxis.setTickMarkLength(tickLen);
        NumberAxis3D valueAxis = new NumberAxis3D("% Contribution", new Range(0.0, maxZ));
        valueAxis.setTickLabelOrientation(LabelOrientation.PARALLEL);
        valueAxis.setLineColor(Color.BLACK);
        valueAxis.setLineStroke((Stroke)axisStroke);
        valueAxis.setTickMarkStroke((Stroke)axisStroke);
        valueAxis.setTickMarkLength(tickLen);
        DisaggBarRenderer3D renderer = new DisaggBarRenderer3D();
        renderer.setBarXWidth(0.85);
        renderer.setBarZWidth(0.85);
        CategoryPlot3D plot = new CategoryPlot3D((CategoryDataset3D)dataset, (CategoryRenderer3D)renderer, (CategoryAxis3D)rowAxis, (CategoryAxis3D)columnAxis, (ValueAxis3D)valueAxis);
        DisaggChart3D chart = new DisaggChart3D(null, null, (Plot3D)plot, (ChartStyle)new DisaggChartStyle());
        plot.setLegendLabelGenerator((CategoryLabelGenerator)labelGen);
        renderer.setColorSource(new EpsilonColorSource());
        double theta = 31.0;
        double phi = 70.0;
        double rho = 30.0;
        double orientation = -76.1;
        chart.setViewPoint(new ViewPoint3D(Math.toRadians(theta), Math.toRadians(phi), rho, Math.toRadians(orientation)));
        chart.setTranslate2D(new Offset2D(20.0, -80.0));
        chart.setLegendAnchor(Anchor2D.BOTTOM_CENTER);
        chart.setLegendBuilder(new DisaggLegendBuilder());
        return chart;
    }

    public static void writeChartPlot(File outputDir, String prefix, DisaggregationPlotData data, int width, int height, boolean writePNG, boolean writePDF) throws IOException {
        Chart3DPanel panel = PureJavaDisaggPlotter.buildChartPanel(data);
        panel.setSize(width, height);
        panel.setPreferredSize(new Dimension(width, height));
        panel.zoomToFit();
        PureJavaDisaggPlotter.writeChartPlot(outputDir, prefix, panel, writePNG, writePDF);
    }

    public static void writeChartPlot(File outputDir, String prefix, Chart3DPanel panel, boolean writePNG, boolean writePDF) throws IOException {
        int width = panel.getWidth();
        int height = panel.getHeight();
        if (writePNG) {
            ExportUtils.writeAsPNG((Drawable3D)panel.getDrawable(), (int)width, (int)height, (File)new File(outputDir, prefix + ".png"));
        }
        if (writePDF) {
            PureJavaDisaggPlotter.writeChartPDF(new File(outputDir, prefix + ".pdf"), panel, null);
        }
    }

    public static void writeChartPDF(File outputFile, Chart3DPanel panel, String metadata) throws IOException {
        int width = panel.getWidth();
        int height = panel.getHeight();
        Document metadataDocument = new Document(new Rectangle((float)width, (float)height));
        metadataDocument.addAuthor("OpenSHA");
        metadataDocument.addCreationDate();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)metadataDocument, (OutputStream)new FileOutputStream(outputFile));
            metadataDocument.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PDF_UTF8_FontMapper fontMapper = new PDF_UTF8_FontMapper();
            PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)tp, (float)width, (float)height, (FontMapper)fontMapper);
            Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, width, height);
            panel.getChart().draw((Graphics2D)g2d, (Rectangle2D)r2d);
            g2d.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            if (metadata != null && !metadata.isBlank()) {
                metadataDocument.newPage();
                Paragraph para = new Paragraph();
                Color c = Color.BLACK;
                BaseColor bc = new BaseColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
                para.add((Element)new Phrase(metadata, FontFactory.getFont((String)"Arimo-Regular", (float)10.0f, (int)0, (BaseColor)bc)));
                metadataDocument.add((Element)para);
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        metadataDocument.close();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        MeanUCERF2 erf = new MeanUCERF2();
        erf.getTimeSpan().setDuration(30.0);
        erf.getTimeSpan().setStartTime(2007);
        erf.updateForecast();
        ScalarIMR gmm = AttenRelRef.ASK_2014.get();
        gmm.setParamDefaults();
        gmm.setIntensityMeasure("SA");
        SA_Param.setPeriodInSA_Param(gmm.getIntensityMeasure(), 1.0);
        Site site = new Site(new Location(34.053, -118.243));
        site.addParameterList(gmm.getSiteParams());
        DisaggregationCalculator calc = new DisaggregationCalculator();
        calc.setDistanceRange(5.0, 11, 10.0);
        calc.setMagRange(5.0, 10, 0.5);
        calc.disaggregate(Math.log(0.1), site, gmm, (ERF)erf, new SourceFilterManager(SourceFilters.FIXED_DIST_CUTOFF).getEnabledFilters(), DisaggregationCalculator.getDefaultParams());
        System.out.println(calc.getBinData());
        boolean fixed = true;
        Chart3DPanel chartPanel = PureJavaDisaggPlotter.buildChartPanel(calc.getDisaggPlotData(), fixed);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane((Container)chartPanel);
        frame.setSize(800, 800);
        frame.setVisible(true);
        PureJavaDisaggPlotter.writeChartPlot(new File("/tmp"), "disagg_test", chartPanel, true, true);
        while (!fixed) {
            Thread.sleep(1000L);
            ViewPoint3D vp = chartPanel.getChart().getViewPoint();
            System.out.println("theta=" + Math.toDegrees(vp.getTheta()) + ", phi=" + Math.toDegrees(vp.getPhi()) + ", rho=" + vp.getRho() + ", orientation=" + Math.toDegrees(vp.calcRollAngle()));
        }
    }

    private static class DisaggCategoryLabelGenerator
    implements CategoryLabelGenerator<DisaggregationCalculator.EpsilonCategories, Double, Double> {
        private DisaggCategoryLabelGenerator() {
        }

        public String generateSeriesLabel(CategoryDataset3D<DisaggregationCalculator.EpsilonCategories, Double, Double> dataset, DisaggregationCalculator.EpsilonCategories seriesKey) {
            return seriesKey.label;
        }

        public String generateRowLabel(CategoryDataset3D<DisaggregationCalculator.EpsilonCategories, Double, Double> dataset, Double rowKey) {
            return distDF.format(rowKey);
        }

        public String generateColumnLabel(CategoryDataset3D<DisaggregationCalculator.EpsilonCategories, Double, Double> dataset, Double columnKey) {
            return magDF.format(columnKey);
        }
    }

    private static class EpsilonColorSource
    implements CategoryColorSource {
        private EpsilonColorSource() {
        }

        public Color getColor(int series, int row, int column) {
            return DisaggregationCalculator.EpsilonCategories.values()[series].color;
        }

        public Color getLegendColor(int series) {
            return DisaggregationCalculator.EpsilonCategories.values()[series].color;
        }

        public void style(Color ... colors) {
        }
    }
}

