/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;

public class BinaryHazardCurveWriter {
    private File outputFile;

    public BinaryHazardCurveWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    public void writeCurves(Map<Location, ? extends DiscretizedFunc> map) throws IOException {
        ArrayList sites = Lists.newArrayList();
        ArrayList curves = Lists.newArrayList();
        for (Location loc : map.keySet()) {
            sites.add(loc);
            curves.add(map.get(loc));
        }
        this.writeCurves(curves, sites);
    }

    public void writeCurves(List<? extends DiscretizedFunc> curves, List<Location> sites) throws IOException {
        int i;
        Preconditions.checkArgument((curves.size() == sites.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((!curves.isEmpty() ? 1 : 0) != 0);
        OutputStream out = new FileOutputStream(this.outputFile);
        out = new BufferedOutputStream(out);
        DataOutputStream dout = new DataOutputStream(out);
        DiscretizedFunc xVals = curves.get(0);
        dout.writeInt(xVals.size());
        for (i = 0; i < xVals.size(); ++i) {
            dout.writeDouble(xVals.getX(i));
        }
        for (i = 0; i < curves.size(); ++i) {
            DiscretizedFunc curve = curves.get(i);
            Preconditions.checkState((curve.size() == xVals.size() ? 1 : 0) != 0);
            Location loc = sites.get(i);
            dout.writeDouble(loc.getLatitude());
            dout.writeDouble(loc.getLongitude());
            for (Point2D pt : curve) {
                dout.writeDouble(pt.getY());
            }
        }
        dout.close();
    }
}

