/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.sha.calc.hazardMap.AsciiCurveAverager;
import org.opensha.sha.calc.hazardMap.HazardDataSetLoader;

public class CurveMultiplier {
    private String inputDir;
    private String outputDir;

    public CurveMultiplier(String inputDir, String outputDir) {
        File outputDirFile = new File((String)outputDir);
        if (!outputDirFile.exists()) {
            outputDirFile.mkdirs();
        }
        if (!((String)outputDir).endsWith(File.separator)) {
            outputDir = (String)outputDir + File.separator;
        }
        if (!((String)inputDir).endsWith(File.separator)) {
            inputDir = (String)inputDir + File.separator;
        }
        this.inputDir = inputDir;
        this.outputDir = outputDir;
    }

    public void multiplyCurves(double factor) throws IOException {
        File[] dirList;
        File masterDir = new File(this.inputDir);
        for (File dir : dirList = masterDir.listFiles()) {
            File[] subDirList;
            if (!dir.isDirectory() || dir.getName().endsWith(".")) continue;
            for (File file : subDirList = dir.listFiles()) {
                Location loc;
                String fileName = file.getName();
                File outSubDirFile = new File(this.outputDir + dir.getName());
                if (!outSubDirFile.exists()) {
                    outSubDirFile.mkdir();
                }
                if (!fileName.endsWith(".txt") || (loc = HazardDataSetLoader.decodeFileName(fileName)) == null) continue;
                String relativePath = dir.getName() + File.separator + fileName;
                System.out.println(relativePath);
                ArbitrarilyDiscretizedFunc func = ArbitrarilyDiscretizedFunc.loadFuncFromSimpleFile(this.inputDir + relativePath);
                DiscretizedFunc aveCurve = CurveMultiplier.multiplyCurve(func, factor);
                ArbitrarilyDiscretizedFunc.writeSimpleFuncFile(aveCurve, this.outputDir + relativePath);
            }
        }
    }

    public static DiscretizedFunc multiplyCurve(DiscretizedFunc curve, double factor) {
        ArbitrarilyDiscretizedFunc multFunc = new ArbitrarilyDiscretizedFunc();
        int numPoints = curve.size();
        for (int i = 0; i < numPoints; ++i) {
            double x = curve.getX(i);
            double y = curve.getY(x) * factor;
            multFunc.set(x, y);
        }
        return multFunc;
    }

    public static void main(String[] args) {
        ArrayList<String> dirs = new ArrayList<String>();
        String outputDir = null;
        if (args.length > 3) {
            for (int i = 0; i < args.length - 1; ++i) {
                dirs.add(args[i]);
            }
            outputDir = args[args.length - 1];
        } else {
            System.out.println("USAGE: CurveAverager dir1 dir2 dir3 [... dirN] outputDir");
            System.exit(2);
        }
        AsciiCurveAverager ave = new AsciiCurveAverager(dirs, outputDir);
        try {
            ave.averageDirs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

