/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.components;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.metadata.XMLSaveable;

public class CalculationSettings
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "CalculationSettings";
    private HashMap<String, DiscretizedFunc> imtXValMap;
    private double maxSourceDistance;
    private boolean calcInLogSpace = true;
    private boolean serializeERF = true;

    public CalculationSettings(DiscretizedFunc xValues, double maxSourceDistance) {
        this(new HashMap<String, DiscretizedFunc>(), maxSourceDistance);
        this.imtXValMap.put(null, xValues);
        this.maxSourceDistance = maxSourceDistance;
    }

    public CalculationSettings(HashMap<String, DiscretizedFunc> imtXValMap, double maxSourceDistance) {
        this.imtXValMap = imtXValMap;
        this.maxSourceDistance = maxSourceDistance;
    }

    public DiscretizedFunc getXValues(String imt) {
        if (imt == null || this.imtXValMap.size() == 1) {
            return this.imtXValMap.get(this.imtXValMap.keySet().iterator().next());
        }
        return this.imtXValMap.get(imt);
    }

    public void setXValues(DiscretizedFunc xValues) {
        this.imtXValMap.clear();
        if (xValues != null) {
            this.imtXValMap.put(null, xValues);
        }
    }

    public void setXValues(String imt, DiscretizedFunc xValues) {
        this.imtXValMap.put(imt, xValues);
    }

    public Map<String, DiscretizedFunc> getXValsMap() {
        return this.imtXValMap;
    }

    public double getMaxSourceDistance() {
        return this.maxSourceDistance;
    }

    public void setMaxSourceDistance(double maxSourceDistance) {
        this.maxSourceDistance = maxSourceDistance;
    }

    public void setCalcInLogSpace(boolean calcInLogSpace) {
        this.calcInLogSpace = calcInLogSpace;
    }

    public boolean isCalcInLogSpace() {
        return this.calcInLogSpace;
    }

    public void setSerializeERF(boolean serializeERF) {
        this.serializeERF = serializeERF;
    }

    public boolean isSerializeERF() {
        return this.serializeERF;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element calcEl = root.addElement(XML_METADATA_NAME);
        calcEl.addAttribute("maxSourceDistance", "" + this.maxSourceDistance);
        calcEl.addAttribute("calcInLogSpace", "" + this.calcInLogSpace);
        calcEl.addAttribute("serializeERF", "" + this.serializeERF);
        for (String imt : this.imtXValMap.keySet()) {
            DiscretizedFunc xValues = this.imtXValMap.get(imt);
            if (imt == null) {
                xValues.setXAxisName("");
            } else {
                xValues.setXAxisName(imt);
            }
            calcEl = xValues.toXMLMetadata(calcEl);
        }
        return root;
    }

    public static CalculationSettings fromXMLMetadata(Element calcEl) {
        double maxSourceDistance = Double.parseDouble(calcEl.attributeValue("maxSourceDistance"));
        boolean calcInLogSpace = Boolean.parseBoolean(calcEl.attributeValue("calcInLogSpace"));
        boolean serializeERF = Boolean.parseBoolean(calcEl.attributeValue("serializeERF"));
        Iterator funcElIt = calcEl.elementIterator("discretizedFunction");
        HashMap<String, DiscretizedFunc> imtXValMap = new HashMap<String, DiscretizedFunc>();
        while (funcElIt.hasNext()) {
            Element funcEl = (Element)funcElIt.next();
            AbstractDiscretizedFunc func = ArbitrarilyDiscretizedFunc.fromXMLMetadata(funcEl);
            ArbitrarilyDiscretizedFunc xValues = func instanceof ArbitrarilyDiscretizedFunc ? (ArbitrarilyDiscretizedFunc)func : new ArbitrarilyDiscretizedFunc(func);
            imtXValMap.put(xValues.getXAxisName(), xValues);
        }
        CalculationSettings calcSettings = imtXValMap.size() == 1 ? new CalculationSettings(imtXValMap.get(imtXValMap.keySet().iterator().next()), maxSourceDistance) : new CalculationSettings(imtXValMap, maxSourceDistance);
        calcSettings.setCalcInLogSpace(calcInLogSpace);
        calcSettings.setSerializeERF(serializeERF);
        return calcSettings;
    }
}

