/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.dagGen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.opensha.commons.data.Site;
import org.opensha.commons.hpc.condor.DAG;
import org.opensha.commons.hpc.condor.SubmitScript;
import org.opensha.commons.hpc.condor.SubmitScriptForDAG;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.calc.hazardMap.HazardCurveDriver;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;
import org.opensha.sha.calc.hazardMap.components.CalculationSettings;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class HazardDataSetDAGCreator {
    public static final String ERF_SERIALIZED_FILE_NAME = "erf.obj";
    protected ERF erf;
    protected List<Map<TectonicRegionType, ScalarIMR>> imrMaps;
    private List<Parameter<Double>> imts;
    protected List<Site> sites;
    protected CalculationSettings calcSettings;
    protected CurveResultsArchiver archiver;
    protected String javaExec;
    protected String jarFile;
    private int heapSize = 1800;
    private int heapMinSize = this.heapSize / 20;
    private String requirements = null;
    private DecimalFormat curveIndexFormat;
    protected SubmitScript.Universe universe = SubmitScript.Universe.VANILLA;
    public static int DAGMAN_MAX_IDLE = 50;
    public static int DAGMAN_MAX_PRE = 3;
    public static int DAGMAN_MAX_POST = 5;

    public HazardDataSetDAGCreator(CalculationInputsXMLFile inputs, String javaExec, String jarFile) {
        this(inputs.getERF(), inputs.getIMRMaps(), inputs.getIMTs(), inputs.getSites(), inputs.getCalcSettings(), inputs.getArchiver(), javaExec, jarFile);
    }

    public HazardDataSetDAGCreator(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Parameter<Double>> imts, List<Site> sites, CalculationSettings calcSettings, CurveResultsArchiver archiver, String javaExec, String jarFile) {
        this.erf = erf;
        this.imrMaps = imrMaps;
        this.imts = imts;
        this.sites = sites;
        this.calcSettings = calcSettings;
        this.archiver = archiver;
        Object fstr = "";
        for (int i = 0; i < ("" + sites.size()).length(); ++i) {
            fstr = (String)fstr + "0";
        }
        this.curveIndexFormat = new DecimalFormat((String)fstr);
        this.javaExec = javaExec;
        this.jarFile = jarFile;
    }

    private void writeCalcWrapperScript(String scriptFile, int startIndex, String xmlFile) throws IOException {
        String newJarFile = "openSHA_" + startIndex + ".jar";
        String javaCommand = this.javaExec + " -Xmx" + this.heapSize + "M -Xms" + this.heapMinSize + "M -classpath $jarDir/" + newJarFile + " " + HazardCurveDriver.class.getName() + " " + xmlFile;
        FileWriter fw = new FileWriter(scriptFile);
        fw.write("#!/bin/bash\n");
        fw.write("\n");
        fw.write("set -o errexit\n");
        fw.write("\n");
        fw.write("jarDir=\"/tmp\"\n");
        fw.write("\n");
        fw.write("cp " + this.jarFile + " $jarDir/" + newJarFile + "\n");
        fw.write("\n");
        fw.write(javaCommand + "\n");
        fw.write("exit $?\n");
        fw.close();
    }

    protected DAG getPreDAG(File outputDir) throws IOException {
        return null;
    }

    protected DAG getPostDAG(File outputDir) throws IOException {
        return null;
    }

    public void writeDAG(File outputDir, int sitesPerJob, boolean run) throws IOException {
        if (sitesPerJob < 1) {
            throw new IllegalArgumentException("curvesPerJob must be >= 1");
        }
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new IOException("Output directory '" + outputDir.getPath() + "' does not exist and could not be created.");
        }
        Object odir = outputDir.getAbsolutePath();
        if (!((String)odir).endsWith(File.separator)) {
            odir = (String)odir + File.separator;
        }
        String serializedERFFile = null;
        if (this.calcSettings.isSerializeERF()) {
            serializedERFFile = this.serializeERF((String)odir);
        }
        int numSites = this.sites.size();
        DAG dag = new DAG();
        new File((String)odir + "log").mkdir();
        new File((String)odir + "out").mkdir();
        new File((String)odir + "err").mkdir();
        String imageSize = this.heapSize + " Meg";
        if (this.requirements == null) {
            this.requirements = "";
        }
        if (!this.requirements.toLowerCase().contains("memory")) {
            if (!this.requirements.isEmpty()) {
                this.requirements = this.requirements + " && ";
            }
            this.requirements = this.requirements + "Memory>=" + this.heapSize;
        }
        for (int startIndex = 0; startIndex < numSites; startIndex += sitesPerJob) {
            int endIndex = startIndex + sitesPerJob - 1;
            if (endIndex > numSites - 1) {
                endIndex = numSites - 1;
            }
            System.out.println("Writing job for curves " + startIndex + " => " + endIndex);
            String jobName = "Curves_" + this.curveIndexFormat.format(startIndex) + "_" + this.curveIndexFormat.format(endIndex);
            String xmlFile = this.writeCurveJobXML((String)odir, startIndex, endIndex, jobName, serializedERFFile);
            String scriptFile = (String)odir + jobName + ".sh";
            this.writeCalcWrapperScript(scriptFile, startIndex, xmlFile);
            String executable = "/bin/bash";
            String arguments = scriptFile;
            SubmitScriptForDAG job = new SubmitScriptForDAG(jobName, executable, arguments, "/tmp", this.universe, true);
            job.setRequirements(this.requirements);
            job.setImageSize(imageSize);
            job.writeScriptInDir((String)odir);
            job.setComment("Calculates curves " + startIndex + "->" + endIndex + ", inclusive");
            dag.addJob(job);
        }
        DAG preDAG = this.getPreDAG(outputDir);
        DAG postDAG = this.getPostDAG(outputDir);
        if (preDAG != null) {
            dag.addDAG(preDAG, DAG.DAG_ADD_LOCATION.BEFORE_ALL);
        }
        if (postDAG != null) {
            dag.addDAG(postDAG, DAG.DAG_ADD_LOCATION.AFTER_ALL);
        }
        String dagFileName = (String)odir + "main.dag";
        System.out.println("Writing DAG: " + dagFileName + " (" + dag.getNumJobs() + " jobs)");
        dag.writeDag(dagFileName);
        System.out.println("Writing DAG submit script");
        HazardDataSetDAGCreator.createSubmitDAGScript((String)odir, run);
    }

    private String writeCurveJobXML(String odir, int startIndex, int endIndex, String jobName, String serializedERFFile) throws IOException {
        String fileName = odir + jobName + "_input.xml";
        List<Site> newSites = this.sites.subList(startIndex, endIndex + 1);
        CalculationInputsXMLFile xml = new CalculationInputsXMLFile(this.erf, this.imrMaps, this.imts, newSites, this.calcSettings, this.archiver);
        xml.setSerialized(serializedERFFile);
        Document doc = XMLUtils.createDocumentWithRoot();
        xml.toXMLMetadata(doc.getRootElement());
        XMLUtils.writeDocumentToFile(new File(fileName), doc);
        return fileName;
    }

    private String serializeERF(String odir) throws IOException {
        this.erf.updateForecast();
        String serializedERFFile = odir + ERF_SERIALIZED_FILE_NAME;
        FileUtils.saveObjectInFile(serializedERFFile, this.erf);
        return serializedERFFile;
    }

    public SubmitScript.Universe getUniverse() {
        return this.universe;
    }

    public void setUniverse(SubmitScript.Universe universe) {
        this.universe = universe;
    }

    public static void createSubmitDAGScript(String odir, boolean run) throws IOException {
        String scriptFileName = odir + "submit_DAG.sh";
        FileWriter fw = new FileWriter(scriptFileName);
        fw.write("#!/bin/bash\n");
        fw.write("\n");
        fw.write("if [ -f ~/.bash_profile ]; then\n");
        fw.write("\t. ~/.bash_profile\n");
        fw.write("fi\n");
        fw.write("\n");
        fw.write("cd " + odir + "\n");
        String dagArgs = "-maxidle " + DAGMAN_MAX_IDLE + " -MaxPre " + DAGMAN_MAX_PRE + " -MaxPost " + DAGMAN_MAX_POST + " -OldRescue 0 -AutoRescue 1";
        fw.write("condor_submit_dag " + dagArgs + " main.dag\n");
        fw.close();
        if (run) {
            String outFile = scriptFileName + ".subout";
            String errFile = scriptFileName + ".suberr";
            int retVal = RunScript.runScript(new String[]{"sh", "-c", "sh " + scriptFileName}, outFile, errFile);
            System.out.println("Command executed with status " + retVal);
        }
    }

    public void setRequirements(String requirements) {
        this.requirements = requirements;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public static void usage() {
        System.err.println("USAGE: HazardDataSetDAGCreator [args] <Input XML> <Curves Per Job> <Calc Dir> <Java Path> <Jar Path>");
        System.err.println("Valid args:");
        System.err.println("\t--reqs <requirements>");
        System.exit(2);
    }

    public static void main(String[] args) {
        System.out.println(HazardDataSetDAGCreator.class.getName() + ": starting up");
        if (args.length < 5) {
            HazardDataSetDAGCreator.usage();
        }
        int counter = 0;
        String reqs = null;
        if (args.length > 5) {
            boolean isArg = true;
            while (isArg) {
                String arg;
                if ((arg = args[counter++]).startsWith("--reqs")) {
                    reqs = args[counter++];
                    continue;
                }
                --counter;
                isArg = false;
            }
        }
        if (args.length - counter != 5) {
            HazardDataSetDAGCreator.usage();
        }
        String inputFile = args[counter++];
        int curvesPerJob = Integer.parseInt(args[counter++]);
        String calcDir = args[counter++];
        String javaPath = args[counter++];
        String jarPath = args[counter++];
        try {
            Document doc = XMLUtils.loadDocument(inputFile);
            CalculationInputsXMLFile inputs = CalculationInputsXMLFile.loadXML(doc);
            HazardDataSetDAGCreator dagCreator = new HazardDataSetDAGCreator(inputs, javaPath, jarPath);
            dagCreator.setRequirements(reqs);
            File calcDirFile = new File(calcDir);
            dagCreator.writeDAG(calcDirFile, curvesPerJob, false);
            System.out.println("DONE!");
            System.exit(0);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

