/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.mpj;

import com.google.common.base.Preconditions;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.opensha.commons.data.Site;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.calc.hazardMap.HazardCurveSetCalculator;
import org.opensha.sha.calc.hazardMap.ThreadedHazardCurveSetCalculator;
import org.opensha.sha.calc.hazardMap.components.BinaryCurveArchiver;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;

public class MPJHazardCurveDriver
extends MPJTaskCalculator {
    protected static final int TAG_READY_FOR_BATCH = 1;
    protected static final int TAG_NEW_BATCH_LENGH = 2;
    protected static final int TAG_NEW_BATCH = 3;
    private static final int MIN_DISPATCH_DEFAULT = 5;
    private static final int MAX_DISPATCH_DEFAULT = 100;
    public static final boolean D = true;
    protected static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private ThreadedHazardCurveSetCalculator calc;
    private List<Site> sites;

    public MPJHazardCurveDriver(CommandLine cmd, String[] args) throws IOException, DocumentException, InvocationTargetException {
        super(cmd);
        File xmlFile;
        if (args.length != 1) {
            System.err.println("USAGE: HazardCurveDriver [<options>] <XML input file>");
            MPJHazardCurveDriver.abortAndExit((int)2);
        }
        if (!(xmlFile = new File(args[0])).exists()) {
            throw new IOException("XML Input file '" + args[0] + "' not found!");
        }
        Document doc = XMLUtils.loadDocument(xmlFile.getAbsolutePath());
        Preconditions.checkArgument((this.getNumThreads() >= 1 ? 1 : 0) != 0, (Object)("threads must be >= 1. you supplied: " + this.getNumThreads()));
        boolean multERFs = cmd.hasOption("mult-erfs");
        this.debug("loading inputs for " + this.getNumThreads() + " threads");
        CalculationInputsXMLFile[] inputs = CalculationInputsXMLFile.loadXML(doc, this.getNumThreads(), multERFs);
        if (this.rank == 0 && inputs[0].getArchiver() instanceof BinaryCurveArchiver) {
            ((BinaryCurveArchiver)inputs[0].getArchiver()).initialize();
        }
        this.sites = inputs[0].getSites();
        HazardCurveSetCalculator[] calcs = new HazardCurveSetCalculator[this.getNumThreads()];
        for (int i = 0; i < inputs.length; ++i) {
            calcs[i] = new HazardCurveSetCalculator(inputs[i]);
        }
        Preconditions.checkNotNull((Object)calcs, (Object)"calcs cannot be null!");
        Preconditions.checkArgument((calcs.length > 0 ? 1 : 0) != 0, (Object)"calcs cannot be empty!");
        for (HazardCurveSetCalculator calc : calcs) {
            Preconditions.checkNotNull((Object)calc, (Object)"calc cannot be null!");
        }
        Preconditions.checkNotNull(this.sites, (Object)"sites cannot be null!");
        Preconditions.checkArgument((!this.sites.isEmpty() ? 1 : 0) != 0, (Object)"sites cannot be empty!");
        this.calc = new ThreadedHazardCurveSetCalculator(calcs);
    }

    public int getNumTasks() {
        return this.sites.size();
    }

    public void calculateBatch(int[] batch) throws Exception, InterruptedException {
        this.calc.calculateCurves(this.sites, batch);
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        Option erfOp = new Option("e", "mult-erfs", false, "If set, a copy of the ERF will be instantiated for each thread.");
        erfOp.setRequired(false);
        ops.addOption(erfOp);
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJHazardCurveDriver.createOptions();
            CommandLine cmd = MPJHazardCurveDriver.parse((Options)options, (String[])args, MPJHazardCurveDriver.class);
            args = cmd.getArgs();
            MPJHazardCurveDriver driver = new MPJHazardCurveDriver(cmd, args);
            driver.run();
            driver.calc.close();
            MPJHazardCurveDriver.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJHazardCurveDriver.abortAndExit((Throwable)t);
        }
    }

    protected void doFinalAssembly() throws Exception {
    }
}

