/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazus;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.calc.HazusMapCalculator;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.util.SiteTranslator;

public class HazusDataGenerator
implements ParameterChangeWarningListener {
    private final double MIN_LAT = 32.4;
    private final double MAX_LAT = 42.1;
    private final double MIN_LON = -125.5;
    private final double MAX_LON = -114.1;
    private final double GRID_SPACING = 0.1;
    private Frankel02_AdjustableEqkRupForecast forecast;
    private USGS_Combined_2004_AttenRel attenRel;
    private SitesInGriddedRegion sites;

    public HazusDataGenerator() {
        this.createAttenRel_Instance();
        this.createERF_Instance();
        this.createRegion();
        this.getSiteParamsForRegion();
        HazusMapCalculator calc = new HazusMapCalculator();
        calc.showProgressBar(false);
        String metaData = "Hazus Run 1(b) for the finer Grid spacing of 0.1km without Soil Effects with Background:\n\nERF: " + this.forecast.getName() + "\nIMR Name: " + this.attenRel.getName() + "\n\tSite Name: Vs30\nRegion Info: \t MIN LAT: " + this.sites.getRegion().getMinLat() + " MAX LAT:" + this.sites.getRegion().getMaxLat() + " MIN LON: " + this.sites.getRegion().getMinLon() + " MAX LON: " + this.sites.getRegion().getMaxLon() + " Grid Spacing: " + this.sites.getRegion().getSpacing() + "\n";
        calc.getHazardMapCurves(this.sites, this.attenRel, this.forecast, metaData);
    }

    public static void main(String[] args) {
        try {
            HazusDataGenerator hazusDataGenerator = new HazusDataGenerator();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.exit(0);
        }
    }

    private void getSiteParamsForRegion() {
        this.sites.addSiteParams(this.attenRel.getSiteParamsIterator());
        ListIterator<Parameter<?>> it = this.attenRel.getSiteParamsIterator();
        ArrayList<Parameter> defaultSiteParams = new ArrayList<Parameter>();
        SiteTranslator siteTrans = new SiteTranslator();
        while (it.hasNext()) {
            Parameter tempParam = (Parameter)it.next().clone();
            siteTrans.setParameterValue(tempParam, "DE", Double.NaN);
            defaultSiteParams.add(tempParam);
        }
        this.sites.setDefaultSiteParams(defaultSiteParams);
    }

    private void createERF_Instance() {
        this.forecast = new Frankel02_AdjustableEqkRupForecast();
        this.forecast.getTimeSpan().setDuration(50.0);
        this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_INCLUDE);
        this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_FINITE);
        this.forecast.updateForecast();
    }

    private void createAttenRel_Instance() {
        this.attenRel = new USGS_Combined_2004_AttenRel(this);
        this.attenRel.setParamDefaults();
        this.attenRel.getParameter("Vs30").setValue(760.0);
        this.attenRel.getParameter("Gaussian Truncation").setValue("1 Sided");
        this.attenRel.getParameter("Truncation Level").setValue(3.0);
        this.attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
    }

    private void createRegion() {
        GriddedRegion eggr = new GriddedRegion(new Location(32.4, -125.5), new Location(42.1, -114.1), 0.1, new Location(0.0, 0.0));
        this.sites = new SitesInGriddedRegion(eggr);
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameter param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }
}

