/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazus.parallel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.hpc.condor.DAG;
import org.opensha.commons.hpc.condor.SubmitScriptForDAG;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;
import org.opensha.sha.calc.hazardMap.components.CalculationSettings;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;
import org.opensha.sha.calc.hazardMap.dagGen.HazardDataSetDAGCreator;
import org.opensha.sha.calc.hazus.parallel.HazusDataSetAssmbler;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class HazusDataSetDAGCreator
extends HazardDataSetDAGCreator {
    private int durationYears;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double spacing;

    public HazusDataSetDAGCreator(CalculationInputsXMLFile inputs, String javaExec, String jarFile, int durationYears, double spacing) throws InvocationTargetException {
        this(inputs.getERF(), inputs.getIMRMaps(), inputs.getSites(), inputs.getCalcSettings(), inputs.getArchiver(), javaExec, jarFile, durationYears, spacing);
    }

    public HazusDataSetDAGCreator(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Site> sites, CalculationSettings calcSettings, CurveResultsArchiver archiver, String javaExec, String jarFile, int durationYears, double spacing) throws InvocationTargetException {
        super(erf, HazusDataSetDAGCreator.getHAZUSMaps(imrMaps), HazusDataSetDAGCreator.getIMTList(imrMaps), sites, calcSettings, archiver, javaExec, jarFile);
        this.durationYears = durationYears;
        this.spacing = spacing;
        this.calcExtentsFromSites();
    }

    public HazusDataSetDAGCreator(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Parameter<Double>> imts, List<Site> sites, CalculationSettings calcSettings, CurveResultsArchiver archiver, String javaExec, String jarFile, int durationYears, double spacing) throws InvocationTargetException {
        super(erf, HazusDataSetDAGCreator.getHAZUSMaps(imrMaps), HazusDataSetDAGCreator.validateIMTList(imts), sites, calcSettings, archiver, javaExec, jarFile);
        this.durationYears = durationYears;
        this.spacing = spacing;
        this.calcExtentsFromSites();
    }

    private void calcExtentsFromSites() {
        this.minLon = Double.MAX_VALUE;
        this.maxLon = Double.NEGATIVE_INFINITY;
        this.minLat = Double.MAX_VALUE;
        this.maxLat = Double.NEGATIVE_INFINITY;
        for (Site site : this.sites) {
            Location loc = site.getLocation();
            double lat = loc.getLatitude();
            double lon = loc.getLongitude();
            if (lat < this.minLat) {
                this.minLat = lat;
            }
            if (lat > this.maxLat) {
                this.maxLat = lat;
            }
            if (lon < this.minLon) {
                this.minLon = lon;
            }
            if (!(lon > this.maxLon)) continue;
            this.maxLon = lon;
        }
    }

    public static List<Map<TectonicRegionType, ScalarIMR>> getHAZUSMaps(List<Map<TectonicRegionType, ScalarIMR>> imrMaps) throws InvocationTargetException {
        if (imrMaps.size() == 1) {
            boolean supportsPGV = true;
            for (ScalarIMR imr : imrMaps.get(0).values()) {
                if (imr.isIntensityMeasureSupported("PGV")) continue;
                supportsPGV = false;
                break;
            }
            ArrayList<Map<TectonicRegionType, ScalarIMR>> newIMRMaps = new ArrayList<Map<TectonicRegionType, ScalarIMR>>();
            Map<TectonicRegionType, ScalarIMR> origMap = imrMaps.get(0);
            HashMap<TectonicRegionType, ScalarIMR> pgaMap = new HashMap<TectonicRegionType, ScalarIMR>();
            HashMap<TectonicRegionType, ScalarIMR> pgvMap = new HashMap<TectonicRegionType, ScalarIMR>();
            HashMap<TectonicRegionType, ScalarIMR> sa03Map = new HashMap<TectonicRegionType, ScalarIMR>();
            HashMap<TectonicRegionType, ScalarIMR> sa10Map = new HashMap<TectonicRegionType, ScalarIMR>();
            for (TectonicRegionType trt : origMap.keySet()) {
                ScalarIMR imr = origMap.get(trt);
                pgaMap.put(trt, imr);
                pgvMap.put(trt, imr);
                sa03Map.put(trt, imr);
                sa10Map.put(trt, imr);
            }
            newIMRMaps.add(pgaMap);
            if (supportsPGV) {
                newIMRMaps.add(pgvMap);
            }
            newIMRMaps.add(sa03Map);
            newIMRMaps.add(sa10Map);
            return newIMRMaps;
        }
        if (imrMaps.size() == 4) {
            HazusDataSetDAGCreator.validateHAZUSMap(imrMaps);
            return imrMaps;
        }
        throw new IllegalArgumentException("imrMaps must either be of size 1, or size 4 and alreadysetup for HAZUS.");
    }

    protected static void validateHAZUSMap(List<Map<TectonicRegionType, ScalarIMR>> imrMaps) {
        if (imrMaps.size() != 4) {
            throw new RuntimeException("imrMaps must contain exactly 4 elements");
        }
    }

    public static List<Parameter<Double>> validateIMTList(List<Parameter<Double>> imts) {
        if (imts.size() != 4) {
            throw new IllegalArgumentException("IMT list must be of size 4");
        }
        block6: for (int i = 0; i < 4; ++i) {
            DoubleParameter periodParam = null;
            Parameter<Double> imt = imts.get(i);
            switch (i) {
                case 0: {
                    if (imt.getName() == "PGA") continue block6;
                    throw new RuntimeException("HAZUS IMT 1 must be of type PGA");
                }
                case 1: {
                    if (imt.getName() == "PGV") continue block6;
                    throw new RuntimeException("HAZUS IMT 2 must be of type PGA");
                }
                case 2: {
                    if (imt.getName() != "SA") {
                        throw new RuntimeException("HAZUS IMT 3 must be of type PGA");
                    }
                    periodParam = (DoubleParameter)imt.getIndependentParameter("SA Period");
                    if ((Double)periodParam.getValue() == 0.3) continue block6;
                    throw new RuntimeException("HAZUS IMT 1 must have SA period of 0.3");
                }
                case 3: {
                    if (imt.getName() != "SA") {
                        throw new RuntimeException("HAZUS IMT 4 must be of type PGA");
                    }
                    periodParam = (DoubleParameter)imt.getIndependentParameter("SA Period");
                    if ((Double)periodParam.getValue() == 1.0) continue block6;
                    throw new RuntimeException("HAZUS IMT 1 must have SA period of 0.3");
                }
            }
        }
        return imts;
    }

    public static ArrayList<Parameter<Double>> getIMTList(List<Map<TectonicRegionType, ScalarIMR>> imrMaps) {
        Map<TectonicRegionType, ScalarIMR> map0 = imrMaps.get(0);
        ScalarIMR testIMR = map0.get(map0.keySet().iterator().next());
        ArrayList<Parameter<Double>> imts = new ArrayList<Parameter<Double>>();
        testIMR.setIntensityMeasure("PGA");
        imts.add((Parameter)testIMR.getIntensityMeasure().clone());
        if (testIMR.isIntensityMeasureSupported("PGV")) {
            testIMR.setIntensityMeasure("PGV");
            imts.add((Parameter)testIMR.getIntensityMeasure().clone());
        }
        testIMR.setIntensityMeasure("SA");
        Parameter saParam = (Parameter)testIMR.getIntensityMeasure().clone();
        Parameter periodParam = saParam.getIndependentParameter("SA Period");
        periodParam.setValue(0.3);
        imts.add(saParam);
        testIMR.setIntensityMeasure("SA");
        saParam = (Parameter)testIMR.getIntensityMeasure().clone();
        periodParam = saParam.getIndependentParameter("SA Period");
        periodParam.setValue(1.0);
        imts.add(saParam);
        return imts;
    }

    private String getIMRMetadata() {
        Object meta = null;
        Map imrMap1 = (Map)this.imrMaps.get(0);
        if (imrMap1.size() == 1) {
            ScalarIMR imr = (ScalarIMR)imrMap1.values().iterator().next();
            meta = "IMR = " + imr.getName() + "; " + imr.getOtherParams().getParameterListMetadataString();
        } else {
            meta = "IMR = (multiple)";
            for (TectonicRegionType trt : imrMap1.keySet()) {
                ScalarIMR imr = (ScalarIMR)imrMap1.get(trt);
                meta = (String)meta + "; " + trt.toString() + " = " + imr.getName() + "; " + imr.getAllParamMetadata();
            }
        }
        return meta;
    }

    private String getSitesMetadata() {
        return "Min Longitude = " + this.minLon + "; Max Longitude = " + this.maxLon + "; Min  Latitude = " + this.minLat + "; Max  Latitude = " + this.maxLat + "; Grid Spacing = " + this.spacing;
    }

    private String getERFMetadata() {
        return "Eqk Rup Forecast = " + this.erf.getName() + "; " + this.erf.getAdjustableParameterList().getParameterListMetadataString();
    }

    protected String writeMetadataFile(String odir) throws IOException {
        if (!((String)odir).endsWith(File.separator)) {
            odir = (String)odir + File.separator;
        }
        String fileName = (String)odir + "metadata.dat";
        FileWriter fw = new FileWriter(fileName);
        fw.write(this.getIMRMetadata() + "\n");
        fw.write("\n");
        fw.write(this.getSitesMetadata() + "\n");
        fw.write("\n");
        fw.write(this.getERFMetadata() + "\n");
        fw.write("Duration = " + this.erf.getTimeSpan().getDuration("Years") + "\n");
        fw.write("Return Period = $RETURN_PERIOD\n");
        fw.write("Maximum Site Source Distance = " + this.calcSettings.getMaxSourceDistance() + "\n");
        fw.close();
        return fileName;
    }

    @Override
    protected DAG getPostDAG(File outputDir) throws IOException {
        DAG postDAG = new DAG();
        Object odir = outputDir.getAbsolutePath();
        if (!((String)odir).endsWith(File.separator)) {
            odir = (String)odir + File.separator;
        }
        String metadataFile = this.writeMetadataFile((String)odir);
        String executable = this.javaExec;
        String vmArgs = "-classpath " + this.jarFile + " " + HazusDataSetAssmbler.class.getName();
        String progArgs = this.archiver.getStoreDir().getPath() + " " + this.durationYears + " " + metadataFile;
        String arguments = vmArgs + " " + progArgs;
        SubmitScriptForDAG assembleJob = new SubmitScriptForDAG("assemble", executable, arguments, "/tmp", this.universe, true);
        assembleJob.setRequirements(this.getRequirements());
        assembleJob.writeScriptInDir((String)odir);
        assembleJob.setComment("Assemble curves into HAZUS dataset");
        postDAG.addJob(assembleJob);
        return postDAG;
    }
}

