/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazus.parallel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.impl.CVM4BasinDepth;
import org.opensha.commons.data.siteData.impl.WaldAllenGlobalVs30;
import org.opensha.commons.data.siteData.impl.WillsMap2006;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.hpc.JavaShellScriptWriter;
import org.opensha.commons.hpc.mpj.FastMPJShellScriptWriter;
import org.opensha.commons.hpc.pbs.USC_HPCC_ScriptWriter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.calc.hazardMap.components.AsciiFileCurveArchiver;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;
import org.opensha.sha.calc.hazardMap.components.CalculationSettings;
import org.opensha.sha.calc.hazardMap.mpj.MPJHazardCurveDriver;
import org.opensha.sha.calc.hazus.parallel.HazusDataSetAssmbler;
import org.opensha.sha.calc.hazus.parallel.HazusDataSetDAGCreator;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.MultiIMR_Averaged_AttenRel;
import org.opensha.sha.imr.attenRelImpl.NGA_2008_Averaged_AttenRel;
import org.opensha.sha.imr.attenRelImpl.NGA_2008_Averaged_AttenRel_NoAS;
import org.opensha.sha.imr.attenRelImpl.NSHMP_2008_CA;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.util.SiteDataTypeParameterNameMap;
import org.opensha.sha.util.SiteTranslator;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class HazusJobWriter {
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd-HH_mm");
    private static final boolean constrainBasinMin = false;
    static final String NSHMP_08_NAME = "NSHMP08";
    static final String MultiIMR_NAME = "MultiIMR";
    static final String MultiIMR_NO_AS_NAME = "MultiIMRnoAS";

    static MeanUCERF2 getUCERF2(int years, int startYear, boolean includeBackSeis) {
        return HazusJobWriter.getUCERF2(years, startYear, includeBackSeis, UCERF2.BACK_SEIS_RUP_CROSSHAIR);
    }

    static MeanUCERF2 getUCERF2(int years, int startYear, boolean includeBackSeis, String backSeisType) {
        MeanUCERF2 ucerf = new MeanUCERF2();
        if (startYear > 0) {
            ucerf.getAdjustableParameterList().getParameter(String.class, "Probability Model").setValue("WGCEP Preferred Blend");
            ucerf.getTimeSpan().setDuration(years);
            ucerf.getTimeSpan().setStartTime(startYear);
        } else {
            ucerf.getAdjustableParameterList().getParameter(String.class, "Probability Model").setValue("Poisson");
            ucerf.getTimeSpan().setDuration(years);
        }
        ucerf.setParameter(UCERF2.BACK_SEIS_RUP_NAME, backSeisType);
        StringParameter backSeisParam = (StringParameter)ucerf.getParameter(UCERF2.BACK_SEIS_NAME);
        if (includeBackSeis) {
            backSeisParam.setValue(UCERF2.BACK_SEIS_INCLUDE);
        } else {
            backSeisParam.setValue(UCERF2.BACK_SEIS_EXCLUDE);
        }
        ucerf.updateForecast();
        System.out.println("UCERF Params:");
        System.out.println(ucerf.getAdjustableParameterList().getParameterListMetadataString());
        return ucerf;
    }

    static AbstractERF getERF(int years, int startYear, boolean includeBackSeis) {
        return HazusJobWriter.getUCERF2(years, startYear, includeBackSeis);
    }

    private static ScalarIMR getUSGSCombined2004IMR() {
        USGS_Combined_2004_AttenRel attenRel = new USGS_Combined_2004_AttenRel(null);
        attenRel.setParamDefaults();
        attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
        return attenRel;
    }

    private static ScalarIMR getUSGSCombined2008IMR() {
        NSHMP_2008_CA attenRel = new NSHMP_2008_CA(null);
        attenRel.setParamDefaults();
        return attenRel;
    }

    private static ScalarIMR getCB_2008IMR() {
        CB_2008_AttenRel imr = new CB_2008_AttenRel(null);
        imr.setParamDefaults();
        return imr;
    }

    private static ScalarIMR getNGA_2008IMR(boolean propEffectSpeedup, boolean includeAS) {
        MultiIMR_Averaged_AttenRel imr = includeAS ? new NGA_2008_Averaged_AttenRel(null) : new NGA_2008_Averaged_AttenRel_NoAS(null);
        imr.setParamDefaults();
        return imr;
    }

    static ScalarIMR getIMR(String name, double sigmaTrunc, boolean propEffectSpeedup) {
        ScalarIMR attenRel = null;
        if (name.equals(NSHMP_08_NAME)) {
            attenRel = HazusJobWriter.getUSGSCombined2008IMR();
        } else if (name.equals(MultiIMR_NAME)) {
            attenRel = HazusJobWriter.getNGA_2008IMR(propEffectSpeedup, true);
        } else if (name.equals(MultiIMR_NO_AS_NAME)) {
            attenRel = HazusJobWriter.getNGA_2008IMR(propEffectSpeedup, false);
        } else {
            for (AttenRelRef ref : AttenRelRef.values()) {
                if (!ref.name().equals(name)) continue;
                attenRel = ref.instance(null);
                break;
            }
            if (attenRel == null) {
                throw new IllegalArgumentException("Not valid IMR: " + name);
            }
        }
        attenRel.getParameter("Vs30").setValue(760.0);
        if (sigmaTrunc > 0.0) {
            attenRel.getParameter("Gaussian Truncation").setValue("1 Sided");
            attenRel.getParameter("Truncation Level").setValue(sigmaTrunc);
        } else {
            attenRel.getParameter("Gaussian Truncation").setValue("None");
        }
        return attenRel;
    }

    public static LocationList loadCSV(File file) throws IOException {
        LocationList locs = new LocationList();
        CSVFile<String> csv = CSVFile.readFile(file, true);
        for (int i = 0; i < csv.getNumRows(); ++i) {
            List<String> line = csv.getLine(i);
            if (line.get(0).equals("GRID_ID")) continue;
            int start = line.size() == 3 ? 1 : 0;
            double lat = Double.parseDouble(line.get(start));
            double lon = Double.parseDouble(line.get(start + 1));
            locs.add(new Location(lat, lon));
        }
        return locs;
    }

    public static ArrayList<Site> loadSites(List<SiteData<?>> provs, LocationList locs, List<ScalarIMR> imrs, boolean nullBasin, boolean constrainBasinMin, SiteDataValue<?> hardcodedVal) throws IOException {
        if (provs == null) {
            provs = new ArrayList();
        }
        if (constrainBasinMin) {
            for (SiteData<?> prov : provs) {
                if (!prov.getDataType().equals("Depth to Vs = 2.5 km/sec") && !prov.getDataType().equals("Depth to Vs = 1.0 km/sec")) continue;
                Parameter<Double> minBasinParam = null;
                try {
                    minBasinParam = prov.getAdjustableParameterList().getParameter(Double.class, "Minimum Basin Depth");
                }
                catch (ParameterException parameterException) {
                    // empty catch block
                }
                if (minBasinParam == null) continue;
                for (ScalarIMR imr : imrs) {
                    for (Parameter<?> param : imr.getSiteParams()) {
                        if (param.getName().equals("Depth 2.5 km/sec") && prov.getDataType().equals("Depth to Vs = 2.5 km/sec")) {
                            minBasinParam.setValue((Double)param.getValue());
                            continue;
                        }
                        if (!param.getName().equals("Depth 1.0 km/sec") || !prov.getDataType().equals("Depth to Vs = 1.0 km/sec")) continue;
                        Double minVal = (Double)param.getValue();
                        minVal = minVal * 1000.0;
                        minBasinParam.setValue(minVal);
                    }
                }
            }
        }
        ArrayList[] siteData = new ArrayList[locs.size()];
        if (hardcodedVal != null) {
            for (int i = 0; i < siteData.length; ++i) {
                siteData[i] = new ArrayList();
                siteData[i].add(hardcodedVal);
            }
        }
        for (SiteData<?> prov : provs) {
            SiteDataValueList<?> vals = prov.getAnnotatedValues(locs);
            for (int i = 0; i < siteData.length; ++i) {
                if (siteData[i] == null) {
                    siteData[i] = new ArrayList();
                }
                SiteDataValue<?> val = vals.getValue(i);
                siteData[i].add(val);
            }
        }
        SiteTranslator trans = new SiteTranslator();
        ArrayList<Site> sites = new ArrayList<Site>();
        for (int i = 0; i < locs.size(); ++i) {
            Location loc = (Location)locs.get(i);
            Site site = new Site(loc);
            ArrayList datas = siteData[i];
            for (ScalarIMR imr : imrs) {
                for (Parameter<?> siteParam : imr.getSiteParams()) {
                    if (site.containsParameter(siteParam)) continue;
                    Parameter clonedParam = (Parameter)siteParam.clone();
                    String paramName = siteParam.getName();
                    if (nullBasin && (paramName.equals("Depth 2.5 km/sec") || paramName.equals("Depth 1.0 km/sec"))) {
                        clonedParam.setValue(null);
                    } else {
                        trans.setParameterValue(clonedParam, datas);
                    }
                    site.addParameter(clonedParam);
                }
            }
            sites.add(site);
        }
        return sites;
    }

    public static void main(String[] args) throws IOException, InvocationTargetException {
        SiteDataValue<Double> hardcodedVal;
        if (args.length < 7 || args.length > 11) {
            System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(HazusJobWriter.class) + " <T/F: time dependent> <NSHMP08/MultiIMR/MultiIMRnoAS> <T/F: prop effect speedup> <T/F: back seis> <HardCoded Vs30 (or 'null'/'wald'/'nobasin' for site data providers)> <spacing> <dir name> [<sites per job>] (OR) [<minutes> <nodes> [<ppn> [<queue>]]]");
            System.exit(2);
        }
        boolean MPJ = args.length > 8;
        boolean timeDep = Boolean.parseBoolean(args[0]);
        String imrStr = args[1];
        boolean propEffectSpeedup = Boolean.parseBoolean(args[2]);
        boolean includeBackSeis = Boolean.parseBoolean(args[3]);
        String vs30Str = args[4];
        boolean noBasin = false;
        boolean useWald = false;
        if (vs30Str.equals("null")) {
            hardcodedVal = null;
        } else if (vs30Str.equalsIgnoreCase("wald")) {
            useWald = true;
            hardcodedVal = null;
        } else if (vs30Str.equalsIgnoreCase("nobasin")) {
            hardcodedVal = null;
            noBasin = true;
        } else {
            hardcodedVal = new SiteDataValue<Double>("Vs30", "Inferred", Double.parseDouble(vs30Str));
        }
        String dirName = args[6];
        int years = 50;
        int startYear = timeDep ? 2012 : -1;
        AbstractERF erf = HazusJobWriter.getERF(years, startYear, includeBackSeis);
        boolean nullBasin = true;
        double sigmaTrunc = 3.0;
        ScalarIMR imr = HazusJobWriter.getIMR(imrStr, sigmaTrunc, propEffectSpeedup);
        double spacing = Double.parseDouble(args[5]);
        int mins = Integer.parseInt(args[7]);
        int nodes = Integer.parseInt(args[8]);
        int ppn = args.length > 9 ? Integer.parseInt(args[9]) : 0;
        String queue = args.length > 10 ? args[10] : null;
        File hazMapsDir = new File("/home/scec-02/kmilner/hazMaps");
        HazusJobWriter.prepareJob(erf, imr, spacing, years, nullBasin, hardcodedVal, noBasin, useWald, dirName, mins, nodes, ppn, queue, hazMapsDir);
    }

    public static void prepareJob(AbstractERF erf, ScalarIMR imr, double spacing, int years, boolean nullBasin, SiteDataValue<?> hardcodedVal, boolean noBasin, boolean useWald, String dirName, int mins, int nodes, int ppn, String queue, File hazMapsDir) throws IOException, InvocationTargetException {
        Map<TectonicRegionType, ScalarIMR> imrMap = TRTUtils.wrapInHashMap(imr);
        ArrayList<Map<TectonicRegionType, ScalarIMR>> imrMaps = new ArrayList<Map<TectonicRegionType, ScalarIMR>>();
        imrMaps.add(imrMap);
        ListIterator<Parameter<?>> imrSiteParamsIt = imr.getSiteParamsIterator();
        while (imrSiteParamsIt.hasNext()) {
            Parameter param = (Parameter)imrSiteParamsIt.next();
            String paramName = param.getName();
            if (!nullBasin || !paramName.equals("Depth 2.5 km/sec") && !paramName.equals("Depth 1.0 km/sec")) continue;
            param.setValue(null);
        }
        String spacingCode = "" + (int)(spacing * 100.0);
        if (spacingCode.length() < 2) {
            spacingCode = "0" + spacingCode;
        }
        File spacingFile = new File(hazMapsDir, spacingCode + "grid.csv");
        LocationList locs = HazusJobWriter.loadCSV(spacingFile);
        ArrayList<AbstractSiteData> provs = null;
        if (hardcodedVal == null) {
            provs = new ArrayList<AbstractSiteData>();
            SiteDataTypeParameterNameMap siteDataMap = SiteTranslator.DATA_TYPE_PARAM_NAME_MAP;
            if (useWald) {
                System.out.println("Using WALD/ALLEN!");
                if (siteDataMap.isTypeApplicable("Vs30", imr)) {
                    provs.add(new WaldAllenGlobalVs30());
                }
            } else if (siteDataMap.isTypeApplicable("Vs30", imr)) {
                provs.add(new WillsMap2006());
            }
            if (!noBasin) {
                if (siteDataMap.isTypeApplicable("Depth to Vs = 2.5 km/sec", imr)) {
                    provs.add(new CVM4BasinDepth("Depth to Vs = 2.5 km/sec"));
                }
                if (siteDataMap.isTypeApplicable("Depth to Vs = 1.0 km/sec", imr)) {
                    provs.add(new CVM4BasinDepth("Depth to Vs = 1.0 km/sec"));
                }
            }
        }
        ArrayList[] siteData = new ArrayList[locs.size()];
        if (hardcodedVal == null) {
            for (SiteData siteData2 : provs) {
                SiteDataValueList vals = siteData2.getAnnotatedValues(locs);
                for (int i = 0; i < siteData.length; ++i) {
                    if (siteData[i] == null) {
                        siteData[i] = new ArrayList();
                    }
                    SiteDataValue val = vals.getValue(i);
                    siteData[i].add(val);
                }
            }
        } else {
            for (int i = 0; i < siteData.length; ++i) {
                siteData[i] = new ArrayList();
                siteData[i].add(hardcodedVal);
            }
        }
        SiteTranslator trans = new SiteTranslator();
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (int i = 0; i < locs.size(); ++i) {
            Location loc = (Location)locs.get(i);
            Site site = new Site(loc);
            ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
            ArrayList datas = siteData[i];
            while (it.hasNext()) {
                Parameter<?> siteParam = it.next();
                Parameter clonedParam = (Parameter)siteParam.clone();
                String paramName = siteParam.getName();
                trans.setParameterValue(clonedParam, datas);
                site.addParameter(clonedParam);
            }
            arrayList.add(site);
        }
        IMT_Info imtInfo = new IMT_Info();
        HashMap<String, DiscretizedFunc> imtXValMap = new HashMap<String, DiscretizedFunc>();
        imtXValMap.put("PGA", imtInfo.getDefaultHazardCurve("PGA"));
        if (imr.isIntensityMeasureSupported("PGV")) {
            imtXValMap.put("PGV", imtInfo.getDefaultHazardCurve("PGV"));
        }
        imtXValMap.put("SA", imtInfo.getDefaultHazardCurve("SA"));
        CalculationSettings calcSet = new CalculationSettings(imtXValMap, 200.0);
        File jobDir = new File(hazMapsDir, dirName);
        String curveDir = new File(jobDir, "curves").getAbsolutePath() + File.separator;
        AsciiFileCurveArchiver archiver = new AsciiFileCurveArchiver(curveDir, true, false);
        File javaBin = USC_HPCC_ScriptWriter.JAVA_BIN;
        File svnDir = new File(hazMapsDir, "svn");
        File distDir = new File(svnDir, "dist");
        File libDir = new File(svnDir, "lib");
        File jarFile = new File(distDir, "OpenSHA_complete.jar");
        HazusDataSetDAGCreator dag = new HazusDataSetDAGCreator(erf, imrMaps, arrayList, calcSet, archiver, javaBin.getAbsolutePath(), jarFile.getAbsolutePath(), years, spacing);
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(jarFile);
        classpath.add(new File(libDir, "commons-cli-1.2.jar"));
        classpath.add(new File(libDir, "parallelcolt-0.9.4.jar"));
        classpath.add(new File(libDir, "csparsej.jar"));
        FastMPJShellScriptWriter mpj = new FastMPJShellScriptWriter(javaBin, 8000, classpath, USC_HPCC_ScriptWriter.FMPJ_HOME);
        ArrayList<Parameter<Double>> imts = HazusDataSetDAGCreator.getIMTList(imrMaps);
        CalculationInputsXMLFile inputs = new CalculationInputsXMLFile(erf, HazusDataSetDAGCreator.getHAZUSMaps(imrMaps), imts, arrayList, calcSet, archiver);
        jobDir.mkdir();
        File inputsFile = new File(jobDir, "inputs.xml");
        XMLUtils.writeObjectToXMLAsRoot(inputs, inputsFile);
        String cliArgs = inputsFile.getAbsolutePath();
        List<String> script = mpj.buildScript(MPJHazardCurveDriver.class.getName(), cliArgs);
        USC_HPCC_ScriptWriter writer = new USC_HPCC_ScriptWriter();
        script = writer.buildScript(script, mins, nodes, ppn, queue);
        JavaShellScriptWriter assembleWriter = new JavaShellScriptWriter(javaBin, 2048, classpath);
        String metadataFile = dag.writeMetadataFile(jobDir.getAbsolutePath());
        String assembleArgs = archiver.getStoreDir().getPath() + " " + years + " " + metadataFile;
        String assembleCommand = assembleWriter.buildCommand(HazusDataSetAssmbler.class.getName(), assembleArgs);
        String exitLine = script.remove(script.size() - 1);
        script.addAll(assembleWriter.getAllSetupLines());
        script.add(assembleCommand);
        script.add("");
        script.add(exitLine);
        if (dirName.startsWith("20") && dirName.contains("-")) {
            dirName = dirName.substring(dirName.indexOf("-") + 1);
        }
        File pbsFile = new File(jobDir, dirName + ".pbs");
        JavaShellScriptWriter.writeScript(pbsFile, script);
    }
}

