/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.cybershake.maps;

import java.io.Serializable;
import java.text.DecimalFormat;

public class GMT_InterpolationSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double interpSpacing;
    private double interiorTension;
    private double exteriorTension;
    private double convergenceLimit;
    private double searchRadius;
    private boolean saveInterpSurface = false;
    public static final String INTERP_XYZ_FILE_NAME = "map_data_interpolated.txt";

    public static GMT_InterpolationSettings getDefaultSettings() {
        return new GMT_InterpolationSettings(0.02, 0.0, 0.1, -1.0, 20.0);
    }

    public GMT_InterpolationSettings(double interpSpacing, double interiorTension, double exteriorTension, double convergenceLimit, double searchRadius) {
        this.interpSpacing = interpSpacing;
        this.interiorTension = interiorTension;
        this.exteriorTension = exteriorTension;
        this.convergenceLimit = convergenceLimit;
        this.searchRadius = searchRadius;
    }

    public double getInterpSpacing() {
        return this.interpSpacing;
    }

    public void setInterpSpacing(double interpSpacing) {
        this.interpSpacing = interpSpacing;
    }

    public double getInteriorTension() {
        return this.interiorTension;
    }

    public void setInteriorTension(double interiorTension) {
        this.interiorTension = interiorTension;
    }

    public double getExteriorTension() {
        return this.exteriorTension;
    }

    public void setExteriorTension(double exteriorTension) {
        this.exteriorTension = exteriorTension;
    }

    public String getTensionArg() {
        return "-T" + (float)this.getInteriorTension() + "i" + (float)this.getExteriorTension() + "b";
    }

    public double getConvergenceLimit() {
        return this.convergenceLimit;
    }

    public void setConvergenceLimit(double convergenceLimit) {
        this.convergenceLimit = convergenceLimit;
    }

    public String getConvergenceArg() {
        if (this.convergenceLimit <= 0.0) {
            return "";
        }
        return "-C" + (float)this.convergenceLimit;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    public String getSearchArg() {
        return "-S" + new DecimalFormat("0.#").format(this.getSearchRadius()) + "m";
    }

    public boolean isSaveInterpSurface() {
        return this.saveInterpSurface;
    }

    public void setSaveInterpSurface(boolean saveInterpSurface) {
        this.saveInterpSurface = saveInterpSurface;
    }
}

