/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.util.TectonicRegionType;

public class ERFSubset
implements ERF {
    private static final long serialVersionUID = 1L;
    HashMap<Integer, Integer> sourceIDMap = new HashMap();
    private ERF baseERF;

    public ERFSubset(ERF baseERF) {
        this.baseERF = baseERF;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.baseERF.getAdjustableParameterList();
    }

    @Override
    public Region getApplicableRegion() {
        return this.baseERF.getApplicableRegion();
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        return this.baseERF.getIncludedTectonicRegionTypes();
    }

    @Override
    public String getName() {
        return this.baseERF.getName() + "_TEST";
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.baseERF.getTimeSpan();
    }

    @Override
    public void setParameter(String name, Object value) {
        this.baseERF.setParameter(name, value);
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
        this.baseERF.setTimeSpan(time);
    }

    @Override
    public void updateForecast() {
        this.baseERF.updateForecast();
    }

    @Override
    public List<EqkRupture> drawRandomEventSet(Site site, Collection<SourceFilter> sourceFilters) {
        throw new RuntimeException("WARNING: drawRandomEventSet not implemented for subset ERF!");
    }

    @Override
    public int getNumRuptures(int iSource) {
        return this.baseERF.getNumRuptures(this.getBaseSourceID(iSource));
    }

    @Override
    public int getNumSources() {
        return this.sourceIDMap.size();
    }

    @Override
    public ProbEqkRupture getRupture(int iSource, int nRupture) {
        return this.baseERF.getRupture(this.getBaseSourceID(iSource), nRupture);
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return this.baseERF.getSource(this.getBaseSourceID(iSource));
    }

    private int getBaseSourceID(int sourceID) {
        return this.sourceIDMap.get(sourceID);
    }

    public ArrayList<ProbEqkSource> getSourceList() {
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        for (int i = 0; i < this.getNumSources(); ++i) {
            sources.add(this.getSource(i));
        }
        return sources;
    }

    public void includeSource(int sourceID) {
        if (this.sourceIDMap.containsValue(sourceID)) {
            System.out.println("source " + sourceID + " already included!");
            return;
        }
        if (sourceID < 0 || sourceID >= this.baseERF.getNumSources()) {
            throw new IndexOutOfBoundsException("source ID to include is out of bounds!");
        }
        int newID = this.getNumSources();
        this.sourceIDMap.put(newID, sourceID);
    }

    public void includeAllExcept(int sourceID) {
        for (int i = 0; i < this.baseERF.getNumSources(); ++i) {
            if (i == sourceID) continue;
            this.includeSource(i);
        }
    }

    public ProbEqkSource getOrigSource(int sourceID) {
        return this.baseERF.getSource(sourceID);
    }

    @Override
    public int compareTo(BaseERF o) {
        return this.baseERF.compareTo(o);
    }

    @Override
    public Iterator<ProbEqkSource> iterator() {
        return ((ArrayList)this.getSourceList()).iterator();
    }
}

