/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.SiteAdaptiveSource;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.util.GridCellSuperSamplingPoissonPointSourceData;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.TectonicRegionType;

public abstract class PointSource
extends ProbEqkSource {
    private Location loc;
    private PointSurface pointSurf;
    private LocationList sourceLocs;
    protected WeightedList<PointSourceDistanceCorrection> distCorrs;

    public PointSource(Location loc) {
        this(loc, TECTONIC_REGION_TYPE_DEFAULT, null);
    }

    public PointSource(Location loc, TectonicRegionType tectonicRegionType, WeightedList<PointSourceDistanceCorrection> distCorrs) {
        this.loc = loc;
        this.setTectonicRegionType(tectonicRegionType);
        this.setDistCorrs(distCorrs);
    }

    public WeightedList<PointSourceDistanceCorrection> getDistCorrs() {
        return this.distCorrs;
    }

    public void setDistCorrs(WeightedList<PointSourceDistanceCorrection> distCorrs) {
        if (distCorrs != null && !(distCorrs instanceof WeightedList.Unmodifiable)) {
            distCorrs = new WeightedList.Unmodifiable<PointSourceDistanceCorrection>(distCorrs);
        }
        this.distCorrs = distCorrs;
    }

    @Override
    public LocationList getAllSourceLocs() {
        if (this.sourceLocs == null) {
            LocationList sourceLocs = new LocationList(1);
            sourceLocs.add(this.loc);
            this.sourceLocs = sourceLocs;
        }
        return this.sourceLocs;
    }

    @Override
    public RuptureSurface getSourceSurface() {
        if (this.pointSurf == null) {
            this.pointSurf = new PointSurface(this.loc);
        }
        return this.pointSurf;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistanceFast(this.loc, site.getLocation());
    }

    public Location getLocation() {
        return this.loc;
    }

    public static PoissonPointSourceData dataForMFD(Location loc, final IncrementalMagFreqDist mfd, FocalMechanism mech, RuptureSurfaceBuilder surfaceBuilder) {
        final Set<FocalMechanism> mechs = Set.of(mech);
        MFDData data = new MFDData(){

            @Override
            public Set<FocalMechanism> mechanisms() {
                return mechs;
            }

            @Override
            public int size(FocalMechanism mech) {
                return mfd.size();
            }

            @Override
            public double magnitude(FocalMechanism mech, int index) {
                return mfd.getX(index);
            }

            @Override
            public double rate(FocalMechanism mech, int index) {
                return mfd.getY(index);
            }
        };
        return new MFDPoissonPointSourceData(loc, data, surfaceBuilder);
    }

    public static <E> PoissonPointSourceData dataForMFDs(Location loc, final IncrementalMagFreqDist mfd, final Map<FocalMechanism, Double> weights, RuptureSurfaceBuilder surfaceBuilder) {
        double weightSum = 0.0;
        for (FocalMechanism mech : weights.keySet()) {
            double weight = weights.get(mech);
            Preconditions.checkState((weight >= 0.0 && weight <= 1.0 ? 1 : 0) != 0, (String)"Bad weight for %s: %s", (Object)mech, (Object)weight);
            weightSum += weight;
        }
        Preconditions.checkState((boolean)Precision.equals((double)weightSum, (double)1.0, (double)0.001), (String)"FocalMech weights don't sum to 1: %s", (Object)Float.valueOf((float)weightSum));
        MFDData data = new MFDData(){

            @Override
            public Set<FocalMechanism> mechanisms() {
                return weights.keySet();
            }

            @Override
            public int size(FocalMechanism mech) {
                return mfd.size();
            }

            @Override
            public double magnitude(FocalMechanism mech, int index) {
                return mfd.getX(index);
            }

            @Override
            public double rate(FocalMechanism mech, int index) {
                return mfd.getY(index) * (Double)weights.get(mech);
            }
        };
        return new MFDPoissonPointSourceData(loc, data, surfaceBuilder);
    }

    public static <E> PoissonPointSourceData dataForMFDs(Location loc, final Map<FocalMechanism, IncrementalMagFreqDist> mfds, RuptureSurfaceBuilder surfaceBuilder) {
        MFDData data = new MFDData(){

            @Override
            public Set<FocalMechanism> mechanisms() {
                return mfds.keySet();
            }

            @Override
            public int size(FocalMechanism mech) {
                return ((IncrementalMagFreqDist)mfds.get(mech)).size();
            }

            @Override
            public double magnitude(FocalMechanism mech, int index) {
                return ((IncrementalMagFreqDist)mfds.get(mech)).getX(index);
            }

            @Override
            public double rate(FocalMechanism mech, int index) {
                return ((IncrementalMagFreqDist)mfds.get(mech)).getY(index);
            }
        };
        return new MFDPoissonPointSourceData(loc, data, surfaceBuilder);
    }

    public static <E> PoissonPointSourceData dataForMagRate(Location loc, final double magnitude, final double rate, FocalMechanism mech, RuptureSurfaceBuilder surfaceBuilder) {
        final Set<FocalMechanism> set = Set.of(mech);
        MFDData data = new MFDData(){

            @Override
            public Set<FocalMechanism> mechanisms() {
                return set;
            }

            @Override
            public int size(FocalMechanism mech) {
                return 1;
            }

            @Override
            public double magnitude(FocalMechanism mech, int index) {
                return magnitude;
            }

            @Override
            public double rate(FocalMechanism mech, int index) {
                return rate;
            }
        };
        return new MFDPoissonPointSourceData(loc, data, surfaceBuilder);
    }

    public static <E> PoissonPointSourceData dataForMagRates(Location loc, final double magnitude, final Map<FocalMechanism, Double> ruptureRates, RuptureSurfaceBuilder surfaceBuilder) {
        MFDData data = new MFDData(){

            @Override
            public Set<FocalMechanism> mechanisms() {
                return ruptureRates.keySet();
            }

            @Override
            public int size(FocalMechanism mech) {
                return 1;
            }

            @Override
            public double magnitude(FocalMechanism mech, int index) {
                return magnitude;
            }

            @Override
            public double rate(FocalMechanism mech, int index) {
                return (Double)ruptureRates.get(mech);
            }
        };
        return new MFDPoissonPointSourceData(loc, data, surfaceBuilder);
    }

    public static PoissonPointSourceData dataForHypoMFDs(HypoMagFreqDistAtLoc hypoMFDs, RuptureSurfaceBuilder surfaceBuilder) {
        FocalMechanism[] mechs = hypoMFDs.getFocalMechanismList();
        IncrementalMagFreqDist[] mfds = hypoMFDs.getMagFreqDistList();
        Preconditions.checkNotNull((Object)mechs, (Object)"Mechanisms can't be null");
        Preconditions.checkNotNull((Object)mfds, (Object)"MFDs can't be null");
        Preconditions.checkState((mfds.length > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 MFD");
        Preconditions.checkState((mfds.length == mechs.length ? 1 : 0) != 0, (Object)"Mech and MFD size mismatch");
        HashMap<FocalMechanism, IncrementalMagFreqDist> map = new HashMap<FocalMechanism, IncrementalMagFreqDist>(mechs.length);
        for (int i = 0; i < mechs.length; ++i) {
            Preconditions.checkNotNull((Object)mechs[i], (String)"Mechanism %s is null", (int)i);
            Preconditions.checkNotNull((Object)mfds[i], (String)"MFD %s is null", (int)i);
            Preconditions.checkState((map.put(mechs[i], mfds[i]) == null ? 1 : 0) != 0, (String)"Duplicate FocalMechanism encountered at %s", (int)i);
        }
        return PointSource.dataForMFDs(hypoMFDs.getLocation(), map, surfaceBuilder);
    }

    public static RuptureSurfaceBuilder truePointSurfaceGenerator(double depth) {
        return new TruePointSurfaceGenerator(depth);
    }

    public static NonPoissonBuilder nonPoissonBuilder(Location loc) {
        return new NonPoissonBuilder(loc);
    }

    public static NonPoissonBuilder nonPoissonBuilder(Location loc, TectonicRegionType trt) {
        return (NonPoissonBuilder)new NonPoissonBuilder(loc).tectonicRegionType(trt);
    }

    public static PoissonBuilder poissonBuilder(Location loc) {
        return new PoissonBuilder(loc);
    }

    public static PoissonBuilder poissonBuilder(Location loc, TectonicRegionType trt) {
        return (PoissonBuilder)new PoissonBuilder(loc).tectonicRegionType(trt);
    }

    private static class MFDPoissonPointSourceData
    implements PoissonPointSourceData {
        private Location loc;
        private RuptureSurfaceBuilder surfaceBuilder;
        private final double[] magnitudes;
        private final double[] rates;
        private final short[] surfIndexes;
        private final FocalMechanism[] mechs;
        private final int numRuptures;

        private MFDPoissonPointSourceData(Location loc, MFDData mfdData, RuptureSurfaceBuilder surfaceBuilder) {
            this.loc = loc;
            this.surfaceBuilder = surfaceBuilder;
            int numRups = 0;
            boolean anyMultiple = false;
            for (FocalMechanism mech : mfdData.mechanisms()) {
                int size = mfdData.size(mech);
                for (int m = 0; m < size; ++m) {
                    double rate = mfdData.rate(mech, m);
                    if (rate == 0.0) continue;
                    double mag = mfdData.magnitude(mech, m);
                    int magDataCount = surfaceBuilder.getNumSurfaces(mag, mech);
                    Preconditions.checkState((magDataCount > 0 ? 1 : 0) != 0, (String)"Surface count is %s for mech=%s and mag=%s", (Object)magDataCount, (Object)mech, (Object)mag);
                    numRups += magDataCount;
                    anyMultiple |= magDataCount > 1;
                }
            }
            this.magnitudes = new double[numRups];
            this.rates = new double[numRups];
            this.mechs = new FocalMechanism[numRups];
            this.surfIndexes = anyMultiple ? new short[numRups] : null;
            int index = 0;
            for (FocalMechanism mech : mfdData.mechanisms()) {
                int size = mfdData.size(mech);
                for (int m = 0; m < size; ++m) {
                    double rate = mfdData.rate(mech, m);
                    if (rate == 0.0) continue;
                    double mag = mfdData.magnitude(mech, m);
                    int magMechCount = surfaceBuilder.getNumSurfaces(mag, mech);
                    for (int i = 0; i < magMechCount; ++i) {
                        this.rates[index] = magMechCount == 1 ? rate : rate * surfaceBuilder.getSurfaceWeight(mag, mech, i);
                        this.magnitudes[index] = mag;
                        this.mechs[index] = mech;
                        if (anyMultiple) {
                            this.surfIndexes[index] = (short)i;
                        }
                        ++index;
                    }
                }
            }
            Preconditions.checkState((index == numRups ? 1 : 0) != 0);
            this.numRuptures = numRups;
        }

        @Override
        public int getNumRuptures() {
            return this.numRuptures;
        }

        @Override
        public double getMagnitude(int rupIndex) {
            return this.magnitudes[rupIndex];
        }

        @Override
        public double getAveRake(int rupIndex) {
            return this.mechs[rupIndex].getRake();
        }

        @Override
        public double getRate(int rupIndex) {
            return this.rates[rupIndex];
        }

        @Override
        public RuptureSurface getSurface(int rupIndex) {
            return this.surfaceBuilder.getSurface(this.loc, this.magnitudes[rupIndex], this.mechs[rupIndex], this.surfIndexes == null ? 0 : this.surfIndexes[rupIndex]);
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
            return this.surfaceBuilder.getHypocenter(sourceLoc, rupSurface);
        }

        @Override
        public boolean isFinite(int rupIndex) {
            return this.surfaceBuilder.isSurfaceFinite(this.magnitudes[rupIndex], this.mechs[rupIndex], this.surfIndexes == null ? 0 : this.surfIndexes[rupIndex]);
        }
    }

    private static interface MFDData {
        public Set<FocalMechanism> mechanisms();

        public int size(FocalMechanism var1);

        public double magnitude(FocalMechanism var1, int var2);

        public double rate(FocalMechanism var1, int var2);
    }

    public static interface RuptureSurfaceBuilder {
        public int getNumSurfaces(double var1, FocalMechanism var3);

        public RuptureSurface getSurface(Location var1, double var2, FocalMechanism var4, int var5);

        public double getSurfaceWeight(double var1, FocalMechanism var3, int var4);

        public boolean isSurfaceFinite(double var1, FocalMechanism var3, int var4);

        default public WeightedList<RuptureSurface> getSurfaces(Location sourceLoc, double magnitude, FocalMechanism mech) {
            int num = this.getNumSurfaces(magnitude, mech);
            if (num == 1) {
                return WeightedList.evenlyWeighted(this.getSurface(sourceLoc, magnitude, mech, 0));
            }
            WeightedList<RuptureSurface> ret = new WeightedList<RuptureSurface>(num);
            for (int i = 0; i < num; ++i) {
                ret.add(this.getSurface(sourceLoc, magnitude, mech, i), this.getSurfaceWeight(magnitude, mech, i));
            }
            Preconditions.checkState((boolean)ret.isNormalized(), (String)"Surface weights aren't normalized for mag=%s, mech=%s", (Object)magnitude, (Object)mech);
            return ret;
        }

        public Location getHypocenter(Location var1, RuptureSurface var2);
    }

    public static interface PoissonPointSourceData
    extends PointSourceData {
        public double getRate(int var1);
    }

    private static class TruePointSurfaceGenerator
    implements RuptureSurfaceBuilder {
        private double depth;

        public TruePointSurfaceGenerator(double depth) {
            this.depth = depth;
        }

        @Override
        public int getNumSurfaces(double magnitude, FocalMechanism mech) {
            return 1;
        }

        @Override
        public RuptureSurface getSurface(Location loc, double magnitude, FocalMechanism mech, int surfaceIndex) {
            loc = new Location(loc.lat, loc.lon, this.depth);
            PointSurface surf = new PointSurface(loc);
            surf.setAveDip(mech.getDip());
            return surf;
        }

        @Override
        public double getSurfaceWeight(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return 1.0;
        }

        @Override
        public boolean isSurfaceFinite(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return false;
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface) {
            return sourceLoc;
        }
    }

    public static class NonPoissonBuilder
    extends AbstractBuilder<NonPoissonPointSourceData, NonPoissonBuilder> {
        private NonPoissonBuilder(Location loc) {
            super(loc);
        }

        public NonPoissonBuilder forMagProbAndFocalMech(double magnitude, double prob, FocalMechanism mech) {
            this.checkHasSurfBuilder();
            return (NonPoissonBuilder)this.data(new RupListNonPoissonPointSourceData(this.loc, List.of(new NonPoissonPointRupture(magnitude, prob, mech)), this.surfaceBuilder));
        }

        public NonPoissonBuilder forMagProbAndFocalMech(List<Double> magnitudes, List<Double> probs, List<FocalMechanism> mechs) {
            this.checkHasSurfBuilder();
            Preconditions.checkState((magnitudes.size() == probs.size() ? 1 : 0) != 0);
            Preconditions.checkState((magnitudes.size() == mechs.size() ? 1 : 0) != 0);
            ArrayList<NonPoissonPointRupture> rups = new ArrayList<NonPoissonPointRupture>(magnitudes.size());
            for (int i = 0; i < magnitudes.size(); ++i) {
                rups.add(new NonPoissonPointRupture(magnitudes.get(i), probs.get(i), mechs.get(i)));
            }
            return (NonPoissonBuilder)this.data(new RupListNonPoissonPointSourceData(this.loc, rups, this.surfaceBuilder));
        }

        public NonPoissonPointSource build() {
            this.checkValidLocAndData();
            if (this.data instanceof SiteAdaptivePointSourceData) {
                return new SiteAdaptiveNonPoissonPointSourceImpl<SiteAdaptivePointSourceData>(this.loc, this.trt, (SiteAdaptivePointSourceData)((Object)((NonPoissonPointSourceData)this.data)), (WeightedList<PointSourceDistanceCorrection>)this.distCorrs);
            }
            return new NonPoissonPointSource(this.loc, this.trt, (NonPoissonPointSourceData)this.data, (WeightedList<PointSourceDistanceCorrection>)this.distCorrs);
        }
    }

    public static class AbstractBuilder<E extends PointSourceData, B extends AbstractBuilder<E, B>> {
        protected Location loc;
        protected RuptureSurfaceBuilder surfaceBuilder;
        protected E data;
        protected TectonicRegionType trt = ProbEqkSource.TECTONIC_REGION_TYPE_DEFAULT;
        protected WeightedList<PointSourceDistanceCorrection> distCorrs;

        private AbstractBuilder(Location loc) {
            this.loc = loc;
        }

        public B tectonicRegionType(TectonicRegionType trt) {
            this.trt = trt;
            return this.castThis();
        }

        private B castThis() {
            return (B)this;
        }

        public B data(E data) {
            this.data = data;
            return this.castThis();
        }

        public B surfaceBuilder(RuptureSurfaceBuilder surfaceBuilder) {
            this.surfaceBuilder = surfaceBuilder;
            return this.castThis();
        }

        public B truePointSources() {
            return this.truePointSources(this.loc.depth);
        }

        public B truePointSources(double depth) {
            return this.surfaceBuilder(PointSource.truePointSurfaceGenerator(depth));
        }

        protected void checkHasSurfBuilder() {
            Preconditions.checkState((this.surfaceBuilder != null ? 1 : 0) != 0, (Object)"Must supply RuptureSurfaceBuilder first");
        }

        public B distCorrs(PointSourceDistanceCorrections distCorrs) {
            if (distCorrs == null) {
                this.distCorrs = null;
                return this.castThis();
            }
            return this.distCorrs((WeightedList<PointSourceDistanceCorrection>)distCorrs.get());
        }

        public B distCorrs(WeightedList<PointSourceDistanceCorrection> distCorrs) {
            Preconditions.checkState((distCorrs == null || !distCorrs.isEmpty() && distCorrs.isNormalized() ? 1 : 0) != 0);
            this.distCorrs = distCorrs;
            return this.castThis();
        }

        protected void checkValidLocAndData() {
            Preconditions.checkState((this.loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
            Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Point source data cannot be null");
        }
    }

    public static class PoissonBuilder
    extends AbstractBuilder<PoissonPointSourceData, PoissonBuilder> {
        private double duration = Double.NaN;

        private PoissonBuilder(Location loc) {
            super(loc);
        }

        public PoissonBuilder duration(double duration) {
            Preconditions.checkState((Double.isFinite(duration) && duration > 0.0 ? 1 : 0) != 0, (Object)"Duration must be finite and >0");
            this.duration = duration;
            return this;
        }

        public PoissonBuilder forMagRateAndFocalMech(double magnitude, double rate, FocalMechanism mech) {
            this.checkHasSurfBuilder();
            return (PoissonBuilder)this.data(PointSource.dataForMagRate(this.loc, magnitude, rate, mech, this.surfaceBuilder));
        }

        public PoissonBuilder forMFDAndFocalMech(IncrementalMagFreqDist mfd, FocalMechanism mech) {
            this.checkHasSurfBuilder();
            return (PoissonBuilder)this.data(PointSource.dataForMFD(this.loc, mfd, mech, this.surfaceBuilder));
        }

        public <E> PoissonBuilder forMFDsAndFocalMechs(IncrementalMagFreqDist mfd, Map<FocalMechanism, Double> mechWeights) {
            this.checkHasSurfBuilder();
            return (PoissonBuilder)this.data(PointSource.dataForMFDs(this.loc, mfd, mechWeights, this.surfaceBuilder));
        }

        public <E> PoissonBuilder forMFDsAndFocalMechs(Map<FocalMechanism, IncrementalMagFreqDist> mfds) {
            this.checkHasSurfBuilder();
            return (PoissonBuilder)this.data(PointSource.dataForMFDs(this.loc, mfds, this.surfaceBuilder));
        }

        public PoissonBuilder siteAdaptiveSupersampled(Region gridCell, GridCellSupersamplingSettings supersampleSettings) {
            Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Must set point source data first");
            this.data = new GridCellSuperSamplingPoissonPointSourceData((PoissonPointSourceData)this.data, this.loc, gridCell, supersampleSettings);
            return this;
        }

        public PoissonBuilder siteAdaptiveSupersampled(Region gridCell, double targetSpacingKM, double fullDist, double borderDist, double cornerDist, boolean applyToFinite) {
            Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Must set point source data first");
            this.data = new GridCellSuperSamplingPoissonPointSourceData((PoissonPointSourceData)this.data, this.loc, gridCell, targetSpacingKM, fullDist, borderDist, cornerDist, applyToFinite);
            return this;
        }

        public PoissonPointSource build() {
            this.checkValidLocAndData();
            Preconditions.checkState((Double.isFinite(this.duration) && this.duration > 0.0 ? 1 : 0) != 0, (Object)"Must set duration");
            if (this.data instanceof SiteAdaptivePointSourceData) {
                return new SiteAdaptivePoissonPointSourceImpl<SiteAdaptivePointSourceData>(this.loc, this.trt, this.duration, (SiteAdaptivePointSourceData)((Object)((PoissonPointSourceData)this.data)), (WeightedList<PointSourceDistanceCorrection>)this.distCorrs);
            }
            return new PoissonPointSource(this.loc, this.trt, this.duration, (PoissonPointSourceData)this.data, this.distCorrs);
        }
    }

    private static class RupListNonPoissonPointSourceData
    implements NonPoissonPointSourceData {
        private Location loc;
        private List<NonPoissonPointRupture> ruptures;
        private RuptureSurfaceBuilder surfaceBuilder;
        private final int numRuptures;
        private final short[] rupIndexes;
        private final short[] surfIndexes;

        public RupListNonPoissonPointSourceData(Location loc, List<NonPoissonPointRupture> ruptures, RuptureSurfaceBuilder surfaceBuilder) {
            this.loc = loc;
            this.ruptures = ruptures;
            this.surfaceBuilder = surfaceBuilder;
            int numRuptures = 0;
            boolean anyMultiple = false;
            for (NonPoissonPointRupture rup : ruptures) {
                if (!(rup.probability > 0.0)) continue;
                int surfCount = surfaceBuilder.getNumSurfaces(rup.magnitude, rup.mechanism);
                Preconditions.checkState((surfCount > 0 && surfCount < Short.MAX_VALUE ? 1 : 0) != 0);
                anyMultiple |= surfCount > 1;
                numRuptures += surfCount;
            }
            Preconditions.checkState((numRuptures > 0 ? 1 : 0) != 0, (Object)"No ruptures?");
            Preconditions.checkState((ruptures.size() < Short.MAX_VALUE ? 1 : 0) != 0);
            short[] rupIndexes = new short[numRuptures];
            short[] surfIndexes = anyMultiple ? new short[numRuptures] : null;
            int index = 0;
            for (int r = 0; r < ruptures.size(); ++r) {
                NonPoissonPointRupture rup = ruptures.get(r);
                if (!(rup.probability > 0.0)) continue;
                int surfCount = surfaceBuilder.getNumSurfaces(rup.magnitude, rup.mechanism);
                for (int s = 0; s < surfCount; ++s) {
                    rupIndexes[index] = (short)r;
                    if (anyMultiple) {
                        surfIndexes[index] = (short)s;
                    }
                    ++index;
                }
            }
            Preconditions.checkState((index == numRuptures ? 1 : 0) != 0);
            this.rupIndexes = rupIndexes;
            this.surfIndexes = surfIndexes;
            this.numRuptures = numRuptures;
        }

        @Override
        public int getNumRuptures() {
            return this.numRuptures;
        }

        @Override
        public double getMagnitude(int rupIndex) {
            return this.ruptures.get((int)this.rupIndexes[rupIndex]).magnitude;
        }

        @Override
        public double getAveRake(int rupIndex) {
            return this.ruptures.get((int)this.rupIndexes[rupIndex]).mechanism.getRake();
        }

        @Override
        public RuptureSurface getSurface(int rupIndex) {
            NonPoissonPointRupture rupture = this.ruptures.get(this.rupIndexes[rupIndex]);
            return this.surfaceBuilder.getSurface(this.loc, rupture.magnitude, rupture.mechanism, this.surfIndexes == null ? 0 : this.surfIndexes[rupIndex]);
        }

        @Override
        public boolean isFinite(int rupIndex) {
            NonPoissonPointRupture rupture = this.ruptures.get(this.rupIndexes[rupIndex]);
            return this.surfaceBuilder.isSurfaceFinite(rupture.magnitude, rupture.mechanism, this.surfIndexes == null ? 0 : this.surfIndexes[rupIndex]);
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
            return this.surfaceBuilder.getHypocenter(sourceLoc, rupSurface);
        }

        @Override
        public double getProbability(int rupIndex) {
            return this.ruptures.get((int)this.rupIndexes[rupIndex]).probability;
        }
    }

    private static class NonPoissonPointRupture {
        public final double magnitude;
        public final double probability;
        public final FocalMechanism mechanism;

        private NonPoissonPointRupture(double magnitude, double probability, FocalMechanism mechanism) {
            this.magnitude = magnitude;
            this.probability = probability;
            this.mechanism = mechanism;
        }
    }

    private static class SiteAdaptivePoissonPointSourceImpl<E extends SiteAdaptivePointSourceData<PoissonPointSourceData> & PoissonPointSourceData>
    extends PoissonPointSource
    implements SiteAdaptiveSource {
        private E data;
        private ConcurrentMap<PoissonPointSourceData, PoissonPointSource> sourceCache;

        public SiteAdaptivePoissonPointSourceImpl(Location loc, TectonicRegionType tectonicRegionType, double duration, E data, WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super(loc, tectonicRegionType, duration, (PoissonPointSourceData)data, distCorrs);
            this.data = data;
            if (data.isDiscrete()) {
                this.sourceCache = new ConcurrentHashMap<PoissonPointSourceData, PoissonPointSource>();
            }
        }

        @Override
        public void setDistCorrs(WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super.setDistCorrs((WeightedList)distCorrs);
            if (this.sourceCache != null) {
                this.sourceCache.clear();
            }
        }

        @Override
        public PoissonPointSource getForSite(Site site) {
            PoissonPointSourceData dataForSite = (PoissonPointSourceData)this.data.getForSite(site);
            if (dataForSite == this.data) {
                return this;
            }
            PoissonPointSource ret = null;
            if (this.sourceCache != null && (ret = (PoissonPointSource)this.sourceCache.get(dataForSite)) != null) {
                return ret;
            }
            ret = new PoissonPointSource(this.getLocation(), this.getTectonicRegionType(), this.getDuration(), dataForSite, this.getDistCorrs());
            if (this.sourceCache != null) {
                this.sourceCache.putIfAbsent(dataForSite, ret);
            }
            return ret;
        }
    }

    public static class PoissonPointSource
    extends BaseImplementation<PoissonPointSourceData> {
        private double duration;

        public PoissonPointSource(Location loc, TectonicRegionType tectonicRegionType, double duration, PoissonPointSourceData data, WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super(loc, tectonicRegionType, data, distCorrs);
            this.duration = duration;
            this.isPoissonian = true;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public double getDuration() {
            return this.duration;
        }

        public static double rateToProb(double rate, double time) {
            return 1.0 - Math.exp(-rate * time);
        }

        public static double probToRate(double P, double time) {
            return -Math.log(1.0 - P) / time;
        }

        @Override
        protected double getProbability(int nRupture, int dataIndex, double distCorrWeight) {
            double rate = ((PoissonPointSourceData)this.data).getRate(dataIndex) * distCorrWeight;
            return PoissonPointSource.rateToProb(rate, this.duration);
        }
    }

    private static class SiteAdaptiveNonPoissonPointSourceImpl<E extends SiteAdaptivePointSourceData<NonPoissonPointSourceData> & NonPoissonPointSourceData>
    extends NonPoissonPointSource
    implements SiteAdaptiveSource {
        private E data;
        private ConcurrentMap<NonPoissonPointSourceData, NonPoissonPointSource> sourceCache;

        public SiteAdaptiveNonPoissonPointSourceImpl(Location loc, TectonicRegionType tectonicRegionType, E data, WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super(loc, tectonicRegionType, (NonPoissonPointSourceData)data, distCorrs);
            this.data = data;
            if (data.isDiscrete()) {
                this.sourceCache = new ConcurrentHashMap<NonPoissonPointSourceData, NonPoissonPointSource>();
            }
        }

        @Override
        public void setDistCorrs(WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super.setDistCorrs((WeightedList)distCorrs);
            if (this.sourceCache != null) {
                this.sourceCache.clear();
            }
        }

        @Override
        public NonPoissonPointSource getForSite(Site site) {
            NonPoissonPointSourceData dataForSite = (NonPoissonPointSourceData)this.data.getForSite(site);
            if (dataForSite == this.data) {
                return this;
            }
            NonPoissonPointSource ret = null;
            if (this.sourceCache != null && (ret = (NonPoissonPointSource)this.sourceCache.get(dataForSite)) != null) {
                return ret;
            }
            ret = new NonPoissonPointSource(this.getLocation(), this.getTectonicRegionType(), dataForSite, this.getDistCorrs());
            if (this.sourceCache != null) {
                this.sourceCache.putIfAbsent(dataForSite, ret);
            }
            return ret;
        }
    }

    public static class NonPoissonPointSource
    extends BaseImplementation<NonPoissonPointSourceData> {
        public NonPoissonPointSource(Location loc, TectonicRegionType tectonicRegionType, NonPoissonPointSourceData data, WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super(loc, tectonicRegionType, data, distCorrs);
            this.isPoissonian = false;
        }

        @Override
        protected double getProbability(int sourceRuptureIndex, int dataRuptureIndex, double distCorrWeight) {
            return ((NonPoissonPointSourceData)this.data).getProbability(dataRuptureIndex) * distCorrWeight;
        }
    }

    private static abstract class BaseImplementation<E extends PointSourceData>
    extends PointSource {
        protected E data;
        private int numRuptures;
        private short[] dataIndexes;
        private short[] corrIndexes;

        public BaseImplementation(Location loc, TectonicRegionType tectonicRegionType, E data, WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super(loc, tectonicRegionType, distCorrs);
            this.data = data;
            if (data != null) {
                this.updateCountAndIndexes();
            }
        }

        public void setData(E data) {
            this.data = data;
            this.updateCountAndIndexes();
        }

        @Override
        public void setDistCorrs(WeightedList<PointSourceDistanceCorrection> distCorrs) {
            super.setDistCorrs(distCorrs);
            if (this.data != null) {
                this.updateCountAndIndexes();
            }
        }

        private void updateCountAndIndexes() {
            int dataRupCount = this.data.getNumRuptures();
            if (this.distCorrs == null || this.distCorrs.size() == 1) {
                this.numRuptures = dataRupCount;
                this.dataIndexes = null;
                this.corrIndexes = null;
            } else {
                Preconditions.checkState((dataRupCount < Short.MAX_VALUE ? 1 : 0) != 0);
                int numCorrs = this.distCorrs.size();
                Preconditions.checkState((numCorrs > 1 ? 1 : 0) != 0);
                Preconditions.checkState((numCorrs < Short.MAX_VALUE ? 1 : 0) != 0);
                int numIfNoFinite = dataRupCount * numCorrs;
                this.dataIndexes = new short[numIfNoFinite];
                this.corrIndexes = new short[numIfNoFinite];
                int index = 0;
                for (int d = 0; d < dataRupCount; d = (int)((short)(d + 1))) {
                    if (this.data.isFinite(d)) {
                        this.dataIndexes[index] = d;
                        this.corrIndexes[index] = -1;
                        ++index;
                        continue;
                    }
                    for (int i = 0; i < numCorrs; i = (int)((short)(i + 1))) {
                        this.dataIndexes[index] = d;
                        this.corrIndexes[index] = i;
                        ++index;
                    }
                }
                this.numRuptures = index;
                for (int i = index; i < numIfNoFinite; ++i) {
                    this.dataIndexes[i] = -1;
                    this.corrIndexes[i] = -1;
                }
            }
        }

        @Override
        public int getNumRuptures() {
            return this.numRuptures;
        }

        public E getData() {
            return this.data;
        }

        protected abstract double getProbability(int var1, int var2, double var3);

        @Override
        public ProbEqkRupture getRupture(int nRupture) {
            double distCorrWeight;
            PointSourceDistanceCorrection distCorr;
            int dataIndex;
            if (this.dataIndexes == null) {
                dataIndex = nRupture;
                if (this.distCorrs == null || this.data.isFinite(dataIndex)) {
                    distCorr = null;
                } else {
                    Preconditions.checkState((this.distCorrs.size() == 1 ? 1 : 0) != 0);
                    distCorr = (PointSourceDistanceCorrection)this.distCorrs.getValue(0);
                }
                distCorrWeight = 1.0;
            } else {
                dataIndex = this.dataIndexes[nRupture];
                short corrIndex = this.corrIndexes[nRupture];
                if (corrIndex < 0) {
                    distCorr = null;
                    distCorrWeight = 1.0;
                } else {
                    Preconditions.checkState((corrIndex < this.distCorrs.size() ? 1 : 0) != 0);
                    distCorr = (PointSourceDistanceCorrection)this.distCorrs.getValue(corrIndex);
                    distCorrWeight = this.distCorrs.getWeight(corrIndex);
                }
            }
            double mag = this.data.getMagnitude(dataIndex);
            double rake = this.data.getAveRake(dataIndex);
            RuptureSurface surf = this.data.getSurface(dataIndex);
            if (distCorr != null) {
                Preconditions.checkState((boolean)(surf instanceof PointSurface), (String)"Surface for rupture %s with data index %s was labeled as non-finite, but is not a PointSurface: %s", (Object)nRupture, (Object)dataIndex, (Object)surf);
                if (this.distCorrs.size() > 1) {
                    RuptureSurface copy = surf.copyShallow();
                    Preconditions.checkState((boolean)copy.getClass().equals(surf.getClass()), (String)"Shallow copy of surface with type %s is of a different type: %s", surf.getClass(), copy.getClass());
                    surf = copy;
                }
                ((PointSurface)surf).setDistanceCorrection(distCorr, mag);
            }
            Location hypo = this.data.getHypocenter(this.getLocation(), surf, dataIndex);
            double prob = this.getProbability(nRupture, dataIndex, distCorrWeight);
            return new ProbEqkRupture(mag, rake, prob, surf, hypo);
        }
    }

    public static interface FocalMechRuptureSurfaceBuilder
    extends RuptureSurfaceBuilder {
        default public FocalMech getMatchingEnum(FocalMechanism mech) {
            FocalMech mechEnum = FocalMech.forFocalMechanism(mech);
            Preconditions.checkNotNull((Object)((Object)mechEnum), (String)"No exact enum match for %s", (Object)mech);
            return mechEnum;
        }

        @Override
        default public int getNumSurfaces(double magnitude, FocalMechanism mech) {
            return this.getNumSurfaces(magnitude, this.getMatchingEnum(mech));
        }

        public int getNumSurfaces(double var1, FocalMech var3);

        @Override
        default public RuptureSurface getSurface(Location sourceLoc, double magnitude, FocalMechanism mech, int surfaceIndex) {
            return this.getSurface(sourceLoc, magnitude, this.getMatchingEnum(mech), surfaceIndex);
        }

        public RuptureSurface getSurface(Location var1, double var2, FocalMech var4, int var5);

        @Override
        default public double getSurfaceWeight(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return this.getSurfaceWeight(magnitude, this.getMatchingEnum(mech), surfaceIndex);
        }

        public double getSurfaceWeight(double var1, FocalMech var3, int var4);

        @Override
        default public boolean isSurfaceFinite(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return this.isSurfaceFinite(magnitude, this.getMatchingEnum(mech), surfaceIndex);
        }

        public boolean isSurfaceFinite(double var1, FocalMech var3, int var4);
    }

    public static interface SiteAdaptivePointSourceData<E extends PointSourceData>
    extends PointSourceData {
        public E getForSite(Site var1);

        default public boolean isDiscrete() {
            return false;
        }
    }

    public static interface NonPoissonPointSourceData
    extends PointSourceData {
        public double getProbability(int var1);
    }

    public static interface PointSourceData {
        public int getNumRuptures();

        public double getMagnitude(int var1);

        public double getAveRake(int var1);

        public RuptureSurface getSurface(int var1);

        public boolean isFinite(int var1);

        public Location getHypocenter(Location var1, RuptureSurface var2, int var3);
    }
}

